
/***********************************************************************
*                                                                      *
*   p4_defs.h                                                          *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/


#ifndef _P4_DEFS_H_
#define _P4_DEFS_H_

struct proc_info {
    Int slave_idx;		// id in cluster
    Int cluster_idx;  		// cluster id
    char host_name[HOSTNAME_LEN];     // ?????
};

// #define NUMAVAILS 8
// buffer 6,7,8 to large 64K, 256K, 1M
#define NUMAVAILS 5
 
struct p4_avail_buff {
    Int size;			/* size of message portion */
    struct p4_msg far *buff;
};

struct p4_cluster_data {
    Int		local_slave_count;					
    Int		low_cluster_id;						
    Int		hi_cluster_id;   					
    p4_barrier_monitor_t cluster_barrier;	
    P4VOID far *	cluster_shmem;				
    char 	application_id[16];       			
};

struct p4_global_data { /* in shmem - all members have access */
    struct proc_info proctable[P4_MAXPROCS];
    Int n_started_slaves;
    char my_host_name[HOSTNAME_LEN];
    struct p4_avail_buff avail_buffs[NUMAVAILS];
    p4_lock_t avail_buffs_lock;
    struct p4_queued_msg far *avail_quel;
    p4_lock_t avail_quel_lock;
    struct p4_msg_queue shmem_msg_queues[P4_MAX_MSG_QUEUES];
    Int num_in_proctable;
    Int num_installed;
    p4_lock_t slave_lock;
    Int dest_id[P4_MAXPROCS];
    long reference_time;  /* used in p4_initenv and p4_clock */
    p4_barrier_monitor_t global_barrier;		
    struct p4_procgroup far *procgroup;
    struct p4_cluster_data clustertab[P4_MAXCLUSTER];
};

extern struct p4_global_data far *p4_global;

struct local_data {		/* local to each process */
    HTASK hTask;
    Int my_id;
    Int local_commtype;		/* local or shmem messages */
    struct p4_msg_queue far *queued_messages; 
    P4BOOL am_bm;
    int conntypetab[P4_MAXPROCS];
//    struct p4_procgroup far *procgroup;
    Int soft_errors;		/* false if errors cause termination */
    Int brdcst_initialized;     /* True if structure is initialized */
    Int brdcst_up;              /* Process above me in brdcst tree  */
    Int brdcst_left_slave;      /* Id of left child slave           */
    Int brdcst_right_slave;     /* Id of right child slave          */
};

extern struct local_data *p4_localtab;


/* this struct is similar to a p4_net_msg_hdr;  note that the sum of
   the sizes of the items up to the *msg is equal to some number of 
   double words, which is important on machines like bfly2 if you 
   receive doubles into the msg area.
*/
/* link, orig_len, and pad are for the buffer itself*/
/* next fields are for the current message in the buffer */
struct p4_msg {
    struct p4_msg far *link;
    Int orig_len;
    Int pad;
    Int type;                
    Int to;
    Int from;
    Int ack_req;
    Int len;
    Int msg_id;		/* for i860 messages */
    Int data_type;	/* for use by xdr */
    char far *msg;	/* variable length array of characters */
};

struct p4_queued_msg {
    struct p4_msg far *qmsg;
    struct p4_queued_msg far *next;
};


#define P4_ACK_REQ_MASK   1     /* Masks define bits set for requests */
#define P4_ACK_REPLY_MASK 2
#define P4_BROADCAST_MASK 4

#endif // _P4_DEFS_H_
