
/***********************************************************************
*                                                                      *
*   p4.h                                                               *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#ifndef _P4_H_
#define _P4_H_

#include <windows.h>
#include <stdarg.h>

#include "p4_config.h"
#include "p4_MD.h"
#include "p4_mon.h"
#include "p4_sr.h"

#ifdef WIN31		// MSVC does not offer a switch: compile with 4byte int's
#ifndef Int 
#define Int long	// hope that does not cause too much trouble 
#endif

#define P4SCRX 80
#define P4SCRY 24
typedef LPSTR  far * LPPSTR;
typedef LPPSTR far * LPPPSTR;
#endif /* WIN31 */

// new for WIN31
#include "p4_defs.h"
#include "p4_funcs.h"

#ifndef P4_DPRINTFL
#define p4_dprintfl
#endif

// Usage of ALOG package not planned
#include "alog.h"

struct p4_procgroup_entry {
    char host_name[HOSTNAME_LEN];
    Int numslaves_in_group;
    char slave_full_pathname[200];
    char username[10];
};

struct p4_procgroup {
    Int num_entries;
    struct p4_procgroup_entry entries[P4_MAXCLUSTER];
};

#endif
   
