
/***********************************************************************
*                                                                      *
*   sys_bind.h                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          07/02/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/*
 *	WIN: Functions used only internally 
 */

void	MPID_P4_extract_long(void far *address, MPIR_RHANDLE far *dmpi_recv_handle, 
				Int len, void far *inbuf, Int from);
void	MPID_P4_extract_short(void far *address, MPIR_RHANDLE far *dmpi_recv_handle, 
				Int len, void far *inbuf);
double	MPID_P4_Wtick (void);
double	MPID_P4_Wtime (void);
void	DMPI_free_unexpected (MPIR_RHANDLE far *dmpi_recv_handle);
void	DMPI_get_from_contig( MPIR_SHANDLE far *handle, LPPVOID addr, 
				Int maxlen, Int far *actlen);
void	DMPI_get_into_contig (MPIR_SHANDLE far *handle, void far *addr, 
				Int maxlen, Int far *actlen);
void	DMPI_get_totallen(MPIR_SHANDLE far *handle, Int far *len);
void	DMPI_msg_arrived (Int src, Int tag, MPIR_CONTEXT context_id, 
				LPPMPIR_RHANDLE dmpi_recv_handle, Int far *foundflag);
void	DMPI_put_from_contig (MPIR_RHANDLE far *handle, void far *addr, Int maxlen);
void	DMPI_put_into_contig (MPIR_RHANDLE far *handle, LPPVOID addr, 
				Int maxlen, Int far *actlen);
void	DMPI_put_totallen(MPIR_RHANDLE far *handle, Int len);


Int		MPID_GetMsgDebugFlag(void);
void	MPID_PrintMsgDebug(void);
Int	MPID_SyncAck (Int mode);
void	MPID_SyncReturnAck(Int mode, Int from);
Int	MPID_P4_check_incoming (MPID_BLOCKING_TYPE is_blocking);
Int	MPID_P4_check_device( Int blocking);
//Int	MPID_P4_blocking_recv(MPIR_RHANDLE far *);
Int	MPID_P4_blocking_recv(MPIR_RHANDLE far *);
void	MPID_P4_Get_Sync_Id( Int far *mode, MPIR_SHANDLE far *, MPID_SHANDLE far *);
Int	MPID_P4_post_recv(MPIR_RHANDLE far *, Int far *);
Int	MPID_P4_Process_unexpected(MPIR_RHANDLE far *, MPIR_RHANDLE far *);
Int	MPID_P4_post_send (MPIR_SHANDLE far *dmpi_send_handle);
void	MPID_P4_complete_send (MPIR_SHANDLE far *, MPI_Status far *);
Int	MPID_P4_complete_recv (MPIR_RHANDLE far *);
void	MPID_P4_Node_name(char far *name, Int  len);

void	MPID_SetSyncDebugFlag( Int f);
//P4VOID	p4_set_dbg_level(Int level);
Int	MPID_P4_iprobe (Int tag, Int source, Int context_id, Int far *found, MPI_Status far *);
Int	MPID_P4_probe (Int tag, Int source, Int context_id, MPI_Status far *status);
void	MPID_P4_init(int far *argc, LPPSTR argv);

Int	MPIR_Attr_copy_node ( MPI_Comm comm, MPI_Comm comm_new, MPIR_HBT_node far *node);
Int	MPIR_Attr_copy_subtree ( MPI_Comm comm, MPI_Comm comm_new, 
				 MPIR_HBT far *tree, MPIR_HBT_node far *subtree);
Int	MPIR_Attr_copy ( MPI_Comm comm, MPI_Comm comm_new);
Int	MPIR_Attr_create_tree ( MPI_Comm comm);
Int	MPIR_Attr_dup_tree ( MPI_Comm comm, MPI_Comm new_comm);
Int	MPIR_Attr_free_node ( MPI_Comm comm, MPIR_HBT_node far *node);
Int	MPIR_Attr_free_subtree ( MPI_Comm comm, MPIR_HBT_node far *subtree);
Int	MPIR_Attr_free_tree ( MPI_Comm comm );
Int	MPIR_Comm_N2_prev ( MPI_Comm comm, Int far *N2_prev);
Int	MPIR_Comm_make_coll ( MPI_Comm comm, MPIR_COMM_TYPE comm_type);
Int	MPIR_Context_alloc ( MPI_Comm comm, Int num_contexts, MPIR_CONTEXT far *context);
Int	MPIR_Context_dealloc ( MPI_Comm comm, Int num, MPIR_CONTEXT context);
MPI_Group	MPIR_CreateGroup(Int np);
void	MPIR_dump_dte( MPI_Datatype dte, Int indent);
void	MPIR_Dump_group ( MPI_Group group);
void	MPIR_Dump_ranks ( Int n, Int far *ranks);
void	MPIR_Dump_ranges ( Int n, Int far *ranges);
Int 	MPIR_Group_N2_prev ( MPI_Group  group, Int far *N2_prev);
void	MPIR_dump_queue(MPIR_QHDR far *header);
Int	MPIR_enqueue(MPIR_QHDR far *header, void far *object, MPIR_QEL_TYPE object_type);
Int	MPIR_Error( MPI_Comm comm, Int code, char far *string, char far *file, Int line );
void	MPIR_FreeGroup( MPI_Group group);
Int	MPIR_Group_dup( MPI_Group group, MPI_Group far *new_group);
Int	MPIR_HBT_delete(MPIR_HBT far *tree, Int keyval, LPPMPIR_HBT_node node_out);
Int	MPIR_HBT_free_node ( MPIR_HBT_node far *node);
Int	MPIR_HBT_free_tree ( MPIR_HBT far *tree);
Int	MPIR_HBT_insert( MPIR_HBT far *tree, MPIR_HBT_node far *node);
Int	MPIR_HBT_lookup( MPIR_HBT far *tree, Int keyval, LPPMPIR_HBT_node node_out);
Int	MPIR_HBT_new_node ( Int keyval, void far *value, LPPMPIR_HBT_node node_out);
Int	MPIR_HBT_new_tree ( LPPMPIR_HBT tree_out);
MPI_Datatype	MPIR_Init_basic_datatype (int type, Int size);
Int	MPIR_Intercomm_high ( MPI_Comm  comm, Int far *high);
Int	MPIR_Pack ( void far *buf, Int count, MPI_Datatype type, void far *dest);
void	MPIR_Pack_size ( Int incount, MPI_Datatype  type, MPI_Comm comm, Int far *size);
Int	MPIR_Powers_of_2 ( Int  N, Int far *N2_next, Int far *N2_prev);
//void	MPIR_SBdestroy( MPIR_SBHeader far *sb);
void	MPIR_SBdestroy();
void	MPIR_SetToIdentity( MPI_Group g);
Int	MPIR_SetupUnPackMessage (char far *buf, Int  count, MPI_Datatype datatype, 
				Int  source, MPI_Request request);
void	MPIR_search_posted_queue( Int src, Int tag, MPIR_CONTEXT context_id, 
					Int far *found, Int flag, LPPMPIR_RHANDLE  handleptr);
Int	MPIR_search_unexpected_queue( Int src, Int tag, MPIR_CONTEXT context_id, 
					Int far *found, Int flag, LPPMPIR_RHANDLE handleptr);
void	MPIR_Sort_split_table ( Int size, Int rank, Int far *table, 
				Int far *head, Int far *list_size);
void	MPIR_Tab( Int n);
MPI_Datatype MPIR_Type_dup (MPI_Datatype datatype);
Int	MPIR_Type_permanent ( MPI_Datatype datatype);
Int	MPIR_Unpack ( void far *buf, Int count, MPI_Datatype type, void far *in);

