/*
 *  $Id: mpi_bc.h,v 1.18 1994/06/07 21:30:23 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   mpi_bc.h                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* user include file for MPI programs, with no dependencies */

#ifndef _MPI_INCLUDE_BC
#define _MPI_INCLUDE_BC

/* assorted defined constants */
#include "mpi_errno.h"              /* Error codes */

/* Generic error handling code.  This handles inserting the file and line
   number (in MPI) where the error occured.  In addition, it
   checks the error handler and calls the appropriate one.  Finally, 
   it returns the errorcode as its value */
#define MPIR_ERROR(comm,code,string) \
    MPIR_Error( comm, code, string, __FILE__, __LINE__ )
    
/* communication modes */
typedef enum { 
    MPIR_MODE_STANDARD = 0, 
    MPIR_MODE_READY = 1, 
    MPIR_MODE_SYNCHRONOUS = 2, 
    MPIR_MODE_RECV = 3,
    MPIR_MODE_SYNC_ACK = 4
	
} MPIR_Mode;

/* Value of tag in status for a cancelled message */
#define MPIR_MSG_CANCELLED (-3)

/* This is the only global state in MPI */
extern int MPIR_Has_been_initialized;
extern Int MPIR_Buffer_size;
extern void far *MPIR_Buffer;

#endif

