/*
 *  $Id: mpi.h,v 1.29 1994/05/30 20:39:59 doss Exp gropp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   mpiimpl.h                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* user include file for MPI programs */

#ifndef _MPIRIMPL_INCLUDE
#define _MPIRIMPL_INCLUDE

/* mpi.h includes most of the definitions (all of the user-visible ones) */
#include "mpi.h"

/* The rest of these contain the details of the structures that are not 
   user-visible */ 
#include "patchlevel.h"
#include "dmpiatom.h"
#include "mpi_bc.h"
#include "mpir.h"
#include "mpi_ad.h"

//WIN new
#include "sys_bind.h"

/* 
   mpiprof contains the renamings for the profiling interface.  For it to
   be loaded, the symbol MPI_BUILD_PROFILING must be defined.  This 
   will be used in the makefiles for the construction of the MPI library
   routines to build the profiling interface
 */
#include "mpiprof.h"

/* This is a HACK to allow the automatically generated Fortran wrappers
   to work on the rs6000's and other systems that do not post-pend 
   underscores to Fortran routines. 
   This is used ONLY when compiling the Fortran wrappers 
 */
/* #if defined(MPI_rs6000) || defined(MPI_NO_FORTRAN_USCORE)
#define mpi_send_ mpi_send
#define mpi_recv_ mpi_recv
#define mpi_get_count_ mpi_get_count
#define mpi_bsend_ mpi_bsend
#define mpi_ssend_ mpi_ssend
#define mpi_rsend_ mpi_rsend
#define mpi_buffer_attach_ mpi_buffer_attach
#define mpi_buffer_detach_ mpi_buffer_detach
#define mpi_isend_ mpi_isend
#define mpi_ibsend_ mpi_ibsend
#define mpi_issend_ mpi_issend
#define mpi_irsend_ mpi_irsend
#define mpi_irecv_ mpi_irecv
#define mpi_wait_ mpi_wait
#define mpi_test_ mpi_test
#define mpi_request_free_ mpi_request_free
#define mpi_waitany_ mpi_waitany
#define mpi_testany_ mpi_testany
#define mpi_waitall_ mpi_waitall
#define mpi_testall_ mpi_testall
#define mpi_waitsome_ mpi_waitsome
#define mpi_testsome_ mpi_testsome
#define mpi_iprobe_ mpi_iprobe
#define mpi_probe_ mpi_probe
#define mpi_cancel_ mpi_cancel
#define mpi_test_cancelled_ mpi_test_cancelled
#define mpi_send_init_ mpi_send_init
#define mpi_bsend_init_ mpi_bsend_init
#define mpi_ssend_init_ mpi_ssend_init
#define mpi_rsend_init_ mpi_rsend_init
#define mpi_recv_init_ mpi_recv_init
#define mpi_start_ mpi_start
#define mpi_startall_ mpi_startall
#define mpi_sendrecv_ mpi_sendrecv
#define mpi_sendrecv_replace_ mpi_sendrecv_replace
#define mpi_type_contiguous_ mpi_type_contiguous
#define mpi_type_vector_ mpi_type_vector
#define mpi_type_hvector_ mpi_type_hvector
#define mpi_type_indexed_ mpi_type_indexed
#define mpi_type_hindexed_ mpi_type_hindexed
#define mpi_type_struct_ mpi_type_struct
#define mpi_address_ mpi_address
#define mpi_type_extent_ mpi_type_extent
#define mpi_type_size_ mpi_type_size
#define mpi_type_count_ mpi_type_count
#define mpi_type_lb_ mpi_type_lb
#define mpi_type_ub_ mpi_type_ub
#define mpi_type_commit_ mpi_type_commit
#define mpi_type_free_ mpi_type_free
#define mpi_get_elements_ mpi_get_elements
#define mpi_pack_ mpi_pack
#define mpi_unpack_ mpi_unpack
#define mpi_pack_size_ mpi_pack_size
#define mpi_barrier_ mpi_barrier
#define mpi_bcast_ mpi_bcast 
#define mpi_gather_ mpi_gather
#define mpi_gatherv_ mpi_gatherv
#define mpi_scatter_ mpi_scatter
#define mpi_scatterv_ mpi_scatterv
#define mpi_allgather_ mpi_allgather
#define mpi_allgatherv_ mpi_allgatherv
#define mpi_alltoall_ mpi_alltoall
#define mpi_alltoallv_ mpi_alltoallv
#define mpi_reduce_ mpi_reduce
#define mpi_op_create_ mpi_op_create
#define mpi_op_free_ mpi_op_free
#define mpi_allreduce_ mpi_allreduce
#define mpi_reduce_scatter_ mpi_reduce_scatter
#define mpi_scan_ mpi_scan
#define mpi_group_size_ mpi_group_size
#define mpi_group_rank_ mpi_group_rank
#define mpi_group_translate_ranks_ mpi_group_translate_ranks
#define mpi_group_compare_ mpi_group_compare
#define mpi_comm_group_ mpi_comm_group
#define mpi_group_union_ mpi_group_union
#define mpi_group_intersection_ mpi_group_intersection
#define mpi_group_difference_ mpi_group_difference
#define mpi_group_incl_ mpi_group_incl
#define mpi_group_excl_ mpi_group_excl
#define mpi_group_range_incl_ mpi_group_range_incl
#define mpi_group_range_excl_ mpi_group_range_excl
#define mpi_group_free_ mpi_group_free
#define mpi_comm_size_ mpi_comm_size
#define mpi_comm_rank_ mpi_comm_rank
#define mpi_comm_compare_ mpi_comm_compare
#define mpi_comm_dup_ mpi_comm_dup
#define mpi_comm_create_ mpi_comm_create
#define mpi_comm_split_ mpi_comm_split
#define mpi_comm_free_ mpi_comm_free
#define mpi_comm_test_inter_ mpi_comm_test_inter
#define mpi_comm_remote_size_ mpi_comm_remote_size
#define mpi_comm_remote_group_ mpi_comm_remote_group
#define mpi_intercomm_create_ mpi_intercomm_create
#define mpi_intercomm_merge_ mpi_intercomm_merge
#define mpi_keyval_create_ mpi_keyval_create
#define mpi_keyval_free_ mpi_keyval_free
#define mpi_attr_put_ mpi_attr_put
#define mpi_attr_get_ mpi_attr_get
#define mpi_attr_delete_ mpi_attr_delete
#define mpi_cart_create_ mpi_cart_create
#define mpi_dims_create_ mpi_dims_create
#define mpi_graph_create_ mpi_graph_create
#define mpi_topo_test_ mpi_topo_test
#define mpi_graphdims_get_ mpi_graphdims_get
#define mpi_graph_get_ mpi_graph_get
#define mpi_cartdim_get_ mpi_cartdim_get
#define mpi_cart_get_ mpi_cart_get
#define mpi_cart_rank_ mpi_cart_rank
#define mpi_cart_coords_ mpi_cart_coords
#define mpi_graph_neighbors_count_ mpi_graph_neighbors_count
#define mpi_graph_neighbors_ mpi_graph_neighbors
#define mpi_cart_shift_ mpi_cart_shift
#define mpi_cart_sub_ mpi_cart_sub
#define mpi_cart_map_ mpi_cart_map
#define mpi_graph_map_ mpi_graph_map
#define mpi_get_processor_name_ mpi_get_processor_name
#define mpi_errhandler_create_ mpi_errhandler_create
#define mpi_errhandler_set_ mpi_errhandler_set
#define mpi_errhandler_get_ mpi_errhandler_get
#define mpi_errhandler_free_ mpi_errhandler_free
#define mpi_error_string_ mpi_error_string
#define mpi_error_class_ mpi_error_class
#define mpi_wtime_ mpi_wtime
#define mpi_wtick_ mpi_wtick
#define mpi_init_ mpi_init
#define mpi_finalize_ mpi_finalize
#define mpi_initialized_ mpi_initialized
#define mpi_abort_ mpi_abort
#define mpi_pcontrol_ mpi_pcontrol

#endif */

#endif
