/*
 *  $Id: dmpi.h,v 1.6 1994/05/10 22:34:50 doss Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   dmpi.h                                                             *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* mpir version of device interface */

#include "mpir.h"

#ifndef _DMPI_INCLUDE
#define _DMPI_INCLUDE

#define  DMPI_mark_send_completed(DMPI_send_handle) \
          	(DMPI_send_handle)->completed = MPIR_YES;
#define  DMPI_mark_recv_completed(DMPI_recv_handle) \
          	(DMPI_recv_handle)->completed = MPIR_YES;

#define DMPI_mpid_recv_handle_from_rhandle( a, b ) b = &((a)->dev_rhandle)

#define DMPI_search_unexpected_queue(src,tag,ctxt_id,found,flag,unex) 				\
		if (MPIR_unexpected_recvs.first) 											\
			MPIR_search_unexpected_queue( src, tag, ctxt_id, found, flag, unex );	\
		else \
			*(found) = 0;
 
/* Defined but do nothing */
#define DMPI_check_mpi(blocking)
#endif


