
/***********************************************************************
*                                                                      *
*   binding.h                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#ifndef __MPI_BINDINGS
#define __MPI_BINDINGS

/* #ifdef __STDC__ 
WIN: we want to use the C type checking, 
	but also the single-line comments for temporary comments */
Int MPI_Send(void far * buf, Int count, MPI_Datatype datatype, Int dest, Int tag, 
	     MPI_Comm comm);
Int MPI_Recv(void far * buf, Int count, MPI_Datatype datatype, Int source, 
	     Int tag, MPI_Comm comm, MPI_Status  far *status);
Int MPI_Get_count(MPI_Status status, MPI_Datatype datatype, Int  far *count);
Int MPI_Bsend(void far * buf, Int count, MPI_Datatype datatype, Int dest, Int tag, 
	      MPI_Comm comm);
Int MPI_Ssend(void far * buf, Int count, MPI_Datatype datatype, Int dest, Int tag, 
	      MPI_Comm comm);
Int MPI_Rsend(void far * buf, Int count, MPI_Datatype datatype, Int dest, Int tag, 
	      MPI_Comm comm);
Int MPI_Buffer_attach( void far * buffer, Int size);
Int MPI_Buffer_detach( LPPVOID buffer, Int far * size);
Int MPI_Isend(void far * buf, Int count, MPI_Datatype datatype, Int dest, Int tag, 
	      MPI_Comm comm, MPI_Request  far *request);
Int MPI_Ibsend(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
	       Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Issend(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
	       Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Irsend(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
	       Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Irecv(void far * buf, Int count, MPI_Datatype datatype, Int source, 
	      Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Wait(MPI_Request  far *request, MPI_Status  far *status);
Int MPI_Test(MPI_Request  far *request, Int  far *flag, MPI_Status  far *status);
Int MPI_Request_free(MPI_Request  far *request);
Int MPI_Waitany(Int count, MPI_Request  far *array_of_requests, Int  far *index, 
		MPI_Status  far *status);
Int MPI_Testany(Int count, MPI_Request  far *array_of_requests, Int  far *index, 
		Int  far *flag, MPI_Status  far *status);
Int MPI_Waitall(Int count, MPI_Request  far *array_of_requests, 
		MPI_Status  far *array_of_statuses);
Int MPI_Testall(Int count, MPI_Request  far *array_of_requests, Int  far *flag, 
		MPI_Status  far *array_of_statuses);
Int MPI_Waitsome(Int incount, MPI_Request  far *array_of_requests, Int  far *outcount, 
		 Int  far *array_of_indices, MPI_Status  far *array_of_statuses);
Int MPI_Testsome(Int incount, MPI_Request  far *array_of_requests, Int  far *outcount, 
		 Int  far *array_of_indices, MPI_Status  far *array_of_statuses);
Int MPI_Iprobe(Int source, Int tag, MPI_Comm comm, Int  far *flag, 
	       MPI_Status  far *status);
Int MPI_Probe(Int source, Int tag, MPI_Comm comm, MPI_Status  far *status);
Int MPI_Cancel(MPI_Request  far *request);
Int MPI_Test_cancelled(MPI_Status status, Int  far *flag);
Int MPI_Send_init(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
		  Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Bsend_init(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
		   Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Ssend_init(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
		   Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Rsend_init(void far * buf, Int count, MPI_Datatype datatype, Int dest, 
		   Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Recv_init(void far * buf, Int count, MPI_Datatype datatype, Int source, 
		  Int tag, MPI_Comm comm, MPI_Request  far *request);
Int MPI_Start(MPI_Request  far *request);
Int MPI_Startall(Int count, MPI_Request  far *array_of_requests);
Int MPI_Sendrecv(void  far *sendbuf, Int sendcount, MPI_Datatype sendtype, 
		 Int dest, Int sendtag, void  far *recvbuf, Int recvcount, 
		 MPI_Datatype recvtype, Int source, Int recvtag, 
		 MPI_Comm comm, MPI_Status  far *status);
Int MPI_Sendrecv_replace(void far * buf, Int count, MPI_Datatype datatype, 
			 Int dest, Int sendtag, Int source, Int recvtag, 
			 MPI_Comm comm, MPI_Status  far *status);
Int MPI_Type_contiguous(Int count, MPI_Datatype oldtype, 
			MPI_Datatype  far *newtype);
Int MPI_Type_vector(Int count, Int blocklength, Int stride, 
		    MPI_Datatype oldtype, MPI_Datatype  far *newtype);
Int MPI_Type_hvector(Int count, Int blocklength, MPI_Aint stride, 
		     MPI_Datatype oldtype, MPI_Datatype  far *newtype);
Int MPI_Type_indexed(Int count, Int  far *array_of_blocklengths, 
		     Int  far *array_of_displacements, MPI_Datatype oldtype, 
		     MPI_Datatype  far *newtype);
Int MPI_Type_hindexed(Int count, Int  far *array_of_blocklengths, 
		      MPI_Aint  far *array_of_displacements, MPI_Datatype oldtype, 
		      MPI_Datatype  far *newtype);
Int MPI_Type_struct(Int count, Int  far *array_of_blocklengths, 
		    MPI_Aint  far *array_of_displacements, 
		    MPI_Datatype  far *array_of_types, MPI_Datatype  far *newtype);
Int MPI_Address(void far * location, MPI_Aint  far *address);
Int MPI_Type_extent(MPI_Datatype datatype, MPI_Aint  far *extent);
Int MPI_Type_size(MPI_Datatype datatype, MPI_Aint  far *size);
Int MPI_Type_count(MPI_Datatype datatype, Int  far *count);
Int MPI_Type_lb(MPI_Datatype datatype, Int far * displacement);
Int MPI_Type_ub(MPI_Datatype datatype, Int far * displacement);
Int MPI_Type_commit(MPI_Datatype  far *datatype);
Int MPI_Type_free(MPI_Datatype  far *datatype);
Int MPI_Get_elements(MPI_Status status, MPI_Datatype datatype, Int  far *count);
Int MPI_Pack(void far * inbuf, Int incount, MPI_Datatype datatype, void  far *outbuf, 
	     Int outsize, Int  far *position,  MPI_Comm comm);
Int MPI_Unpack(void far * inbuf, Int insize, Int  far *position, void  far *outbuf, 
	       Int outcount, MPI_Datatype datatype, MPI_Comm comm);
Int MPI_Pack_size (Int incount, MPI_Datatype datatype, MPI_Comm comm, Int  far *size);
Int MPI_Barrier(MPI_Comm comm );
Int MPI_Bcast(void far * buffer, Int count, MPI_Datatype datatype, Int root, 
	      MPI_Comm comm );
Int MPI_Gather(void far * sendbuf, Int sendcount, MPI_Datatype sendtype, 
	       void far * recvbuf, Int recvcount, MPI_Datatype recvtype, 
	       Int root, MPI_Comm comm); 
Int MPI_Gatherv(void far * sendbuf, Int sendcount, MPI_Datatype sendtype, 
		void far * recvbuf, Int  far *recvcounts, Int  far *displs, 
		MPI_Datatype recvtype, Int root, MPI_Comm comm); 
Int MPI_Scatter(void far * sendbuf, Int sendcount, MPI_Datatype sendtype, 
		void far * recvbuf, Int recvcount, MPI_Datatype recvtype, 
		Int root, MPI_Comm comm);
Int MPI_Scatterv(void far * sendbuf, Int  far *sendcounts, Int  far *displs, 
		 MPI_Datatype sendtype, void far * recvbuf, Int recvcount, 
		 MPI_Datatype recvtype, Int root, MPI_Comm comm);
Int MPI_Allgather(void far * sendbuf, Int sendcount, MPI_Datatype sendtype, 
		  void far * recvbuf, Int recvcount, MPI_Datatype recvtype, 
		  MPI_Comm comm);
Int MPI_Allgatherv(void far * sendbuf, Int sendcount, MPI_Datatype sendtype, 
		   void far * recvbuf, Int  far *recvcounts, Int  far *displs, 
		   MPI_Datatype recvtype, MPI_Comm comm);
Int MPI_Alltoall(void far * sendbuf, Int sendcount, MPI_Datatype sendtype, 
		 void far * recvbuf, Int recvcount, MPI_Datatype recvtype, 
		 MPI_Comm comm);
Int MPI_Alltoallv(void far * sendbuf, Int  far *sendcounts, Int  far *sdispls, 
		  MPI_Datatype sendtype, void far * recvbuf, Int  far *recvcounts, 
		  Int  far *rdispls, MPI_Datatype recvtype, MPI_Comm comm);
Int MPI_Reduce(void far * sendbuf, void far * recvbuf, Int count, 
	       MPI_Datatype datatype, MPI_Op op, Int root, MPI_Comm comm);
Int MPI_Op_create(MPI_Uop  far *function, Int commute, MPI_Op  far *op);
Int MPI_Op_free( MPI_Op  far *op);
Int MPI_Allreduce(void far * sendbuf, void far * recvbuf, Int count, 
		  MPI_Datatype datatype, MPI_Op op, MPI_Comm comm);
Int MPI_Reduce_scatter(void far * sendbuf, void far * recvbuf, Int  far *recvcounts, 
		       MPI_Datatype datatype, MPI_Op op, MPI_Comm comm);
Int MPI_Scan(void far * sendbuf, void far * recvbuf, Int count, MPI_Datatype datatype, 
	     MPI_Op op, MPI_Comm comm );
Int MPI_Group_size(MPI_Group group, Int  far *size);
Int MPI_Group_rank(MPI_Group group, Int  far *rank);
Int MPI_Group_translate_ranks (MPI_Group group1, Int n, Int  far *ranks1, 
			       MPI_Group group2, Int  far *ranks2);
Int MPI_Group_compare(MPI_Group group1, MPI_Group group2, Int  far *result);
Int MPI_Comm_group(MPI_Comm comm, MPI_Group  far *group);
Int MPI_Group_union(MPI_Group group1, MPI_Group group2, MPI_Group  far *newgroup);
Int MPI_Group_intersection(MPI_Group group1, MPI_Group group2, 
			   MPI_Group  far *newgroup);
Int MPI_Group_difference(MPI_Group group1, MPI_Group group2, 
			 MPI_Group  far *newgroup);
Int MPI_Group_incl(MPI_Group group, Int n, Int  far *ranks, MPI_Group  far *newgroup);
Int MPI_Group_excl(MPI_Group group, Int n, Int  far *ranks, MPI_Group  far *newgroup);
Int MPI_Group_range_incl(MPI_Group group, Int n, Int far ranges[][3], 
			 MPI_Group  far *newgroup);
Int MPI_Group_range_excl(MPI_Group group, Int n, Int far ranges[][3], 
			 MPI_Group  far *newgroup);
Int MPI_Group_free(MPI_Group  far *group);
Int MPI_Comm_size(MPI_Comm comm, Int  far *size);
Int MPI_Comm_rank(MPI_Comm comm, Int  far *rank);
Int MPI_Comm_compare(MPI_Comm comm1, MPI_Comm comm2, Int  far *result);
Int MPI_Comm_dup(MPI_Comm comm, MPI_Comm  far *newcomm);
Int MPI_Comm_create(MPI_Comm comm, MPI_Group group, MPI_Comm  far *newcomm);
Int MPI_Comm_split(MPI_Comm comm, Int color, Int key, MPI_Comm  far *newcomm);
Int MPI_Comm_free(MPI_Comm  far *comm);
Int MPI_Comm_test_inter(MPI_Comm comm, Int  far *flag);
Int MPI_Comm_remote_size(MPI_Comm comm, Int  far *size);
Int MPI_Comm_remote_group(MPI_Comm comm, MPI_Group  far *group);
Int MPI_Intercomm_create(MPI_Comm local_comm, Int local_leader, 
			 MPI_Comm peer_comm, Int remote_leader, 
			 Int tag, MPI_Comm  far *newintercomm);
Int MPI_Intercomm_merge(MPI_Comm intercomm, Int high, MPI_Comm  far *newintracomm);
Int MPI_Keyval_create(MPI_Copy_function  far *copy_fn, 
		      MPI_Delete_function  far *delete_fn, 
		      Int  far *keyval, void far * extra_state);
Int MPI_Keyval_free(Int  far *keyval);
Int MPI_Attr_put(MPI_Comm comm, Int keyval, void far * attribute_val);
Int MPI_Attr_get(MPI_Comm comm, Int keyval, LPPVOID attribute_val, Int  far *flag);
Int MPI_Attr_delete(MPI_Comm comm, Int keyval);
Int MPI_Topo_test(MPI_Comm comm, Int  far *status);
Int MPI_Cart_create(MPI_Comm comm_old, Int ndims, Int  far *dims, Int  far *periods,
		    Int reorder, MPI_Comm  far *comm_cart);
Int MPI_Dims_create(Int nnodes, Int ndims, Int  far *dims);
Int MPI_Graph_create(MPI_Comm comm_old, Int nnodes, Int  far *index, Int  far *edges,
		     Int reorder, MPI_Comm  far *comm_graph);
Int MPI_Graphdims_Get(MPI_Comm comm, Int  far *nnodes, Int  far *nedges);
Int MPI_Graph_get(MPI_Comm comm, Int maxindex, Int maxedges, Int  far *index,
		  Int  far *edges);
Int MPI_Cartdim_get(MPI_Comm comm, Int  far *ndims);
Int MPI_Cart_get(MPI_Comm comm, Int maxdims, Int  far *dims, Int  far *periods,
		 Int  far *coords);
Int MPI_Cart_rank(MPI_Comm comm, Int  far *coords, Int  far *rank);
Int MPI_Cart_coords(MPI_Comm comm, Int rank, Int maxdims, Int  far *coords);
Int MPI_Graph_neighbors_count(MPI_Comm comm, Int rank, Int  far *nneighbors);
Int MPI_Graph_neighbors(MPI_Comm comm, Int rank, Int  far *maxneighbors,
			Int  far *neighbors);
Int MPI_Cart_shift(MPI_Comm comm, Int direction, Int disp, 
		   Int  far *rank_source, Int  far *rank_dest);
Int MPI_Cart_sub(MPI_Comm comm, Int  far *remain_dims, MPI_Comm  far *newcomm);
Int MPI_Cart_map(MPI_Comm comm, Int ndims, Int  far *dims, Int  far *periods, 
		 Int  far *newrank);
Int MPI_Graph_map(MPI_Comm comm, Int nnodes, Int  far *index, Int  far *edges,
		  Int  far *newrank);    
Int MPI_Get_processor_name(char  far *name, Int  far *result_len);
Int MPI_Errhandler_create(MPI_Handler_function *function, 
			  MPI_Errhandler *errhandler);
Int MPI_Errhandler_set(MPI_Comm comm, MPI_Errhandler errhandler);
Int MPI_Errhandler_get(MPI_Comm comm, MPI_Errhandler *errhandler);
Int MPI_Errhandler_free(MPI_Errhandler  far *errhandler);
Int MPI_Error_string(Int errorcode, char *string, Int *result_len);
Int MPI_Error_class(Int errorcode, Int  far *errorclass);
double MPI_Wtime(void);
double MPI_Wtick(void);
int MPI_Init(int  far *argc, LPPSTR far *argv);
Int MPI_Finalize(void);
Int MPI_Initialized(Int  far * flag);
Int MPI_Abort(MPI_Comm comm, Int errorcode);
Int MPI_Pcontrol(const Int level, ...);

Int MPI_NULL_COPY_FN ( MPI_Comm  far * oldcomm, Int  far *keyval, void  far *extra_state, 
		       void  far *attr_in, void  far * far *attr_out, Int  far *flag );
Int MPI_NULL_DELETE_FN ( MPI_Comm  far *comm, Int  far *keyval, void  far *attr, 
			 void  far *extra_state );
void MPI_Win_yield (void);

// WinMPI keep for shared-memory or far memory allocation 
// remove when switched to large memory model (malloc is _farmalloc then)
// MEMORY ATTRIBUTES CHANGED !!!
void 	   far __pascal p4_shfree(void far *p);
char far * far __pascal	p4_shmalloc(unsigned long n);


/* #else 
extern double MPI_Wtime();
extern double MPI_Wtick();

extern Int MPI_NULL_COPY_FN(), MPI_NULL_DELETE_FN();
#endif */

#endif
