c Get a new communicator for a decomposition of the domain 
c and my position in it
      call MPI_CART_CREATE( MPI_COMM_WORLD, 1, numprocs, .false.,
     $     .true., comm1d, ierr )
      call MPI_COMM_RANK( comm1d, myid, ierr )
      call MPI_CART_SHIFT( comm1d, 0,  1, nbrbottom, nbrtop, ierr )
c Compute the actual decomposition
      call MPE_DECOMP1D( ny, numprocs, myid, s, e )
c Initialize the right-hand-side (f) and the initial solution guess (a)
      call ONEDINIT( a, b, f, nx, s, e )
c
c Actually do the computation.  Note the use of a collective operation to
c check for convergence, and a do-loop to bound the number of iterations.
c
      do 10 it=1, maxit
c                    get ghost points        
	call EXCHNG1( a, nx, s, e, comm1d, nbrbottom, nbrtop )
c                    perform one Jacobi "sweep"
	call SWEEP1D( a, f, nx, s, e, b )
c                    repeat to get a solution back into array a
	call EXCHNG1( b, nx, s, e, comm1d, nbrbottom, nbrtop )
	call SWEEP1D( b, f, nx, s, e, a )
c                    check for convergence
	diffw = DIFF( a, b, nx, s, e )
	call MPI_ALLREDUCE( diffw, diffnorm, 1, MPI_DOUBLE_PRECISION, 
     $                      MPI_SUM, comm1d, ierr )
        if (diffnorm .lt. 1.0e-5) goto 20
        if (myid .eq. 0) print *, 2*it, ' Difference is ', diffnorm
10     continue
      if (myid .eq. 0) print *, 'Failed to converge'
20    continue
      if (myid .eq. 0) then
          print *, 'Converged after ', 2*it, ' Iterations'
      endif
