/*
    This is a subroutine to test Bill Gropp's scheduling routine,
    which loops through a data structure of processor send and recvs and
    decides when to do each send and/or recv.  
    Odd/Even (w/r to a 1 bit mask) communications are done first.
    Odds recv before sending, if doing both.
    Evens send before recving, if doing both.
*/


#include <stdio.h>

schedule(myid, sendrecv,srlength) 
     
int myid, srlength;
int sendrecv[][3];

{
  
  int mask, done, i, sr, nbr ;
  FILE *fp;
  /* FILE *fopen(char *name, char *mode); */
  fp = fopen("results", "a");


     /********************************************************** 
       sendrecv is the data structure in which the first column
       is the processor (neighbor), the second column is either
       0 or 1 (send or recv, respectively), the third is a 0 or
       1 denoting the status of that row, processed or not.
     **********************************************************/
  
  mask = 0x1;
  done = 0;
  fprintf(fp,"myid = %d \n",myid);

  while (!done) {
    

    for (i = 0; i < srlength; i++) {

      if ( !sendrecv[i][2] )        /* if not processed */   {

	nbr = sendrecv[i][0];       /* just for convenience, */
	sr  = sendrecv[i][1];       /* assign to variables   */

	if ( !(myid & mask) && (nbr & mask) && (sr == 0) ) {
	  fprintf(fp,"Proc %d  send \n",nbr);
	  sendrecv[i][2] = 1;       /*  mark as processed    */
	}
	
	else if ( (myid & mask) && !(nbr & mask) && (sr == 1) ) {
	  fprintf(fp,"Proc %d  recv \n",nbr);
	  sendrecv[i][2] = 1;
	}

      }
    
    }


    for (i = 0; i < srlength; i++) {

      if ( !sendrecv[i][2] )        /* if not processed */   {

	nbr = sendrecv[i][0];       /* just for convenience, */
	sr  = sendrecv[i][1];       /* assign to variables   */

	if ( !(myid & mask) && (nbr & mask) && (sr == 1) ) {
	  fprintf(fp,"Proc %d  recv \n",nbr);
	  sendrecv[i][2] = 1;       /*  mark as processed    */
	}
	
	else if ( (myid & mask) && !(nbr & mask) && (sr == 0) ) {
	  fprintf(fp,"Proc %d  send \n",nbr);
	  sendrecv[i][2] = 1;
	}

      }
	
    }      
	    
	      
    mask <<= 1;
    
    /* Calculate done-ness */
    done = 1;
    for (i = 0; i < srlength; i++)  {
      done = (done & sendrecv[i][2]);
    }
	     
  }

  exit(0);
} 
	      
	      
	      
