


#ifndef lint
static char vcid[] = "$Id: meshhelp.c,v 1.1.1.1 1998/08/27 19:16:37 gropp Exp $";
#endif

/* 
   Helper routines for using the mesh communication package.
   These routines generate the program entries for connecting
   two sides together.  
 */
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include "blkcm/mesh.h"
#include <stdio.h>

/*
   This routine builds a program to communicate a given edge of
   on rectangle with the given edge of the other.  Basically, 
   it does nothing but handle the obvious book-keeping.

   input parameters:
   p1        - pointer to first (source) rectangle
   s1        - side to send
   mx, my    - declared sizes
   nx, ny    - actual size
   bsize     - buffer offset
   p2        - pointer to dest (same size as source)
   s2        - side of dest.
   id1,id2   - id's of the two entries

   NOTE: Sets TWO (2) pgm entries (one for each direction)
 */
int BCjoin2( Program, line, p1, s1, mx, my, nx, ny, bsize, p2, s2, id1, id2 )
BCPGM      *Program;
void       *p1, *p2;
int        s1, mx, my, nx, ny, s2, line, id1, id2;
{
BCentry *pgm;
int        phase;

phase = BCphase( s1 );
pgm   = (*Program->getline)( Program, line );
BCset_vals( &pgm->src,  p1, s1, mx, my, nx, ny, bsize, 1, phase );
pgm->id = id2;
pgm->phase = phase;
SET_MAJOR_MODE(pgm,BLOCK_COMM_SRC);
pgm = (*Program->getline)( Program, line + 1 );
BCset_vals( &pgm->src, p2, s2, mx, my, nx, ny, bsize, 0, phase );
pgm->id = id2;
pgm->phase = phase;
SET_MAJOR_MODE(pgm,BLOCK_COMM_DEST);
pgm = (*Program->getline)( Program, line + 2 );

phase = BCphase( s2 );
BCset_vals( &pgm->src,  p2, s2, mx, my, nx, ny, bsize, 1, phase );
pgm->id = id1;
pgm->phase = phase;
SET_MAJOR_MODE(pgm,BLOCK_COMM_SRC);
pgm = (*Program->getline)( Program, line + 3 );
BCset_vals( &pgm->src, p1, s1, mx, my, nx, ny, bsize, 0, phase );
pgm->id = id1;
pgm->phase = phase;
SET_MAJOR_MODE(pgm,BLOCK_COMM_DEST);

if (Program->maxdim < 1) Program->maxdim = 1;
return 0;
}

int BCjoin_nbr( Program, line, 
	       p1, s1, mx, my, nx, ny, bsize, s2, proc2, id1, id2 )
BCPGM      *Program;
void       *p1;
int        line, s1, mx, my, nx, ny, bsize, s2, proc2, id1, id2;
{
BCentry *pgm;

pgm = (*Program->getline)( Program, line );
pgm->phase     = BCphase( s1 );
BCset_vals( &pgm->src, p1, s1, mx, my, nx, ny, bsize, 1, pgm->phase );
/* message types must be set consistently; they will use the "id" field */
pgm->type      = BLOCK_COMM_SRC;
pgm->id        = id2 + (BCphase( s2 ) << 3);
pgm->processor = proc2;
/* pgm->inplace   = 1; */

pgm = (*Program->getline)( Program, line + 1 );
pgm->phase     = BCphase( s2 );
BCset_vals( &pgm->src, p1, s1, mx, my, nx, ny, bsize, 0, pgm->phase );
pgm->type      = BLOCK_COMM_DEST;
pgm->id        = id1 + (BCphase( s1 ) << 3);
pgm->processor = proc2;
/* pgm->inplace   = 1; */

if (Program->maxdim < 1) Program->maxdim = 1;
return 0;
}

/* These should be private routines */
/*
    This routine converts the direction into a phase value that
    needs to be used to insure that the messages do not collide
 */
int BCphase( dir )
int dir;
{
switch (dir) {
    case BC_NORTH: return 3;
    case BC_WEST:  return 0;
    case BC_SOUTH: return 1;
    case BC_EAST:  return 2;
    }
/* on unknown, use -1 */
return -1;
}

/* If qsource is false, move into the buffer */
int BCset_vals( s, p1, side, mx, my, nx, ny, bsize, qsource, phase )
slab   *s;
void   *p1;
int    side, mx, my, nx, ny, bsize, qsource, phase;
{
double *bp;
s->n2 = 1;
s->n3 = 1;
s->n4 = 1;
s->n5 = 1;
s->inc1= mx;
s->inc2= my;
s->inc3= 1;
s->inc4= 1;
bp = ((double *)p1) + bsize * (mx + 1);     /* lower left corner */
switch (side) {
    case BC_NORTH: s->s1 = 1;
                bp += (ny - 1) * mx;
                if (!qsource) bp += mx;
                if (phase > 2) bp -= 1;
                s->n1 = nx;
                break;
    case BC_SOUTH: s->s1 = 1;
                if (!qsource) bp -= mx;
                if (phase > 2) bp -= 1;
                s->n1 = nx;
                break;
    case BC_EAST:  s->s1 = mx;
                bp += (nx - 1);
                if (!qsource) bp += 1;
                if (phase > 2) bp -= mx;
                s->n1 = ny;
                break;
    case BC_WEST:  s->s1 = mx;
                if (!qsource) bp -= 1;
                if (phase > 2) bp -= mx;
                s->n1 = ny;
                break;
    }
s->lctx = (void *)bp;

/* extend the length of the buffer */
if (phase > 0) s->n1++;
if (phase == 3) s->n1++;

return 0;
}

#ifdef DISTRIBUTED_MEMORY
/*
   This routine creates the program for a rectangular grouping of
   domains, all of which are the same size
 */
/*ARGSUSED*/
BCPGM *BCBuildMesh( mx, my, mz, mdx, mdy, p, proc_map )
int    mx, my, mz, mdx, mdy;
void   *p;
BCProcMap *proc_map;
{
BCPGM *Program;
int   line = 0, nbr, myid;
Program = BCalloc( 8 );

/* As it stands, this code assumes that there is an exact match between
   domains and processors */
myid = proc_map->i + proc_map->j * proc_map->nx;
if (proc_map->i != 0) {
    nbr = BCNbr( proc_map, -1, 0 );
    BCjoin_nbr( Program, line,
		   p, BC_WEST,  mx, my, mdx, mdy, 0, BC_EAST, nbr, myid, myid-1 );
    line += 2;
    }
if (proc_map->j != 0) {
    nbr = BCNbr( proc_map, 0, -1 );
    BCjoin_nbr( Program, line,
		  p, BC_SOUTH, mx, my, mdx, mdy, 0, BC_NORTH, nbr, myid, 
		  myid-proc_map->nx );
    line += 2;
    }
if (proc_map->i < proc_map->nx-1) {
    nbr = BCNbr( proc_map, 1, 0 );
    BCjoin_nbr( Program, line,
		  p, BC_EAST,  mx, my, mdx, mdy, 0, BC_WEST, nbr, myid, myid+1 );
    line += 2;
    }
if (proc_map->j < proc_map->ny-1) {
    nbr = BCNbr( proc_map, 0, 1 );
    BCjoin_nbr( Program, line,
		  p, BC_NORTH, mx, my, mdx, mdy, 0, BC_SOUTH, nbr, myid, 
		  myid+proc_map->nx );
    line += 2;
    }
return Program;
}

BCProcMap *BCBuildProcMap( nx, ny )
int nx, ny;
{
BCProcMap *proc_map;
int       i;

proc_map = (BCProcMap *)malloc((unsigned)(sizeof( BCProcMap ) ));
if (!proc_map) return 0;
proc_map->nx = nx;
proc_map->ny = ny;
proc_map->map= (int *)malloc((unsigned)((unsigned)(nx * ny * sizeof(int) ) ));
for (i=0; i<nx*ny; i++)
    proc_map->map[i] = i;
proc_map->j = __MYPROCID / nx;
proc_map->i = __MYPROCID % nx;
return proc_map;
}

int BCNbr( proc_map, di, dj )
BCProcMap *proc_map;
int       di, dj;
{
return proc_map->map[proc_map->i + di + (proc_map->j + dj) * proc_map->nx];
}
#endif
