

/* gtol.c */
/* Fortran interface file */
#include <stdio.h>
#include "blkcm/bc.h"
#include "blkcm/mesh.h"

#ifdef POINTER_64_BITS
extern void *__ToPointer();
extern int __FromPointer();
extern void __RmPointer();
#else
#define __ToPointer(a) (a)
#define __FromPointer(a) (int)(a)
#define __RmPointer(a)
#endif

#ifdef FORTRANUNDERSCORE
#define pow_ pow
#endif

#include <stdio.h>
#ifdef FORTRANCAPS
#define bcglobaltolocalarray_ BCGLOBALTOLOCALARRAY
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcglobaltolocalarray_ bcglobaltolocalarray
#endif
void  bcglobaltolocalarray_( nd, sz, nproc, myid)
int         *nd, *nproc, *myid;
BCArrayPart *sz[];
{
BCGlobalToLocalArray(*nd,sz,*nproc,*myid);
}
#ifdef FORTRANCAPS
#define bcprintarraypart_ BCPRINTARRAYPART
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcprintarraypart_ bcprintarraypart
#endif
void  bcprintarraypart_( fp, nd, sz)
FILE        *fp;
int         *nd;
BCArrayPart *sz[];
{
FILE *_fp0 = stdout;
BCPrintArrayPart(_fp0,*nd,sz);
}
#ifdef FORTRANCAPS
#define bcprintarraypartverbose_ BCPRINTARRAYPARTVERBOSE
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcprintarraypartverbose_ bcprintarraypartverbose
#endif
void  bcprintarraypartverbose_( fp, nd, sz)
FILE        *fp;
int         *nd;
BCArrayPart *sz[];
{
FILE *_fp0 = stdout;
BCPrintArrayPartVerbose(_fp0,*nd,sz);
}
#ifdef FORTRANCAPS
#define bcbuildarraypgm_ BCBUILDARRAYPGM
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcbuildarraypgm_ bcbuildarraypgm
#endif
int bcbuildarraypgm_( nd, sz, nproc, myid, nbyte)
int         *nd;
BCArrayPart *sz[];
int         *nproc, *myid, *nbyte;
{
return __FromPointer( (void *)( BCBuildArrayPGM(*nd,sz,*nproc,*myid,*nbyte) ));
}
#ifdef FORTRANCAPS
#define bcsetghostwidths_ BCSETGHOSTWIDTHS
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcsetghostwidths_ bcsetghostwidths
#endif
void  bcsetghostwidths_( nd, sz, iper)
int         *nd;
BCArrayPart *sz[];
int         *iper[];
{
BCSetGhostWidths(*nd,sz,iper);
}
#ifdef FORTRANCAPS
#define bcfindghostfromstencil_ BCFINDGHOSTFROMSTENCIL
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcfindghostfromstencil_ bcfindghostfromstencil
#endif
void  bcfindghostfromstencil_( nd, sz, nds, stencil, stencil_type)
int         *nd, *nds, *stencil, *stencil_type;
BCArrayPart *sz[];
{
BCFindGhostFromStencil(*nd,sz,*nds,stencil,*stencil_type);
}
#ifdef FORTRANCAPS
#define bcarraypartsize_ BCARRAYPARTSIZE
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcarraypartsize_ bcarraypartsize
#endif
int  bcarraypartsize_( nd, sz)
int         *nd;
BCArrayPart *sz[];
{
return BCArrayPartSize(*nd,sz);
}
#ifdef FORTRANCAPS
#define bcarraycompile_ BCARRAYCOMPILE
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcarraycompile_ bcarraycompile
#endif
void  bcarraycompile_( pgm, options)
BCPGM *pgm;
int   *options;
{
BCArrayCompile(
	(BCPGM* )__ToPointer( *(int*)(pgm) ),*options);
}
#ifdef FORTRANCAPS
#define bcarrayprocsets_ BCARRAYPROCSETS
#elif !defined(FORTRANUNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define bcarrayprocsets_ bcarrayprocsets
#endif
int bcarrayprocsets_( sz, nd, psin, dim)
int         *nd, *dim;
MPI_Comm psin;
BCArrayPart *sz;
{
return __FromPointer( (void *)( BCArrayProcsets(sz,*nd,
	(MPI_Comm  )__ToPointer( *(int*)(psin) ),*dim) ));
}
