





/* 
   This file contains a test program for the routines that generate
   BC programs for global c-grids with a variety of decompositions 
 */

#include <stdio.h>
#include "blkcm/bc.h"
#include "blkcm/mesh.h"

#include "mpi.h"
extern int __NUMNODES, __MYPROCID;static MPI_Status _mpi_status;static int _n, _MPILEN;
#include <stdio.h>

main( argc, argv )
int  argc;
char **argv;
{
int main2();
return PICall( main2, argc, argv );
}

/*ARGSUSED*/
int main2( argc, argv )
int  argc;
char **argv;
{
int         i, nd, myid, nproc, step;
BCArrayPart sz[8];
BCPGM       *pgm;
BCCgridDesc match;
int         iper[8];
double      *a;
int         mx, my;         /* Global sizes */
int         nx, ny;         /* Local sizes */

mx = 6;
my = 4;
/* Define the array */
nd = 2;
sz[0].mdim        = mx;
sz[0].is_parallel = 1;
sz[0].ndim        = -1;
sz[1].mdim        = my;
sz[1].is_parallel = 1;
sz[1].ndim        = -1;

match.edgedim   = 0;
match.normalidx = 0;
match.normaldim = 1;
match.s1      = 0;
match.e1      = mx/3;
match.s2      = mx-1;
match.e2      = match.s2 - (match.e1 - match.s1);

/* Setup the ghost points from the stencil */
BCFindGhostFromStencil( nd, sz, 0, (int *)0, 11 );

nproc = __NUMNODES;
myid  = __MYPROCID;
BCGlobalToLocalArray( nd, sz, nproc, myid );
/* Set the edges as NON-periodic */
iper[0] = 0;
iper[1] = 0;
BCSetGhostWidths( nd, sz, iper );
/* Add the ghost points for the connected edge */
sz[1].sg = 1;

for (i=0; i<=__NUMNODES; i++) {
    if (GTOKEN(0,i)) {
        printf( "P%d\n", i );
	BCPrintArrayPart( stdout, nd, sz );
	fflush( stdout );
        }
    }
pgm = BCBuildCgridPGM( nd, sz, &match, nproc, myid, sizeof(double) );
BCArrayCompile( pgm, 0 );
BCprint_pgms( pgm, stdout );

/* Now, allocate the appropriate array */
a    = (double *)malloc((unsigned)(BCArrayPartSize( nd, sz ) * sizeof(double) ));
/* initialize a */
InitDomain( nd, sz, a );
for (step=0; step<1; step++) {
    BCexec( pgm, (void *)a, (void *)a );
    }

nx = sz[0].end - sz[0].start + 1 + sz[0].eg + sz[0].sg;
ny = sz[1].end - sz[1].start + 1 + sz[1].eg + sz[1].sg;
for (i=0; i<=__NUMNODES; i++) {
    if (GTOKEN(0,i)) {
        printf( "P%d\n", i );
        PrintDomain( nx, ny, mx, my, a );
	fflush( stdout );
        }
    }
BCfree( pgm );
return 0;
}


/*ARGSUSED*/
PrintDomain( nx, ny, mx, my, p )
int    nx, ny, mx, my;
double *p;
{
int    i, j;
double *p1;

/* Start from top down so that the vertical ordering is the same as
   the users' */
for (j=ny-1; j>=0; j--) {
    p1 = p + j * nx;
    i  = nx;
    while (i--)
        printf( "%f ", *p1++ );
    printf( "\n" );
    }
}

InitDomain( nd, sz, a )
int         nd;
BCArrayPart sz[];
double      *a;
{
int    i, n, base;
double bval;

base = 1;
for (i=0; i<nd; i++) {
    if (i > 0) base *= sz[i-1].ndim;
    base += sz[i].loc;
    }
n = BCArrayPartSize( nd, sz );
bval = base;
while (n--) 
    *a++ = bval++;
}

