/* 
   This file contains a test program for the routines that generate
   BC programs for global arrays with a variety of decompositions 
 */

#include <stdio.h>
#include "blkcm/bc.h"
#include "blkcm/mesh.h"
#include <stdio.h>

/*ARGSUSED*/
int main( argc, argv )
int  argc;
char **argv;
{
int         i, nd, myid, nproc;
BCArrayPart sz[8];
int         iper[8];
BCPGM       *pgm;
int         mx, my, g, stencil_base;
int         ndim[3];

/* Define the array */
nd    = 3;
mx    = 10;
my    = 10;
g     = 1;
nproc = 4;
iper[0] = 0;
iper[1] = 0;
iper[2] = 0;
ndim[0] = ndim[1] = ndim[2] = -1;
SYArgGetInt( &argc, argv, 1, "-mx", &mx );
SYArgGetInt( &argc, argv, 1, "-my", &my );
SYArgGetInt( &argc, argv, 1, "-g", &g );
SYArgGetInt( &argc, argv, 1, "-nd", &nd );
SYArgGetInt( &argc, argv, 1, "-nproc", &nproc );
SYArgGetIntList( &argc, argv, 1, "-ndim", 3, ndim );
stencil_base = 10;
if (SYArgHasName( &argc, argv, 1, "-plus")) {
    stencil_base = 0;
    } 

/* Setup the ghost points from the stencil */
fprintf( stdout, "Decomposition is:\n" );
for (myid = 0; myid < nproc; myid++) {
    fprintf( stdout, "For processor %d:\n", myid );
    sz[0].mdim        = mx;
    sz[0].is_parallel = 1;
    sz[0].ndim        = ndim[0];
    sz[1].mdim        = my;
    sz[1].is_parallel = 1;
    sz[1].ndim        = ndim[1];
    sz[2].mdim        = 6;
    sz[2].is_parallel = 1;
    sz[2].ndim        = ndim[2];
    BCFindGhostFromStencil( nd, sz, 0, (int *)0, stencil_base+g );
    for (i=0; i<nd; i++) sz[i].ndim = ndim[i];
    BCGlobalToLocalArray( nd, sz, nproc, myid );
    if (SYArgHasName( &argc, argv, 0, "-iper" )) 
	BCSetGhostWidths( nd, sz, iper );
    BCPrintArrayPart( stdout, nd, sz );
    pgm = BCBuildArrayPGM( nd, sz, nproc, myid, sizeof(double) );
    BCprint_pgms( pgm, stdout );
    BCfree( pgm );
    }
return 0;
}
