



#ifndef lint
static char vcid[] = "$Id: cgrid.c,v 1.1.1.1 1998/08/27 19:16:36 gropp Exp $";
#endif

#include <math.h>
#include <stdio.h>
#include <stdio.h>
#include "blkcm/bc.h"
#include "blkcm/mesh.h"

#include "mpi.h"
extern int __NUMNODES, __MYPROCID;static MPI_Status _mpi_status;static int _n, _MPILEN;

/*ARGSUSED*/
/*@
    BCBuildCgridPGM - Build the program for a global c-grid.

    Input Parameters:
.    nd    - number of dimensions of the array
.    sz    - array of decomposition information (typedef BCArrayPart)
            BCGlobalToLocalArray (or similar) should have been used
	    to set the values in sz.
.    match - array that describes the matching of sections
.    nproc - total number of partitions to use
.    myid  - number of partition.  Must be in [0,nproc-1].  The usual value
            of these parameters is NUMNODES and MYPROCID, but others
	    may be used.
.    nbyte - number of bytes in an element.  Should be sizeof(double) for
            now.

   Notes:
   This code is basically the same as for BCBuildArrayPGM,
   except that part of the array is folded back on itself to form a
   "c-grid".  match is actually a structure that has the constant dimension
   and index (basically which "edge" is folded on itself) and the 
   mapping on this edge.

   If you look at the code for this routine, be assured that it
   really is simple.  The need to handle fairly general cases causes
   the code to be longer than for any particular instance, but this single
   code will handle any regular decomposition.
@*/
BCPGM *BCBuildCgridPGM( nd, sz, match, nproc, myid, nbyte )
int         nd;
BCArrayPart sz[];
BCCgridDesc *match;
int         nproc, myid, nbyte;
{
BCPGM *pgm;
int   line, phase, ntot, i, n[5], incr[5], stmp, nbr, offset, nb[5];
int   soffset, eoffset;
int   incrp[5], ntotp;
int   eid, nid, start, end, ntmp;

/* The maximum size of the program is nd * 4; */
pgm = BCalloc( nd * 4 );

/* Generate the programs.

   See BCBuildArrayPGM for most of the details.
   The only special code is for the "wrapped" edge.
 */
/* set the sizes of the array */
for (i=0; i<5; i++) {
    n[i]    = 1;
    incr[i] = 1;
    }
ntot   = 1;
ntotp  = 1;
offset = 0;
for (i=0; i<nd; i++) {
    nb[i]   = sz[i].end - sz[i].start + 1;
    n[i]    = nb[i];
    incr[i] = ntot;
    incrp[i]= ntotp;
    offset += sz[i].sg * incr[i];
    ntot    *= (n[i] + sz[i].sg + sz[i].eg);
    ntotp   *= sz[i].ndim;
    }
line = 0;
phase= 0;
ntot = 1;
/* For the first phase, the SEND offset is the "lower-left" corner */
for (i=0; i<nd; i++) {
    phase = i;
    if (sz[i].is_parallel) {
        if (i == match->normaldim && 
	    (sz[i].loc == 0 || sz[i].loc == sz[i].ndim - 1)) {
	    if (sz[i].loc == match->normalidx) {
		/* Handle the wrapping */
		/* Find our intersection with the wrapped region */
		eid   = match->edgedim;
		nid   = match->normaldim;
		stmp  = n[eid];
		BCiIntersectRange( sz[eid].start, sz[eid].end, 
				   match->s1, match->e1,
				   &start, &end );
		if (start < end) {
		    n[eid] = end - start;
		    ntmp    = n[nid];
		    n[nid]  = 1;
		    nbr     = 0;   /* Test for now */
		    /* For computing offset, need distance from start */
		    BCset5d( pgm, line++, nbr, phase, BLOCK_COMM_SRC , 
			    offset + incr[eid]*(start-sz[eid].start),
			    n[0], n[1], n[2], n[3], n[4], 
			    incr[0], incr[1], incr[2], incr[3], incr[4] );
		    }
		BCiIntersectRange( sz[eid].start, sz[eid].end, 
				   match->e2, match->s2,
				   &start, &end );
		if (start < end) {
		    incr[eid] = -incr[eid];
		    BCset5d( pgm, line++, myid, phase, BLOCK_COMM_DEST, 
			    (offset - incr[nid] - 
			     incr[eid]*(end-sz[eid].start)), 
			    n[0], n[1], n[2], n[3], n[4], 
			    incr[0], incr[1], incr[2], incr[3], incr[4] );
		    incr[eid] = -incr[eid];
		    };
		n[eid]    = stmp;
		n[nid]    = ntmp;
		}
            }
        else {
            /* Use the basic edge-to-edge code */
	    BCiForwardMatch( pgm, &line, phase, offset, i, 
	                     sz, myid, n, nb, incr, incrp );

            }
	ntot *= sz[i].ndim;
	}
    n[i] += sz[i].eg;
    }
soffset = offset;
eoffset = offset;
for (i=0; i<nd; i++) {
    phase = nd + i;
    if (sz[i].is_parallel) {
        if (i == match->normaldim && 
	    (sz[i].loc == 0 || sz[i].loc == sz[i].ndim - 1)) {
	    if (sz[i].loc == match->normalidx) {
		/* Handle the wrapping */
		/* CODE FOR OTHER CASE HERE; EDIT TO CORRECT */
		/* Find our intersection with the wrapped region */
		eid   = match->edgedim;
		nid   = match->normaldim;
		stmp  = n[eid];
		BCiIntersectRange( sz[eid].start, sz[eid].end, 
				   match->s1, match->e1,
				   &start, &end );
		if (start < end) {
		    n[eid] = end - start;
		    ntmp    = n[nid];
		    n[nid]  = 1;
		    nbr     = 0;   /* Test for now */
		    /* For computing offset, need distance from start */
		    BCset5d( pgm, line++, nbr, phase, BLOCK_COMM_DEST , 
			    offset - incr[nid] + 
			     incr[eid]*(start-sz[eid].start),
			    n[0], n[1], n[2], n[3], n[4], 
			    incr[0], incr[1], incr[2], incr[3], incr[4] );
		    }
		BCiIntersectRange( sz[eid].start, sz[eid].end, 
				   match->e2, match->s2,
				   &start, &end );
		if (start < end) {
		    incr[eid] = -incr[eid];
		    BCset5d( pgm, line++, myid, phase, BLOCK_COMM_SRC, 
			    (offset -  
			     incr[eid]*(end-sz[eid].start)), 
			    n[0], n[1], n[2], n[3], n[4], 
			    incr[0], incr[1], incr[2], incr[3], incr[4] );
		    incr[eid] = -incr[eid];
		    };
		n[eid]    = stmp;
		n[nid]    = ntmp;
		}
	    }
	else {
	    BCiBackMatch( pgm, &line, phase, &soffset, &eoffset, 
	    		  i, sz, myid, n, nb, incr, incrp );
            }
	ntot *= sz[i].ndim;
	}
    n[i] += sz[i].sg;
    }
return pgm;
}

/* Make i lie in [start,end]. */
int BCiClipToRange( i, start, end )
int i, start, end;
{
if (i < start) return start;
if (i > end)   return end;
return i;
}

/* [s3,e3] in [s1,e1] intersect [s2,e2] .  If null, s3>e3 */
int BCiIntersectRange( s1, e1, s2, e2, s3, e3 )
int s1, e1, s2, e2, *s3, *e3;
{
int ss3, ee3;

ss3 = (s1 < s2) ? s2 : s1;
ee3 = (e1 > e2) ? e2 : e1;
*s3 = ss3;
*e3 = ee3;
return 0;
}
