



#ifndef lint
static char vcid[] = "$Id: arraychk.c,v 1.1.1.1 1998/08/27 19:16:36 gropp Exp $";
#endif

#include <stdio.h>                           /*I <stdio.h> I*/
#include <stdio.h>
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include "blkcm/mesh.h"

/*
    This file contains routines to help diagnose errors in BlockComm programs
    and in array descriptions.  In particular, we want to identify illegal
    sized array segments (non-positive sizes).  In addition, we'd like to
    provide a verbose description of the array description and BlockComm
    program.
 */

/*ARGSUSED*/
/*@
    BCChkArrayPGM - Checks an array description and program for validity

    Input Parameters:
.    nd    - number of dimensions of the array
.    sz    - array of decomposition information (typedef BCArrayPart)
            BCGlobalToLocalArray (or similar) should have been used
	    to set the values in sz.
.    nproc - total number of partitions to use
.    myid  - number of partition.  Must be in [0,nproc-1].  The usual value
            of these parameters is NUMNODES and MYPROCID, but others
	    may be used.
.    nbyte - number of bytes in an element.  Should be sizeof(double) for
            now.
@*/ 
void BCChkArrayPGM( fp, pgm, nd, sz, nproc, myid, nbyte, exoffset )
FILE        *fp;
BCPGM       *pgm;
int         nd;
BCArrayPart sz[];
int         nproc, myid, nbyte, exoffset;
{
int   i;

if (fp == 0) fp = stderr;

for (i=0; i<nd; i++) {
    if (sz[i].end < sz[i].start) {
    	fprintf( fp,
	"Invalid start and end (s=%d,e=%d) points in dimension %d\n",
	sz[i].start, sz[i].end, i );
        }
    if (sz[i].sg < 0) {
    	fprintf( fp,
	"Invalid \"left\" ghost points (sg=%d) in dimension %d\n",
	sz[i].sg, i );
        }
    if (sz[i].eg < 0) {
    	fprintf( fp,
	"Invalid \"right\" ghost points (eg=%d) in dimension %d\n",
	sz[i].eg, i );
        }
    if (sz[i].ndim <= 0) {
    	fprintf( fp,
	"Invalid dimension (declared?) (ndim=%d) in dimension %d\n",
	sz[i].ndim, i );
        }
    }

/* The handling of periodic domains if NOT parallel in that dimension is
   not done; this is a bug */
/* This should probably be a separate routine, but still take the information
   about the array to generate better diagnostics */   
for (i=0; i<pgm->n; i++) {
    BCentry *pgme;
    slab    *s;
    
    /* Test the slab size to make sure that all increments are positive
       and buffer size is > 0 and < size of array */
    pgme   = (*pgm->getline)( pgm, i );
    s      = &pgme->src;
    if (s->n1 <= 0) {
    	fprintf( fp, "First dimension (n1 = %d) invalid for entry %d\n",
    	         s->n1, i );
        }
    if (s->n2 <= 0 || (nd < 2 && s->n2 != 1) ) {
    	fprintf( fp, "Second dimension (n2 = %d) invalid for entry %d\n",
    	         s->n2, i );
        }
    if (s->n3 <= 0 || (nd < 3 && s->n3 != 1) ) {
    	fprintf( fp, "Third dimension (n3 = %d) invalid for entry %d\n",
    	         s->n3, i );
        }
    if (s->n4 <= 0 || (nd < 4 && s->n4 != 1) ) {
    	fprintf( fp, "Fourth dimension (n4 = %d) invalid for entry %d\n",
    	         s->n4, i );
        }
    if (s->n5 <= 0 || (nd < 5 && s->n5 != 1) ) {
    	fprintf( fp, "Fifth dimension (n5 = %d) invalid for entry %d\n",
    	         s->n5, i );
        }
    if (s->s1 <= 0) {
    	fprintf( fp, "First stride (s1 = %d) invalid for entry %d\n",
    		 s->s1, i );
        }
    if (s->inc1 <= 0 || (nd < 2 && s->inc1 != 1) ) {
    	fprintf( fp, "Second stride (inc1 = %d) invalid for entry %d\n",
    		 s->inc1, i );
        }
    if (s->inc2 <= 0 || (nd < 3 && s->inc2 != 1) ) {
    	fprintf( fp, "Third stride (inc2 = %d) invalid for entry %d\n",
    		 s->inc2, i );
        }
    if (s->inc3 <= 0 || (nd < 4 && s->inc3 != 1) ) {
    	fprintf( fp, "Third stride (inc3 = %d) invalid for entry %d\n",
    		 s->inc3, i );
        }
    if (s->inc4 <= 0 || (nd < 5 && s->inc4 != 1) ) {
    	fprintf( fp, "Fourth stride (inc4 = %d) invalid for entry %d\n",
    		 s->inc4, i );
        }
    }
/* Now check the generated program
 */    
}

