



#ifndef lint
static char vcid[] = "$Id: syncsend.c,v 1.1.1.1 1998/08/27 19:16:35 gropp Exp $";
#endif

/* #define DEBUG */
#include <stdio.h>
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include <stdio.h>

/*

    This file contains alternate routines that use synchronous sends
    but asynchronous receives.
 */

#ifdef DISTRIBUTED_MEMORY 
extern BCentry *BCdo_recv( );
/* 
   Do sends.  Obey phase partial ordering (this means completing
   all receives from the previous phase before sending)
 */
int BCssend( Program )
BCPGM *Program;
{
int        n;
BCentry *pgm_save, *pgm;
int        (*out)() = Program->out;
int        (*in)()  = Program->in;
int        (*copy)() = Program->copy;
MY_FLOAT   *p;
int       ntag = (Program->ncalls & 0x1);

#ifdef DEBUG
printf( "[%d] Starting ssend\n", __MYPROCID );
#endif
n   = Program->n;
pgm = pgm_save = Program->pgm;
Program->pgm_last = pgm;
while (n--) {
    /* May be local source */
    /* sync all recvs before this send with a lower phase */
    if (pgm->type & BLOCK_COMM_SYNC_BLOCK) {
	pgm_save = BCdo_recv( pgm, pgm_save, in, pgm->phase );
	Program->pgm_last = pgm_save;
	}
    if (IS_LOCAL_SRC(pgm)) {
	(*copy)( &pgm->src, &((pgm + pgm->processor)->src) );
	}
    else if (IS_SRC(pgm)) {
	p  = pgm->buffer;
        if (!pgm->inplace)
            (*out)( &pgm->src, p );
#ifdef FOO
	else
	    /* if inplace, p is the USERs data area, so this ammounts
	       to doing a getaddress. */
	    p += pctx;
#endif
        if (pgm->type & BLOCK_COMM_BUFFER) {
#ifdef intelnx
	    if (pgm->type & BLOCK_COMM_SYNC_NBR) {
		int b;
		/* Receive null message from partner */
#ifdef DEBUG
		printf( "sync sending type %d on %d\n", pgm->mtype+ntag, 
		        __MYPROCID );
#endif
		RECVSYNCNOMEM(pgm->mtype+ntag, &b, sizeof(int), MPI_INT );
		SENDSYNCNOMEMFORCE( pgm->mtype+ntag, p, pgm->act_len, 
 		                    pgm->processor, MY_MPI_FLOAT );
		}
	    else 
#endif
		SENDSYNCNOMEM( pgm->mtype+ntag, p, pgm->act_len, 
			       pgm->processor, MY_MPI_FLOAT );
#ifdef DEBUG
            printf( "Sent type %d to %d from %d [size %d]\n", pgm->mtype+ntag,
                    pgm->processor, __MYPROCID, pgm->act_len );
#endif
            }
        }
    NEXTLINE(pgm);
    }
#ifdef DEBUG
printf( "[%d] Ending ssend\n", __MYPROCID );
#endif

return 0;
}

/* 
  Wait for all receives in the last phase. 
 */
int BCiswait( Program )
BCPGM *Program;
{
BCentry *pgm = Program->pgm;

#ifdef DEBUG
printf( "[%d] Starting BCiwait\n", __MYPROCID );
#endif

BCdo_recv( Program->pgm + Program->n, Program->pgm_last, 
	      Program->in, (pgm-1)->phase+1 );

#ifdef DEBUG
printf( "[%d] Starting BCiswait\n", __MYPROCID );
#endif

return 0;
}

/*@
  BCUseSyncSend - Use the synchronous send routines instead of the default
  asynchronous send routines.

  Input Parameter:
.  pgm - make this program use the synchronous send routines
 @*/
void BCUseSyncSend( pgm )
BCPGM *pgm;
{
pgm->isend = BCssend;
pgm->iwait = BCiswait;
}
#endif
