#ifndef lint
static char vcid[] = "$Id: eforce.c,v 1.1.1.1 1998/08/27 19:16:34 gropp Exp $";
#endif

/* #define DEBUG */
#include <stdio.h>
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include <stdio.h>

/*
  This file contains routines to use forcetypes exclusively
  It is otherwise similar to support.c
 */

#ifdef DISTRIBUTED_MEMORY
BCentry *BCdo_recvForce( );
/*
   Initialize receives for ALL receives (all phases) 
 */
int BCirecvForce( Program )
BCPGM *Program;
{
BCentry *pgm = Program->pgm;
int        n    = Program->n;
int        (*copy)() = Program->copy;
int       ntag = (Program->ncalls & 0x1);

#ifdef DEBUG
printf( "Starting irecv\n" );
#endif
while (n--) {
    switch (GET_MAJOR_MODE(pgm)) {
        case BLOCK_COMM_DEST:
        if (pgm->type & BLOCK_COMM_BUFFER) {
	    RECVASYNCNOMEMFORCE(pgm->mtype+ntag,pgm->buffer,pgm->act_len,
			        MY_MPI_FLOAT,pgm->rc);
#ifdef DEBUG
            printf( "IReceived type %d on %d (should be from %d)\n",
                   pgm->mtype+ntag, __MYPROCID, pgm->processor );
#endif
	    }
        break;
        }
    NEXTLINE(pgm);
    }
#ifdef DEBUG
printf( "Ending irecv\n" );
#endif
/* Force all processors to synchronize here */
GSYNC(0);
return 0;
}

/* 
   Initialize sends.  Obey phase partial ordering (this means completing
   all receives from the previous phase before sending)
 */
int BCisendForce( Program )
BCPGM *Program;
{
int        n;
BCentry *pgm_save, *pgm;
int        (*out)() = Program->out;
int        (*in)()  = Program->in;
int        (*copy)() = Program->copy;
MY_FLOAT *p;
int       ntag = (Program->ncalls & 0x1);

#ifdef DEBUG
printf( "[%d] Starting isend\n", __MYPROCID );
#endif
n   = Program->n;
pgm = pgm_save = Program->pgm;
Program->pgm_last = pgm;
while (n--) {
    /* sync all recvs before this send with a lower phase */
    if (pgm->type & BLOCK_COMM_SYNC_BLOCK) {
	pgm_save = BCdo_recvForce( Program, pgm, pgm_save, in, pgm->phase );
	Program->pgm_last = pgm_save;
	}
    /* May be local source */
    if (IS_LOCAL_SRC(pgm)) {
	(*copy)( &pgm->src, &((pgm + pgm->processor)->src) );
	}
    else if (IS_SRC(pgm)) {
	p  = pgm->buffer;
        if (!pgm->inplace)
            (*out)( &pgm->src, p );
        if (pgm->type & BLOCK_COMM_BUFFER) {
	    SENDSYNCNOMEMFORCE( pgm->mtype+ntag, p, pgm->act_len, 
			         pgm->processor, MY_MPI_FLOAT );
#ifdef DEBUG
            printf( "Sent type %d to %d from %d [size %d]\n", pgm->mtype+ntag,
                    pgm->processor, __MYPROCID, pgm->act_len );
#endif
            }
        }
    NEXTLINE(pgm);
    }
#ifdef DEBUG
printf( "[%d] Ending isend\n", __MYPROCID );
#endif

return 0;
}

/* 
  Wait for all sends to complete, as well as any receives in the 
  last phase. 
 */
int BCiwaitForce( Program )
BCPGM *Program;
{
BCentry *pgm = Program->pgm;
int       ntag = (Program->ncalls & 0x1);
#ifdef FOO
int        n    = Program->n;
#endif

#ifdef DEBUG
printf( "[%d] Starting BCiwait\n", __MYPROCID );
#endif

LOGEVENT(400);
#ifdef FOO
/* Wait on sends---really should be Program->pgm_last_send */
while (n--) {
    if (IS_SRC(pgm)) {
        if ((pgm->type & BLOCK_COMM_BUFFER) && pgm->rc > 0) {
#ifdef DEBUG
	    printf( "Waiting for type %d on %d (isend)\n", 
		    pgm->mtype+ntag, __MYPROCID );
#endif
	    SENDWAITFORCE(pgm->mtype+ntag,pgm->buffer,pgm->act_len,
			  pgm->to,MY_MPI_FLOAT,
		     pgm->rc );
#ifdef DEBUG
	    printf( "Finished isend type %d on %d\n",
		    pgm->mtype+ntag, __MYPROCID );
#endif
	    }
        }
    NEXTLINE(pgm);
    }
#endif
LOGEVENT(401);

BCdo_recvForce( Program, Program->pgm + Program->n, Program->pgm_last, 
	      Program->in, (pgm-1)->phase+1 );

#ifdef DEBUG
printf( "[%d] Starting BCiwait\n", __MYPROCID );
#endif
return 0;
}


/*
   This routine processes all of the recv's from pgm_save to pgm-1.
   Return the value of pgm_save on exit.
 */
BCentry *BCdo_recvForce( Program, pgm, pgm_save, in, phase )
BCPGM   *Program;
BCentry *pgm, *pgm_save;
int     (*in)(), phase;
{
int       ntag = (Program->ncalls & 0x1);
LOGEVENT(200);
while (pgm_save < pgm) {
    if (pgm_save->phase >= phase) break;
    if (IS_DEST(pgm_save)) {
	if ((pgm_save->type & BLOCK_COMM_BUFFER) && 
	     ! PIRecvIdNull(pgm_save->rc)) {
#ifdef DEBUG
    printf( "Waiting (recv) type %d from %d on %d in do_recv processing\n",
	        pgm_save->mtype+ntag, pgm_save->processor, __MYPROCID );
#endif
            RECVWAITNOMEMFORCE(pgm_save->mtype+ntag,pgm_save->buffer,
			       pgm_save->act_len,
			       MY_MPI_FLOAT,pgm_save->rc);
#ifdef DEBUG
    printf( "Received type %d from %d on %d (%d bytes)in do_recv processing\n",
	        pgm_save->mtype+ntag, pgm_save->processor, __MYPROCID, __MPILEN);
#endif
	    PIRecvIdClear(pgm_save->rc);
	    }
	if (!pgm_save->inplace) {
	    LOGEVENT(202);
	    (*in)( pgm_save->buffer, &pgm_save->src );
	    LOGEVENT(203);
	    }
	}
    NEXTLINE(pgm_save);
    }
LOGEVENT(201);
return pgm_save;
}

/*@
  BCUseForceTypes - Use the asynchronous, forcetype routines instead of the 
  default asynchronous send routines.

  Input Parameter:
. pgm - Make this program use force types.
 @*/
void BCUseForceTypes( pgm )
BCPGM *pgm;
{
pgm->isend = BCisendForce;
pgm->iwait = BCiwaitForce;
pgm->irecv = BCirecvForce;
}

#endif

