c
c   This file contains a very simple program for testing various combinations
c   of the 2-d grid operations.  The idea is to initialize each segment with
c   the values of the global indices, with ghost points being negative.
c   After a copy, the values are tested.  Note that because the ghost-points
c   exist at the periodic physical boundaries and not at the non-periodic
c   physical boundaries, we can test both cases.
c
c     int mdim,          /* size of array in this dimension */
c     int is_parallel,   /* true if the array is parallelized in
c                           this dimension */
c     int start,         /* starting index for local piece */
c     int end,           /* ending index for local piece */
c     int loc            /* location in this dimension of the 
c                           processor */
c     int ndim           /* number of processors in this dimension,
c 	                   -1 if unspecified */
c     int sg             /* start and end ghost limits */
c     int eg             /* start and end ghost limits */
c     int nsg            /* start and end ghost limits for neighbor */
c     int neg
c
       integer function worker()
       integer mx, my, nd
       parameter(nd=2, NBYTES=8)
       integer maxnx, maxny
       parameter(maxnx = 258, maxny = 258 )
c      Fields in the "SZ" array 
       include '../meshf.h'
       include 'mpif.h'
c      integer pigtoken
       integer pgm, sz(0:9,0:nd-1), iper(0:nd-1)
       integer nx, ny
       integer sx,sxgp,ex,exgp,sy,sygp,ey,eygp
       double precision a(maxnx*maxny)
       integer myid, nproc, ierr
       integer err
c       integer argc, argv
c
c Define the domain as a 2-d mesh of size mx x my, to be subdivided 
c in both dimensions
c
c       mx    = 256
c       my    = 256
        mx = 6
        my = 6
c      call syargload( argc, argv )
c      if (syarghasname( argc, argv, 1,"-periodic" )) print *, 'found'
c
       sz(szmdim,0)       = mx
       sz(szisparallel,0) =  1
       sz(szndim,0)       = -1
       sz(szmdim,1)       = my
       sz(szisparallel,1) =  1
       sz(szndim,1)       = -1
       iper(0)            = 1
       iper(1)            = 1
c
c      Build the communications pattern by:
c 
c      1. Compute the size of the ghost-points from the computational 
c         stencil
c      2. Compute the local part of the array that this processor 
c         is responsible for
c      3. Build the communication pattern and "compile" it
c
c      Setup the ghost points from the stencil 
c      Note that this assumes doublely periodic boundary conditions.
       call BCFindGhostFromStencil( nd, sz, 0, 0, boxstencil )

       call MPI_COMM_RANK(MPI_COMM_WORLD,myid,ierr)
       call MPI_COMM_SIZE(MPI_COMM_WORLD,nproc,ierr)
       call BCGlobalToLocalArray( nd, sz, nproc, myid )
       call BCSetGhostWidths( nd, sz, iper )
c
c      do 10 i=0, nproc
c      if (myid.eq.i) then
c         print *, 'Processor ', i
c         call BCPrintArrayPartVerbose( 0, nd, sz )
c      endif
c10    continue
       pgm = BCBuildArrayPGM( nd, sz, nproc, myid, NBYTES )
       call BCUseOrderedSend( pgm )
       call BCArrayCompile( pgm, 0 )
       print *,'COMPILED STUPID PROGRM',myid
c       call bcprint_pgms( pgm, 0 )
c
c      Compute the parameters of our part of the domain
c
       sx   = sz(szstart,0) + 1
       ex   = sz(szend,0) + 1
       sxgp = sz(szsg,0)
       exgp = sz(szeg,0)
       nx   = ex - sx + 1 + sxgp + exgp
       sy   = sz(szstart,1) + 1
       ey   = sz(szend,1) + 1
       sygp = sz(szsg,1)
       eygp = sz(szeg,1)
       ny   = ey - sy + 1 + sygp + eygp
c
c      Sanity check on subproblem size
       if (ny * nx .gt. maxnx * maxny) then
	     print *, 'Selected domain too large '
	     worker = 1
	     return
       endif
c
c      initialize a 
c      print *,'INIT DOMAIN',myid
       call InitDomain( a, mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp)
c       if (myid .eq. 0) print *, 'Initial arrays:'
c          call dispall( a, sx, sxgp, ex, exgp, sy, sygp, ey, eygp, 
c     *                   mx, my, 16 )
cc
       print *,'EXEC PRGM',myid
       call BCexec( pgm, a, a )
c
c      Check results
c      print *,'CHK VALUES',myid
       call CheckValues( a, mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp, 
     *                   iper, err )
       call MPI_ALLREDUCE(err,i,1,MPI_INTEGER,MPI_SUM,
     &                    MPI_COMM_WORLD,ierr)
       err = i
       if (err .gt. 0) then 
          call dispall( a, sx, sxgp, ex, exgp, sy, sygp, ey, eygp, 
     *                   mx, my, 16 )
       endif
c
c      print *,'FREE PGM',myid
       call BCfree( pgm )
       print *,'ALL DONE',myid
c
       worker = 0
       return
       end
c
       subroutine InitDomain( a, mx,my,
     +                           sx,sxgp,ex,exgp,sy,sygp,ey,eygp)
       integer      mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp
       double precision a(sx-sxgp:ex+exgp,sy-sygp:ey+eygp)
c
c     Set everything to - global index
c
       do j = sy-sygp,ey+eygp
          do i = sx-sxgp,ex+exgp
             a(i,j) = -( i + j * mx)
          enddo
       enddo
c
c ---  initialize the interior as the local indices
c
       do j = sy, ey
          do i = sx, ex
             a(i,j) = i + j * mx
          enddo
       enddo
       return
       end
c
       subroutine CheckValues( a, mx,my,
     +                      sx,sxgp,ex,exgp,sy,sygp,ey,eygp,iper, err)
       integer      mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp,iper(0:1)
       double precision a(sx-sxgp:ex+exgp,sy-sygp:ey+eygp)
       integer err, tval
       integer myid, ierr
       include 'mpif.h'
c
c     Set everything should now be global index
c
       call MPI_COMM_RANK(MPI_COMM_WORLD,myid,ierr)
       err = 0
       do j = sy-sygp,ey+eygp
          do i = sx-sxgp,ex+exgp
             tval = i + j * mx
c This version should be correct for periodic boundaries
             tval = 1+mod(mx+i-1,mx) + (1+mod(my+j-1,my)) * mx
             if (abs(a(i,j) - tval) .gt. 1.0e-10) then
                 err = err + 1
                 if (err .gt. 10) return 
                 write (*,1) myid, i, j, a(i,j), tval
 1               format( ' [', i2, '] (', i3, ',', i5, ') = ', f6.0, 
     *           ', should be ', i4 )
             endif
          enddo
       enddo
       return 
       end
