/*
   This provides the main program for a user who wants to work 
  exclusively in FORTRAN, i.e. they don't even want to have a C stub
  which calls their fortran routine. These people are misguided!

 */

#include <stdio.h>
#include "mpi.h"

#if defined(FORTRANCAPS)
#define worker_ WORKER
#elif !defined(FORTRANUNDERSCORE)
#define worker_ worker
#endif

extern int worker_();
static int fmainl();

/*D
    worker - A main program for running Fortran with the communication 
            interface.

    Notes:
    For pure Fortran programmers one 
    way to use the parallel aspects of the tools package is
    to use a subroutine called worker() as the main program
    (that is, don't include a main program) then when doing 
    a link with the tools libraries include before the 
    other libraries $(TOOLSDIR)/libs/libs$(BOPT)/$(ARCH)/fmain.o
    
    The routine worker() will then be called in parallel using 
    the number of processors prescribed int the command line with
    program -np 6 <- here we use 6 processors.
    
    An example is in $TOOLSDIR/comm/examples/example2.f 
D*/
main(argc,argv)
int argc;
char **argv;
{
return PICall( fmainl, argc, argv );
}

#ifdef XXXXX
/* For Fortran profiling... */
MAIN_(argc,argv)
int argc;
char **argv;
{
return PICall( fmainl, argc, argv );
}
#endif

static int fmainl( argc, argv )
int argc;
char **argv;
{
return worker_();
}

