c
c   This file contains a test program for the routines that generate
c   BC programs for global arrays with a variety of decompositions 
c
c     int mdim,          /* size of array in this dimension */
c     int is_parallel,   /* true if the array is parallelized in
c                           this dimension */
c     int start,         /* starting index for local piece */
c     int end,           /* ending index for local piece */
c     int loc            /* location in this dimension of the 
c                           processor */
c     int ndim           /* number of processors in this dimension,
c 	                   -1 if unspecified */
c     int sg             /* start and end ghost limits */
c     int eg             /* start and end ghost limits */
c     int nsg            /* start and end ghost limits for neighbor */
c     int neg
c
       integer function worker()
       integer mx, my, nd
       parameter(mx = 50, my = 20, nd=2, NBYTES=8)
c      Fields in the "SZ" array 
       include '../meshf.h'
       include 'mpif.h'
       integer pgm, sz(0:9,0:nd-1)
       integer nstep, nx, ny
       integer sx,sxgp,ex,exgp,sy,sygp,ey,eygp
       double precision a((mx+2)*(my+2)), b((mx+2)*(my+2))
       integer myid, nproc, ierr

c
c Define the domain as a 2-d mesh of size mx x my, to be subdivided 
c in both dimensions
c
       sz(szmdim,0)       = mx
       sz(szisparallel,0) =  1
       sz(szndim,0)       = -1
       sz(szmdim,1)       = my
       sz(szisparallel,1) =  1
       sz(szndim,1)       = -1

c
c      Build the communications pattern by:
c 
c      1. Compute the size of the ghost-points from the computational 
c         stencil
c      2. Compute the local part of the array that this processor 
c         is responsible for
c      3. Build the communication pattern and "compile" it
c
c      Setup the ghost points from the stencil 
c      Note that this assumes doublely periodic boundary conditions.
       print *,'START Calling BCFindGhostFromStencil', myid
       call BCFindGhostFromStencil( nd, sz, 0, 0, boxstencil )

       call MPI_COMM_RANK(MPI_COMM_WORLD,myid,ierr)
       call MPI_COMM_SIZE(MPI_COMM_WORLD,nproc,ierr)
       print *,'starting up (myid,nproc)',myid,nproc
       call BCGlobalToLocalArray( nd, sz, nproc, myid )
c
c      To print the local array description, use
c      call BCPrintArrayPart( 0, nd, sz )
c
       print *,'START Calling BCBuildArrayPGM ', myid
       pgm = BCBuildArrayPGM( nd, sz, nproc, myid, NBYTES )
       call BCUseOrderedSend( pgm )
       print *,'START Calling BCArrayCompile', myid
       call BCArrayCompile( pgm, 0 )
c
c      To print the program, use
c      call BCPrint_pgms( pgm, 0 )
c
c      Compute the parameters of our part of the domain
c
       sx   = sz(szstart,0) + 1
       ex   = sz(szend,0) + 1
       sxgp = sz(szsg,0)
       exgp = sz(szeg,0)
       nx   = ex - sx + 1 + sxgp + exgp
       sy   = sz(szstart,1) + 1
       ey   = sz(szend,1) + 1
       sygp = sz(szsg,1)
       eygp = sz(szeg,1)
       ny   = ey - sy + 1 + sygp + eygp

c      initialize a
       call InitDomain( a, mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp)
c
       nstep = 10
       do i = 0, nstep-1, 2
          print *,'TIME STEP ',i, myid
          call BCexec( pgm, a, a )
          call TimeStep( a, b, mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp)
          call BCexec( pgm, b, b )
          call TimeStep( b, a, mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp)
       enddo
c
       print *,'FINISHED, CALLING FREE', myid
       call BCfree( pgm )
c
       worker = 0
       return
       end
c
       subroutine InitDomain( a, mx,my,
     +                           sx,sxgp,ex,exgp,sy,sygp,ey,eygp)
       integer      mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp
       double precision a(sx-sxgp:ex+exgp,sy-sygp:ey+eygp)
c
c     Zero everything
c
       do j = sy-sygp,ey+eygp
          do i = sx-sxgp,ex+exgp
             a(i,j) = 0.0d0
          enddo
       enddo
c
c ---  initialize the interior 
c
       do j = sy, ey
          do i = sx, ex
             a(i,j) = i + mx * (j-1)
          enddo
       enddo
       return
       end
c
       subroutine TimeStep( a, b, 
     *                  mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp )
       integer      mx,my,sx,sxgp,ex,exgp,sy,sygp,ey,eygp
       double precision a(sx-sxgp:ex+exgp,sy-sygp:ey+eygp)
       double precision b(sx-sxgp:ex+exgp,sy-sygp:ey+eygp)
       integer i, j
c     
c      Code to time step the problem
c
       do 10 j=sy,ey
          do 10 i=sx,ex
             b(i,j) = a(i,j)
 10    continue
       return
       end
