#include "blkcm/bc.h"
#include "blkcm/mesh.h"
#include <stdio.h>
#include <math.h>

main( argc, argv )
int  argc;
char **argv;
{
    int main2();

    PICall(main2,argc,argv);
    exit(0);
}

int main2( argc, argv )
int  argc;
char **argv;
{
    int dimen = 2;                        /* Dimension of the domain */
    int nx=6, ny=6, lnx, lny;             /* Global and local sizes */
    int nx1, nx2, ny1, ny2;               /* Local partition boundaries */
    int i, j, ind, x_eff, y_eff, err=0;   /* Integer utility variables */
    MY_FLOAT *x;                            /* Variable array */
    MY_FLOAT tmp;                           /* Double prec. utility variable */
    BCArrayPart sz[2];
    BCPGM *pgm;

    /* Set up sz array for BlockComm. */
    sz[0].mdim        = nx;
    sz[0].is_parallel = 1;
    sz[0].ndim        = -1;
    sz[1].mdim        = ny;
    sz[1].is_parallel = 1;
    sz[1].ndim        = -1;
    BCFindGhostFromStencil(dimen,sz,0,0,11);
    BCGlobalToLocalArray(dimen,sz,__NUMNODES,__MYPROCID);

    /* Build program */
    pgm = BCBuildArrayPGM(dimen,sz,__NUMNODES,__MYPROCID,sizeof(MY_FLOAT));
    BCUseOrderedSend( pgm );
    BCArrayCompile(pgm,0);

    /* Help debug the code */
    /* BCprint_pgms( pgm, stdout ); */

    /* Get partition boundaries in x and y directions. */
    nx1 = sz[0].start;
    nx2 = sz[0].end;
    ny1 = sz[1].start;
    ny2 = sz[1].end;
    printf("Proc %0d: nx1=%0d, nx2=%0d, ny1=%0d, ny2=%0d\n",__MYPROCID,
           nx1,nx2,ny1,ny2);
    MPI_Barrier( MPI_COMM_WORLD );

    /* Allocate memory for variable array. */
    lnx = (nx2-nx1+3);
    lny = (ny2-ny1+3);
    x = (MY_FLOAT *) malloc((unsigned)(lnx*lny*sizeof(MY_FLOAT)));

    /*** Begin communication test. ***/
    if (__MYPROCID == 0)
        printf("\nTesting communication...\n");
    MPI_Barrier( MPI_COMM_WORLD );

    /*
     * First we assign all non-ghost sites a unique global index
     * (the ghost sites are set to zero).
     */
    for (j = 0; j < lny; j++)
        for (i = 0; i < lnx; i++) {
            ind = j*lnx + i;
            x_eff = ((nx1-1+i+nx) % nx) + 1;
            y_eff = ((ny1-1+j+ny) % ny) + 1;
            tmp = (MY_FLOAT) ((y_eff-1)*nx + x_eff);
            if ((i==0) || (j==0) || (i==lnx-1) || (j==lny-1))
                x[ind] = 0.0;
            else
                x[ind] = tmp;
            if (__MYPROCID == 0) {
                printf(" %6.2f ",x[ind]);
                if (i == (lnx-1))
                    printf("\n");
            }
        }
    if (__MYPROCID == 0)
        printf("\n");
    MPI_Barrier( MPI_COMM_WORLD );

    /* Next we set the ghost sites... */
    BCexec(pgm,x,x);

    MPI_Barrier( MPI_COMM_WORLD );
    for (j = 0; j < lny; j++)
        for (i = 0; i < lnx; i++) {
            ind = j*lnx + i;
            if (__MYPROCID == 0) {
                printf(" %6.2f ",x[ind]);
                if (i == (lnx-1))
                    printf("\n");
            }
        }
    if (__MYPROCID == 0)
        printf("\n");
    MPI_Barrier( MPI_COMM_WORLD );

    /*
     * Now we generate an effective global index for all sites, including
     * the ghost sites, and check for errors.
     */
    for (j = 0; j < lny; j++)
        for (i = 0; i < lnx; i++) {
            ind = j*lnx + i;
            x_eff = ((nx1-1+i+nx) % nx) + 1;
            y_eff = ((ny1-1+j+ny) % ny) + 1;
            tmp = (MY_FLOAT) ((y_eff-1)*nx + x_eff);
            if (fabs(x[ind] - tmp) > 0.000001) {
                printf("Error on processor %0d: ",__MYPROCID);
                printf("(x_global=%0d, y_global=%0d)  ",nx1+i,ny1+j);
                printf("(%0.4f != %0.4f)\n",x[ind],tmp);
                err = 1;
            }
        }

    if (err) {
        if (__MYPROCID == 0) {
            printf("Communication test failed.\n");
            printf("Exiting...\n");
        }
        exit(0);
    }
    if (__MYPROCID == 0)
        printf("Communication OK...\n\n");

    MPI_Barrier( MPI_COMM_WORLD );
    printf("Proc %0d: Normal exit from main2...\n",__MYPROCID);

    return 0;
}

