



#ifndef lint
static char vcid[] = "$Id: mprint.c,v 1.1.1.1 1998/08/27 19:16:30 gropp Exp $";
#endif

/*
   Helper routines for using the mesh communication package.
 */
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include <stdio.h>           /*I <stdio.h> I*/
/*
   This is a debugging routine to print out a communications program
 */
int BCprint_pgm( Program, fp )
BCPGM *Program;
FILE  *fp;
{
BCentry *pgm = Program->pgm;
int        n    = Program->n;
int        i;
slab       *s;
char       *name[9];
static char       *buffer[2] = { "       ", 
				 " buffer" };
static char       *sync[2]   = { "         ", 
				 " syncRecv" };
static char       *nbrsync[2]= { "         ", 
				 " sync nbr" };
name[BLOCK_COMM_LOCAL_SRC]  = "Local Src ";
name[BLOCK_COMM_LOCAL_DEST] = "Local Dest";
name[BLOCK_COMM_SRC]        = "Send      ";
name[BLOCK_COMM_DEST]       = "Recv      ";

fprintf( fp, " <s1 n1 n2 n3 n4 n5 inc1 inc2 inc3 inc4>\n" );
for (i=0; i<n; i++) {
    fprintf( fp, "\n<%d> %s%s%s%s, phase = %d, id = %d", i,
            name[GET_MAJOR_MODE(pgm)],
            buffer[(pgm->type&BLOCK_COMM_BUFFER)?1:0],
            sync[(pgm->type&BLOCK_COMM_SYNC_BLOCK)?1:0],
            nbrsync[(pgm->type&BLOCK_COMM_SYNC_NBR)?1:0],
            pgm->phase, pgm->id );
    if (IS_LOCAL_SRC(pgm)) {
	fprintf( fp, " (dest is %d)", 
		 pgm->processor + (int)(pgm - Program->pgm));
	}
    fprintf( fp, "\n" );
    s    = &pgm->src;
    fprintf( fp, "src:  %d|%d %d %d %d %d|%d %d %d %d [%d]\n", 
	     s->s1, s->n1, s->n2,
             s->n3, s->n4, s->n5, s->inc1, s->inc2, s->inc3, s->inc4,
	     (int)(s->lctx) );
#ifdef DISTRIBUTED_MEMORY
    if (!IS_LOCAL(pgm)) 
	fprintf( fp,
        "@alen = %d, nbr proc = %d, inplace = %d, mtype = %d, buf=%x\n",
        pgm->act_len, pgm->processor, pgm->inplace, pgm->mtype, pgm->buffer );
#endif
    {int nn[5], incr[5];
    nn[0] = s->n1; nn[1] = s->n2; nn[2] = s->n3; nn[3] = s->n4; nn[4] = s->n5;
    incr[0] = s->s1; incr[1] = s->inc1; incr[2] = s->inc2; incr[3] = s->inc3;
    incr[4] = s->inc4;
    BCPrintBlock( fp, 5, nn, incr, (int)(s->lctx), Program->basedims );
     }
    NEXTLINE(pgm);
    }
return 0;
}

/*@
   BCprint_pgms - Prints the programs for all processors, one program at a time

   Input Parameters:
.  Program - BlockComm program
.  fp      - file pointer   
 @*/
void BCprint_pgms( Program, fp )
BCPGM *Program;
FILE  *fp;
{
int i, np = __NUMNODES;
for (i=0; i<=np; i++) {
    if (GTOKEN(0,i)) {
	if (np > 1) fprintf( fp, "Program for processor %d\n", i );
	BCprint_pgm( Program, fp );
	fflush( fp );
	}
    }
}

/*
   This is a debugging routine that turns a specification and a matrix
   dimension into a subregion starting from 0, with a given offset
 */
int BCPrintBlock( fp, nd, n, incr, offset, basedims )
FILE *fp;
int n[5], incr[5], nd, offset, basedims[5];
{
int i, sloc;
int roff[5];

for (i=nd-1; i>=0; i--) {
    if (incr[i] == 1 && i > 0) {
	nd = i; 
	continue;
	}
    roff[i] = offset / incr[i];
    offset  = offset - roff[i] * incr[i];
    }
fprintf( fp, "a(" );
for (i=0; i<nd; i++) {
    sloc = roff[i] + basedims[i];
    if (n[i] == 1)
	fprintf( fp, "%d", sloc );
    else
	fprintf( fp, "%d:%d", sloc, sloc+n[i]-1 );
    if (i + 1 < nd) fprintf( fp, "," );
    }
fprintf( fp, ")\n" );
return 0;
}

/*
   This just prints the TARGETS for each processor 
 */
int BCprint_pgm_targets( Program, fp )
BCPGM *Program;
FILE  *fp;
{
BCentry *pgm = Program->pgm;
int        n    = Program->n;
int        i;

for (i=0; i<n; i++) {
    if (IS_SRC(pgm) && (pgm->type & BLOCK_COMM_BUFFER)) 
	fprintf( fp, " %d", pgm->processor );
    NEXTLINE(pgm);
    }
fprintf( fp, "\n" );
return 0;
}

/*
   This prints the programs for all processors, one program at a time
 */
int BCprint_pgms_targets( Program, fp )
BCPGM *Program;
FILE  *fp;
{
int i, np = __NUMNODES;
for (i=0; i<=np; i++) {
    if (GTOKEN(0,i)) {
	if (np > 1) fprintf( fp, "Program targets for processor %d\n", i );
	BCprint_pgm_targets( Program, fp );
	fflush( fp );
	}
    }
return 0;
}
