int ERR_NONE = 0;



#ifndef lint
static char vcid[] = "$Id: base.c,v 1.1.1.1 1998/08/27 19:16:29 gropp Exp $";
#endif

/* 
   This file contains routines for only the create and execute program
   operations
 */

#include <stdio.h>
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include <stdio.h>

#ifndef DBUG
#define DBUG(a)
#endif

/*@
     BCcompile - compile a blockcomm program

   Input parameters:
.  Program - program to compile
.  options - option values.  See blkcm/bc.h for values (all BCOPTION_...)
@*/
int BCcompile( Program, options )
BCPGM *Program;
int   options;
{
int err = ERR_NONE;

/* Check for valid options (or options not provided and thus some
   random value */
if (options & ~BCOPTION_BITS) 
    fprintf( stderr, "Invalid options (%d) given to BCcompile\n", options );

DBUG( "About to do findowner\n" );
if (!(options & BCOPTION_NOFINDOWNER) && Program->findowner)
    (*Program->findowner)( Program );
DBUG( "About to do sort\n" );
if (!(options & BCOPTION_NOSORT) && Program->sort)        
    (*Program->sort)     ( Program );
DBUG( "About to do findlocal\n" );
if (!(options & BCOPTION_NOFINDLOCAL) && Program->findlocal)   
    (*Program->findlocal)( Program );
DBUG( "About to do OptimizeMoves\n" );
if ((options & BCOPTION_OPTMOVES))
    BCOptimizeMoves( Program );
DBUG( "About to do trimmove\n" );
if ((options & BCOPTION_TRIMMOVE) && Program->trimmove)    
    (*Program->trimmove) ( Program );
DBUG( "About to do buffer\n" );
/* The buffer routine depends on the options */
if (Program->buffer)      
    (*Program->buffer)   ( Program, options );
DBUG( "About to do pairsync\n" );
if ((options & BCOPTION_PAIRSYNC) && Program->pairsync)    
    (*Program->pairsync) ( Program );
DBUG( "About to do settypes\n" );
if (!(options & BCOPTION_NOAUTOTYPE) && Program->settypes)    
    (*Program->settypes) ( Program );

DBUG( "About to do validation\n" );
if (!(options & BCOPTION_NOVALID) && Program->valid) 
    err = (*Program->valid)    ( Program, 1 );

/* This orders the sends to let them overlap more effectively */
DBUG( "About to do scheduling\n" );
if (!(options & BCOPTION_NOSCHEDULE) && Program->schedule)
    err = (*Program->schedule) ( Program );

/* BCSortSends( Program ); */

DBUG( "Done compiling program\n" );

/* BCprint_pgms_targets( Program, stdout ); */

Program->iscompiled = 1;
return err;
}

/*@
   BCexec - Execute a Program.

   Input Parameters:
.   Program   - previously compiled program
.   sctx,dctx - source and destination context (used for the entire program)
 @*/
int BCexec( Program, sctx, dctx )
BCPGM  *Program;
void   *sctx, *dctx;
{
int err;
/* Compile the program if the user has forgotten to */
if (!Program->iscompiled) {
    err = BCcompile( Program, 0 );
    if (!err) return err;
    }
BCSetPointers( Program, sctx, dctx );
Program->ncalls++;
if (Program->irecv) (*Program->irecv)( Program );
if (Program->isend) (*Program->isend)( Program );
if (Program->irun)  (*Program->irun)( Program->irunctx );
if (Program->iwait) (*Program->iwait)( Program );
return ERR_NONE;
}

/*
   This routine returns a pointer to the requested line.  Versions of this
   can allocated and copy as appropriate.
 */
BCentry *BCgetline( Program, line )
BCPGM *Program;
int   line;
{
if (line >= Program->ndecl) {
    fprintf( stderr, "Allocate larger program\n" );
    return 0;
    }
if (line + 1 > Program->n)
    Program->n = line + 1;
return Program->pgm + line;
}

/*@
  BCalloc - Allocate (and set defaults) a program with n entries

  Input Parameter:
. n - number of entries in the program
@*/
BCPGM *BCalloc( n )
int n;
{
BCPGM      *Program;
int        i;
extern double *BCDefaultAddress();

TRPUSH(BCTRID);

Program  = (BCPGM *)malloc(sizeof(BCPGM));
if (!Program) return 0;
Program->version    = BCVERSION;
Program->n          = 0;
Program->ndecl      = n;
Program->iscompiled = 0;
Program->isrunning  = 0;
Program->options    = 0;
Program->maxdim     = -1;        /* None set */
Program->basetype   = 0;
Program->ncalls     = 0;
Program->ntags      = 0;
Program->msgtype    = MY_MPI_FLOAT;
Program->elmsize    = sizeof(MY_FLOAT);
Program->ps         = 0;

Program->basend = 5;
for (i=0; i<5; i++)
    Program->basedims[i] = 0;

/* Set the functions to 0 as the default (routine BCSetDefault loads the
   default functions) */
Program->Error      = 0;
Program->copy       = 0;
Program->in         = 0;
Program->out        = 0;
Program->isend      = 0;
Program->irecv      = 0;
Program->irun       = 0;
Program->irunctx    = 0;
Program->iwait      = 0;
Program->compile    = 0;
Program->valid      = 0;
Program->trimmove   = 0;
Program->buffer     = 0;
Program->pairsync   = 0;
Program->inplace    = 0;
Program->findowner  = 0;
Program->settypes   = 0;
Program->sort       = 0;
Program->findlocal  = 0;
Program->schedule   = 0;
Program->GetAddressSrc  = BCDefaultAddress;
Program->GetAddressDest = BCDefaultAddress;
/* Set a default for getline */
Program->getline    = BCgetline;

/* Allocate the program space */
if (n > 0) {
    Program->pgm        = (BCentry *)malloc((unsigned)(sizeof(BCentry) * n ));
    if (!Program->pgm)return 0;;
    Program->pgm_last   = Program->pgm;
    if (!Program->pgm) return 0;
    /* Initialize the entries to zero in case an entry is not set */
    MEMSET( (char *)(Program->pgm), 0, sizeof(BCentry) * n );
    }
else {
    Program->pgm = Program->pgm_last = 0;
    }
Program->pgm_cur = Program->pgm;
TRPOP;
return Program;
}

/*@
   BCfree - Free an allocated program and any allocated space.

   Input Parameter:
.  Program - program to free 
@*/
void BCfree( Program )
BCPGM *Program;
{
BCentry *pgm;
int        n;

pgm = Program->pgm;
n   = Program->n;
while (n--) {
    /* Free any allocated buffer --- buffer-free routine? */
#ifdef DISTRIBUTED_MEMORY
    if ((pgm->type & BLOCK_COMM_BUFFER) && !pgm->inplace) {
#ifdef ALLOC_BUFFERS
	if (GET_MAJOR_MODE(pgm) == BLOCK_COMM_DEST)
	    MSGFREERECV(pgm->buffer);
	else
	    MSGFREESEND(pgm->buffer);
#else
	free(pgm->buffer );
#endif
        }
#endif
    NEXTLINE(pgm);
    }

/* Return the reserved tag values */
if (Program->ntags > 0) {
    PIReturnTags( Program->ps, Program->ntags, Program->basetype );
    }
free(Program->pgm );
free(Program );
}

void BCSetBaseDims( Program, nd, bd )
BCPGM *Program;
int   nd, *bd;
{
int i;

Program->basend = nd;
for (i=0; i<nd; i++)
    Program->basedims[i] = bd[i];
}

/*@
    BCSetProcset - Sets the processor set for a new program

    Input Parameters:
.   Program - BlockComm program created with BCAlloc.
.   ps      - ProcSet (from PSPartition or PSCreate)

    Notes:
    This must be set AFTER BCAlloc but before anything else (it isn't part
    of BCAlloc because BCAlloc predates ProcSets).

    Despite the presence of this routine, BlockComm is not yet compatible
    with processor sets.
@*/    
void BCSetProcset( Program, ps )
BCPGM *Program;
MPI_Comm ps;
{
Program->ps = ps;
}
