


#ifndef lint
static char vcid[] = "$Id: util3dad.c,v 1.1.1.1 1998/08/27 19:16:29 gropp Exp $";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */

#include "blkcm/bcp.h"

int BCs_to_d3dadd( s, d )
slab *s, *d;
{
register double *sp2 = s->p;
register double *dp2 = d->p;
register double *sp1, *sp, *dp1, *dp;
register int    n3  = s->n3, n2, n1, dinc = d->s1, sinc = s->s1;

while (n3--) {
    n2 = s->n2;
    dp1= dp2;
    sp1= sp2;
    while (n2--) {
        n1 = s->n1;
	dp = dp1;
	sp = sp1;
        while (n1--) {
	    *dp = *sp;
	    dp  += dinc;
	    sp  += sinc;
            }
	dp1 += d->inc1;
	sp1 += s->inc1;
        }
    dp2 += d->inc2;
    sp2 += s->inc2;
    }
return 0;
}

int BCb_to_d3dadd( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp2 = d->p;
register double *dp1, *dp;
register int    n3  = d->n3, n2, n1, dpinc = d->s1;

while (n3--) {
    n2 = d->n2;
    dp1= dp2;
    while (n2--) {
        n1 = d->n1;
	dp = dp1;
        while (n1--) {
	    *dp = *sp++;
	    dp  += dpinc;
            }
	dp1 += d->inc1;
        }
    dp2 += d->inc2;
    }
return 0;
}

