



#ifndef lint
static char vcid[] = "$Id: util1dad.c,v 1.1.1.1 1998/08/27 19:16:28 gropp Exp $";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */
#include "blkcm/bcp.h"
/* #include "inline/copy.h" */

/* 
  If you KNOW that you are moving 1-d slices, consider using these routines.
  There is an optimization option (TRIMMOVE) that will try to 
  use these routines.  Note that the stride is probably != 1 since 
  if the stride == 1, the inplace option will probably be used.
 */

int BCs_to_d1dadd( s, d )
slab *s, *d;
{
register double *sp = s->p;
register double *dp = d->p;
register int    n1  = s->n1, dinc = d->s1, sinc = s->s1;

while(n1--) {
    *dp += *sp; 
    dp  +=dinc; 
    sp  += sinc;
    }
return 0;
}

int BCb_to_d1dadd( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp = d->p;
register int    n1  = d->n1, dpinc = d->s1;

while(n1--) {
    *dp += *sp++; 
    dp  +=dpinc;
    }
return 0;
}

