#ifndef lint
static char vcid[] = "$Id: util1d.c,v 1.1.1.1 1998/08/27 19:16:28 gropp Exp $";
#endif

/* 
    This file contains routines for moving data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */
#include <stdio.h>
#include "blkcm/bcp.h"
/* #include "inline/copy.h" */

/* 
  If you KNOW that you are moving 1-d slices, consider using these routines.
  There is an optimization option (TRIMMOVE) that will try to 
  use these routines.  Note that the stride is probably != 1 since 
  if the stride == 1, the inplace option will probably be used.
 */

int BCs_to_d1d( s, d )
slab *s, *d;
{
register double *sp = s->p;
register double *dp = d->p;
register int    n1  = s->n1, dinc = d->s1, sinc = s->s1;

COPYINC3(dp,sp,dinc,sinc,n1);

return 0;
}

int BCs_to_b1d( s, b )
slab   *s;
double *b;
{
register double *sp = s->p;
register double *dp = b;
register int    n1  = s->n1, spinc = s->s1;

COPYINC1(dp,sp,spinc,n1);

return 0;
}

int BCb_to_d1d( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp = d->p;
register int    n1  = d->n1, dpinc = d->s1;

COPYINC2(dp,sp,dpinc,n1);

return 0;
}

#include "blkcm/bc.h"
/* 
   Routine to set the entries for a line for a 1-d structure
   Really should have datatypes: DOUBLE, LONG, INT, CHAR, FLOAT, sizeof() .
 */
int BCset1d( Program, line, id, phase, kind, p, n1, s1 )
BCPGM  *Program;
int    line, id, phase, kind, n1, s1;
void   *p;
{
BCentry *pgm;

pgm = (*Program->getline)( Program, line );
if (!pgm) return ERR_NO_PGM_LINE;

pgm->id       = id;
pgm->phase    = phase;
pgm->type     = kind;
pgm->processor= -1;
pgm->src.s1   = s1;
pgm->src.n1   = n1;
pgm->src.n2   = 1;
pgm->src.n3   = 1;
pgm->src.n4   = 1;
pgm->src.n5   = 1;
pgm->src.inc1 = 1;
pgm->src.inc2 = 1;
pgm->src.inc3 = 1;
pgm->src.inc4 = 1;
pgm->src.lctx = p;

if (Program->maxdim < 1) Program->maxdim = 1;
return ERR_NONE;
}
