



#ifndef lint
static char vcid[] = "$Id: trimmove.c,v 1.1.1.1 1998/08/27 19:16:28 gropp Exp $";
#endif

#include "blkcm/bcp.h"
#include "blkcm/bc.h"

/*
   Look to see if all moves are lower-dimensional moves; if so, 
   replace in/out/copy with optimized lower-dimensional versions
 */
int BCtrim_moves( Program )
BCPGM *Program;
{
extern      BCs_to_d1d(), BCb_to_d1d(), BCs_to_b1d();
extern      BCs_to_d2d(), BCb_to_d2d(), BCs_to_b2d();
extern      BCs_to_d3d(), BCb_to_d3d(), BCs_to_b3d();
extern      BCs_to_d4d(), BCb_to_d4d(), BCs_to_b4d();

/* BCOptimizeMoves( Program ); */
if (Program->elmsize == sizeof(double)) {
    switch (Program->maxdim) {
	case 1: Program->copy       = BCs_to_d1d;
	        Program->in         = BCb_to_d1d;
	        Program->out        = BCs_to_b1d; break;
	case 2: Program->copy       = BCs_to_d2d;
 	        Program->in         = BCb_to_d2d;
	        Program->out        = BCs_to_b2d; break;
	case 3: Program->copy       = BCs_to_d3d;
	        Program->in         = BCb_to_d3d;
	        Program->out        = BCs_to_b3d; break;
	case 4: Program->copy       = BCs_to_d4d;
	        Program->in         = BCb_to_d4d;
	        Program->out        = BCs_to_b4d; break;
	/* Default case---do not change */
	}
    }
return 0;
}

/*
   This routine optimizes the moves by:
   1. compressing out unit dimensions
   2. reordering for maximum to minimum lengths 
   3. merging dimensions that are contiguous (This is done by testing to
      see if n[i] = incr[i+1]; if so, we merge n[i] into n[i+1].)
 */
int BCOptimizeMoves( Program )
BCPGM *Program;
{
BCentry    *pgm = Program->pgm;
int        npg  = Program->n;
int        maxdim = -1;
int        n[5], incr[5];
int        nf[5], incrf[5];
int        i, j, k, itmp;
slab       *s;

while (npg--) {
    s = &pgm->src;
    n[0] = s->n1; n[1] = s->n2; n[2] = s->n3; n[3] = s->n4; n[4] = s->n5;
    incr[0] = s->s1; incr[1] = s->inc1; incr[2] = s->inc2; incr[3] = s->inc3;
    incr[4] = s->inc4;
    j  = 0;
    /* Find the non-unit lengths */
    for (i=0; i<5; i++) {
	nf[i]    = 1;
	incrf[i] = 1;
	if (n[i] > 1) {
	    nf[j]    = n[i];
	    incrf[j] = incr[i];
	    j++;
	    }
	}
#define FOO
#ifdef FOO
    /* Merge contiguous blocks */
    k = 0;
    for (i=1; i<j; i++) {
	if (nf[k] == incrf[i] && incrf[k] == 1) {
	    nf[k]    *= nf[i];
	    }
	else {
	    k++;
	    nf[k]    = nf[i];
	    incrf[k] = incrf[i];
	    }
	}
    k++;
    for (i=k; i<j; i++) {
	nf[i]    = 1;
	incrf[i] = 1;
	}
    j = k;
#endif
    /* Bubble sort the lengths */
#define DOSORT
#ifdef DOSORT
    for (i=0; i<j; i++) {
	for (k=i+1; k<j; k++) {
	    if (nf[i] < nf[k]) {
		itmp = nf[i]; nf[i] = nf[k]; nf[k] = itmp;
		itmp = incrf[i]; incrf[i] = incrf[k]; incrf[k] = itmp;
		}
	    }
	}
#endif
    s->n1 = nf[0]; s->n2 = nf[1]; s->n3 = nf[2]; s->n4 = nf[3]; s->n5 = nf[4];
    s->s1 = incrf[0]; s->inc1 = incrf[1]; s->inc2 = incrf[2]; 
    s->inc3 = incrf[3]; s->inc4 = incrf[4];

    if (maxdim < j) maxdim = j;
    NEXTLINE(pgm);
    }

/* Reset the maximum dimension */
Program->maxdim = maxdim;
return 0;
}
