

#ifndef lint
static char vcid[] = "$Id: settype.c,v 1.1.1.1 1998/08/27 19:16:27 gropp Exp $";
#endif

#include <stdio.h>
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#ifdef DISTRIBUTED_MEMORY

/*
   This routine sets the message types.  It should be replace/augmented
   with one that determines the types at runtime.  In addition, it could
   look for forcetypes and pair exchanges.

   Algorithm:
   Find range of phases.  Make 

   mtype = BASE_MTYPE + (id .. (phase-minphase)<<1 + (ncalls&0x1)),

   where id is shifted enough to leave room for the phase.  ncalls is the
   number of times that BCexec has been called; this is an easy way to insure
   that successive BCexec calls with the same program do not interfere 
   (they should not anyway, but it can't hurt).

   We ALSO need to make the types unique to a PROCESS that holds multiple
   programs.  Perhaps using a static that everyone agrees on (max of
   any current value?).

   Instead, we will use PIGetTags to get a base value.  The number needed is
   (maxid + 1) * 2**shft - 1;
 */
int BCset_types( Program )
BCPGM *Program;
{
BCentry *pgm = Program->pgm;
int        n    = Program->n;
int        minphase, maxphase, psize, shft, maxid, 
           btype= Program->basetype;
int        ntags;
int        gvals[4], gwork[4];

/* Set defaults for the min/max phases for those processors that have
   no programs */
minphase = 2000000000;
maxphase = -2000000000;
maxid    = 0;
if (n != 0) {
    /* Find the range of phases */
    minphase = pgm->phase;
    maxphase = minphase;
    n--;
    NEXTLINE(pgm);
    while (n--) {
	if (pgm->phase > maxphase)      maxphase = pgm->phase;
	else if (pgm->phase < minphase) minphase = pgm->phase;
	if ((pgm->type & BLOCK_COMM_BUFFER) && 
	    pgm->mtype > maxid)         maxid    = pgm->mtype;
	NEXTLINE(pgm);
	}
    }
/* Make sure that we have the phase limits for ALL processors */
/* Do these as a single, 4 element max */
gvals[0] = -minphase; gvals[1] = maxphase; gvals[2] = maxid; 
gvals[3] = Program->n;
PIgimax( gvals, 4, gwork, Program->ps );
minphase = -gvals[0]; maxphase = gvals[1]; maxid = gvals[2]; n = gvals[3];

if (n == 0) {
    /* Nothing to do (empty program on all processors */
    if (!Program->basetype) {
	Program->ntags	  = 0;
	Program->basetype = 0;
	}
    return 0;
    }

/* shft is the number of BITS in psize */
shft = 0;
psize= maxphase - minphase;
while (psize > 0) {
    psize >>= 1;
    shft++;
    }
/* Add a bit for the parity of ncalls */
shft ++;
/* Should check for shft out-of-range */

/* reserve enough message types */
ntags = (maxid + 1) << shft - minphase; 
if (!Program->basetype) {
    Program->ntags = ntags;
    btype	   = PIGetTags( Program->ps, ntags );
    if (btype < 0) {
	fprintf(stderr,"Error: %s\n","Not enough message tags available");
	}
    Program->basetype = btype;
    }

/* Set the message types */
pgm = Program->pgm;
n   = Program->n;
/* The "buffer" routine sets mtype to id prior to this */
while (n--) {
    if (pgm->type & BLOCK_COMM_BUFFER) {
	pgm->mtype = btype + (pgm->mtype << shft) + 
	             ((pgm->phase - minphase) << 1);
	}
    NEXTLINE(pgm);
    }
return 0;
}

int BCset_types_dynamic( Program )
BCPGM *Program;
{
fprintf(stderr,"Error: %s\n","dynamic type setting not implemented!");
return 0;
}
#endif

/* 
   Let the user set the base type to use.  They should not use this;
   rather, let the PIGetTags call handle this...
 */
int BCset_base_type( Program, val )
BCPGM *Program;
int   val;
{
Program->basetype = val;
return 0;
}











