



#ifndef lint
static char vcid[] = "$Id: pairsync.c,v 1.1.1.1 1998/08/27 19:16:27 gropp Exp $";
#endif

/*
   This file contains routines to take advantage of pairwise synchronization
   of messages between processors pairs.
 */

#include <stdio.h>   
#include "blkcm/bcp.h"
#include "blkcm/bc.h"

#ifdef DISTRIBUTED_MEMORY
/*
   Turn on the pair/sync bits, but only where it makes sense
   (short messages should not use this method).

   This can be made smarter.  For example,

   If all irecvs are issued before any sends, then 
       if we've received from or sent to this node before, then
           mtype |= BASE_FORCE and do NOT set SYNC_NBR 
	   (just use the force type).

   This can be done by keep an array of size NUMNODES, initially set
   to zero, that contains whether we've communicated with
   that processor.
 */
int BCset_pair_sync( Program )
BCPGM *Program;
{
BCentry    *pgm = Program->pgm;
int           n    = Program->n;
int           *hassync, i, np = __NUMNODES;

TRPUSH(BCTRID+5);
hassync = (int *)malloc((unsigned)(np * sizeof(int) ));
if (!hassync) {
    (*Program->Error)( "Can not allocate space in pairsync\n" );
    return 1;
    }

for (i=0; i<np; i++)
    hassync[i] = 0;

while (n--) {
    if (pgm->type & BLOCK_COMM_BUFFER) {
	if ((pgm->type & (BLOCK_COMM_SRC | BLOCK_COMM_DEST)) &&
	    pgm->act_len > MIN_PAIR_SIZE) {
	    if (!hassync[pgm->processor]) {
		pgm->type |= BLOCK_COMM_SYNC_NBR;
		hassync[pgm->processor] = 1;
		}
	    else 
		pgm->type |= BLOCK_COMM_FORCETYPE;
	    }
	}
    NEXTLINE(pgm);
    }
free(hassync );
TRPOP;

return 0;
}
#endif

