



#ifndef lint
static char vcid[] = "$Id: mshsort.c,v 1.1.1.1 1998/08/27 19:16:27 gropp Exp $";
#endif

/*
   Helper routines for using the mesh communication package.
 */
#include "blkcm/bcp.h"
#include "blkcm/bc.h"

/*
   Sort a program by phases, then by operation.  If a parallel version,
   then sort by processor and id.
 */
static int BCdif_phase( p1, p2 )
BCentry *p1, *p2;
{
if (p1->phase != p2->phase)
    return p1->phase - p2->phase;
if (p1->type != p2->type)
    return p1->type - p2->type;
/* By sorting FIRST on the neighbor processor, we can merge messages
   sent to/from the same processor.  Since the ids and lengths match,
   we don't need to wrap an "envelope" around the message. */
if (p1->processor != p2->processor)
    return p1->processor - p2->processor;
/* The ids should actually be unique */
if (p1->id != p2->id)
    return p1->id - p2->id;
/* Keep the program in the same order otherwise */
return (int)(p1-p2);
}

/*
   Algorithm: Sort by phase, replace the first SEND after a change in
   phase with SYNC_RECV_AND_SEND.
 */
int BCsort_phase( Program )
BCPGM  *Program;
{
BCentry *pgm = Program->pgm;
int        n    = Program->n;
int i, oldphase;

qsort( (char *)pgm, n, sizeof(BCentry), (int (*)())BCdif_phase );

oldphase = pgm->phase;
for (i=1; i<n; i++) {
    if (pgm[i].phase != oldphase) {
        while (i<n && !IS_SRC(pgm+i)) i++;
        if (i<n) {
	    /* Question: is this consistent with local blocks (not
	       yet identified)? */
            pgm[i].type |= BLOCK_COMM_SYNC_BLOCK;
            oldphase    = pgm[i].phase;
            }
        }
    }
return 0;
}

