dnl
dnl Special configure macros
dnl
dnl
dnl Still missing is the FORTRANDOUBLEUNDERSCORE test
define(AC_FORTRAN_NAMES_IN_C,[
AC_MSG_CHECKING(for Fortran external names)
# First, compile a Fortran program:
/bin/rm -f conff.f
cat > conff.f <<EOF
        subroutine d1chk()
        return
        end
EOF
if $FC -c conff.f >/dev/null 2>&1 ; then 
    :
else
    echo "Could not compile Fortran routine"
fi
# Now, build a C program and try to link with it
cat > conf.c <<EOF
main() {
d1chk_();
return 0;
}
EOF
if $CC -o conf conf.c conff.o >/dev/null 2>&1 ; then
    AC_DEFINE(HAVE_FORTRAN_UNDERSCORE)
    FORTRAN_NAMING="-DHAVE_FORTRAN_UNDERSCORE -DFORTRANUNDERSCORE -DHAS_HASH"
    /bin/rm -f conf conf.c conff.f conff.o conf.o
    AC_MSG_RESULT(trailing underscore)
else
    /bin/rm -f conf conf.c conf.o
    cat > conf.c <<EOF
main() {
d1chk();
return 0;
}
EOF
    if $CC -o conf conf.c conff.o >/dev/null 2>&1 ; then 
        AC_DEFINE(HAVE_FORTRAN_NOUNDERSCORE)
        FORTRAN_NAMING="-DHAVE_FORTRAN_NOUNDERSCORE"
        /bin/rm -f conf conf.c conff.f conff.o conf.o
        AC_MSG_RESULT(no underscore)
    else
        /bin/rm -f conf conf.c conf.o
        cat > conf.c <<EOF
main() {
D1CHK();
return 0;
}
EOF
        if $CC -o conf conf.c conff.o >/dev/null 2>&1 ; then 
            AC_DEFINE(HAVE_FORTRAN_CAPS)
	    # HAS_CAP used in Src/c_driver.c
            FORTRAN_NAMING="-DHAVE_FORTRAN_CAPS -DHAS_CAP -DFORTRANCAPS"
            /bin/rm -f conf conf.c conff.f conff.o conf.o
            AC_MSG_RESULT(uppercase)
        else
	    FORTRAN_NAMING=""
            AC_MSG_RESULT(unknown!)
        fi
    fi
fi
/bin/rm -f conf conf.c conff.f conff.o conf.o
#
AC_SUBST(FORTRAN_NAMING)])
dnl
dnl Check that a function prototype will work.  This is used to handle
dnl the various variants in such things as "select" and "connect" (!)
dnl The need to do this is one of the reasons that Window NT will win.
dnl
dnl AC_CHECK_PROTOTYPE(foo(int,...),action-if-corrent,action-if-fails)
define(AC_CHECK_PROTOTYPE,[
AC_TRY_COMPILE($1,return 1;,$2,$3)
])
dnl
dnl
dnl PAC_CHECK_COMPILER_OPTION(optionname,action-if-ok,action-if-fail)
dnl This should actually check that compiler doesn't complain about it either,
dnl by compiling the same program with two options, and diff'ing the output.
dnl
define([PAC_CHECK_COMPILER_OPTION],[
AC_MSG_CHECKING([that C compiler accepts option $1])
CFLAGSSAV="$CFLAGS"
CFLAGS="$1 $CFLAGS"
echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} $CFLAGS -c conftest.c 2>&1`"; then
  AC_MSG_RESULT(yes)
  $2
else
  AC_MSG_RESULT(no)
  $3
fi
rm -f conftest*
CFLAGS="$CFLAGSSAV"
])
dnl
dnl PAC_CHECK_FC_COMPILER_OPTION is like PAC_CHECK_COMPILER_OPTION,
dnl except for Fortran 
define([PAC_CHECK_FC_COMPILER_OPTION],[
AC_MSG_CHECKING([that Fortran compiler accepts option $1])
FFLAGSSAV="$FFLAGS"
FFLAGS="$1 $FFLAGS"
cat >conftest.f <<EOF
        program main
        end
EOF
/bin/rm -f conftest1.out conftest2.out
if $FC $FFLAGS -c conftest.f > conftest1.out 2>&1 ; then
    if $FC $FFLAGSSAV -c conftest.f > conftest2.out 2>&1 ; then
        if diff conftest2.out conftest1.out ; then
            AC_MSG_RESULT(yes)
            $2
	else
            AC_MSG_RESULT(no)
            cat conftest2.out >> config.log
            $3
	fi
    else
        AC_MSG_RESULT(no)
        cat conftest2.out >> config.log
        $3
    fi
else
    AC_MSG_RESULT(no)
    cat conftest1.out >> config.log
    $3
fi
rm -f conftest*
FFLAGS="$FFLAGSSAV"
])
define(PAC_FORTRAN_GET_TYPE_SIZE,
[AC_MSG_CHECKING([for size of Fortran Type $1])
/bin/rm -f conftestval
/bin/rm -f conftestf.f conftestf.o
cat <<EOF > conftestf.f
      subroutine isize( )
      $1 i(2)
      call cisize( i(1), i(2) )
      end
EOF
if $FC $FFLAGS -c conftestf.f >/dev/null 2>&1 ; then 
    SaveLIBS="$LIBS"
    LIBS="conftestf.o $LIBS"
    AC_TEST_PROGRAM([#include <stdio.h>
#ifdef HAVE_FORTRAN_CAPS
#define cisize_ CISIZE
#define isize_  ISIZE
#elif defined(HAVE_FORTRAN_NOUNDERSCORE)
#define cisize_ cisize
#define isize_  isize
#endif
static int isize_val;
void cisize_( i1p, i2p )
char *i1p, *i2p;
{
	isize_val = (i2p - i1p) * sizeof(char);
}
main() { 
  FILE *f=fopen("conftestval","w");
  
  if (!f) exit(1);
  isize_();
  fprintf( f, "%d\n", isize_val);
  exit(0);
}],Pac_CV_NAME=`cat conftestval`,Pac_CV_NAME="")
LIBS="$SaveLIBS"
else
   :
fi
/bin/rm -f conftestf.f conftestf.o
if test -n "$Pac_CV_NAME" -a "$Pac_CV_NAME" != 0 ; then
    AC_MSG_RESULT($Pac_CV_NAME)
else
    AC_MSG_RESULT(unavailable)
fi
$2=$Pac_CV_NAME
])dnl
dnl PAC_GET_TYPE_SIZE(typename,var_for_size)
dnl
dnl sets var_for_size to the size.  Ignores if the size cannot be determined
dnl Also sets typename_len to the size; if that is already set, just uses
dnl that
dnl
define(PAC_GET_TYPE_SIZE,
[Pac_name="$1"
 Pac_varname=`echo "$Pac_name" | sed -e 's/ /_/g' -e 's/\*/star/g'`
eval Pac_testval=\$"${Pac_varname}_len"
if test -n "$Pac_testval" ; then
    Pac_CV_NAME=$Pac_testval
else
 AC_MSG_CHECKING([for size of $Pac_name])
 /bin/rm -f conftestval
 AC_TEST_PROGRAM([#include <stdio.h>
main() { 
  FILE *f=fopen("conftestval","w");
  if (!f) exit(1);
  fprintf( f, "%d\n", sizeof($Pac_name));
  exit(0);
}],Pac_CV_NAME=`cat conftestval`,Pac_CV_NAME="")
 if test -n "$Pac_CV_NAME" -a "$Pac_CV_NAME" != 0 ; then
    AC_MSG_RESULT($Pac_CV_NAME)
    eval ${Pac_varname}_len=$Pac_CV_NAME
 else
    AC_MSG_RESULT(unavailable)
 fi
fi
$2=$Pac_CV_NAME
])dnl
