*/*F
**************************************************
*                                                *
*  subroutine VOL_RENDER                         *
*                                                *
*  Dump the arrays suitable for volume rendering *
*                                                *
*    Author: Andrea Malagoli                     *
*    Date: 16 June 1995                          *
*                                                *
**************************************************
*F*/
      subroutine vol_render(sz,proc,pgm,filenames,
     &              ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &              gravx, gravy, gravz, phi, r, wrk,  
     &              step_par, grid_par, fluid_par, do_par )

      include 'meshf.h'
      include 'param.h'
      parameter (ndim = 3)
      integer sz(sz_0:sz_1,ndim,1)
      integer proc(p_0:p_1), pgm(*)

      dimension ux(*), uy(*), uz(*), rho(*), press(*)
      dimension temp(*), scalar(*), wrk(*)
      dimension x(*), y(*), z(*)
      dimension phi(*), gravx(*), gravy(*), gravz(*)

      character*7 filenames(2)

*.... Local Variables ...............................*
      integer gdim(3)
      logical printinfo, check_conv
      character*80 out_file
      character*1 swpd
*....................................................*

      myid = proc(p_id)

*.... Get the various array sizes ......*
      call AL_get_global_dim(gdim,sz,3)
      nx = gdim(1)
      ny = gdim(2)
      nz = gdim(3)
      call AL_get_array_bounds(bx, ex, bxgp, exgp, 'x', sz)
      call AL_get_array_bounds(by, ey, bygp, eygp, 'y', sz)
      call AL_get_array_bounds(bz, ez, bzgp, ezgp, 'z', sz)

*>>>>>>>>>>>>>>>>>>>APPLY BOUNDARY CONDITIONS>>>>>>>>>>>>>>>>>>>*
*.... This is where all the parallelism is taken into account .....
c        Call BC_Fluid(sz,proc,pgm,
c     &                bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp,
c     &                ux, uy, uz, rho, press, temp, x, y, z,
c     &                gravx, gravy, gravz, phi, src,
c     &                step_par, grid_par, fluid_par , swpd)
*....... Now we are ready to begin ...............*
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*

*.... Here we dump the logarithm of the density ....*
      out_file = 'vr_logrho'

      arrmax = 0.d0
      arrmin = 0.d0

      call make_log_rho(wrk,rho,
     &    bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
      
      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      wrk,arrmax,arrmin)
*...........................................................*

*.... Here we dump the kinetic energy ....*
      out_file = 'vr_ek'

      arrmax = 0.d0
      arrmin = 0.d0

      call make_ek(wrk,ux,uy,uz,
     &    bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
      
      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      wrk,arrmax,arrmin)
*...........................................................*

*.... Here we dump the Mach Number .........................*
*    (Note that now wrk has the Kinetic Energy)

      out_file = 'vr_mach'

      arrmax = 0.d0
      arrmin = 0.d0

      gamma = fluid_par(4)

      call make_mach_number(wrk,temp,gamma,
     &    bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
      
      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      wrk,arrmax,arrmin)
*...........................................................*

*.... Here we dump the the temperature ....*
      out_file = 'vr_temp'

      arrmax = 0.d0
      arrmin = 0.d0

      
      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      temp,arrmax,arrmin)

*...........................................................*
      

*.... Here we dump the the density .........................*
      out_file = 'vr_rho'

      arrmax = 0.d0
      arrmin = 0.d0

      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      rho,arrmax,arrmin)
*...........................................................*
*.... Here we dump the the pressure .........................*
      out_file = 'vr_press'

      arrmax = 0.d0
      arrmin = 0.d0
      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      press,arrmax,arrmin)
*...........................................................*

*.... Here we dump the passive scalar .......................*
      out_file = 'vr_scalar'

      arrmax = 0.d0
      arrmin = 0.d0
      call dump_raster_3d(sz,out_file,step_par,out_par,
     &                      scalar,arrmax,arrmin)
*...........................................................*

      return
      end

*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*
      subroutine make_mach_number(out,temp,gamma,
     &    bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
      include 'meshf.h'
      dimension out(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension temp(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)

          Do k = bz, ez
          Do j = by, ey
          Do i = bx, ex
               ek  = out(i,j,k)
               tem = temp(i,j,k)
               amach2 = ek/(gamma*tem)
               amach  = sqrt(amach2)
               out(i,j,k) = amach
          End Do
          End Do
          End Do      

      return
      end
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*

*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*
      subroutine make_log_rho(out,rho,
     &    bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
      include 'meshf.h'
      dimension out(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension rho(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)

          Do k = bz, ez
          Do j = by, ey
          Do i = bx, ex
               out(i,j,k) = log10(rho(i,j,k))
          End Do
          End Do
          End Do      

      return
      end
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*
      subroutine make_ek(out,ux,uy,uz,
     &    bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
      include 'meshf.h'
      dimension out(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension ux(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension uy(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension uz(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)

          Do k = bz, ez
          Do j = by, ey
          Do i = bx, ex
            out(i,j,k) = (ux(i,j,k)**2+uy(i,j,k)**2+uz(i,j,k)**2)
          End Do
          End Do
          End Do      

      return
      end
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*
