*/*F
* MG_FIND_LEVELS -- Find the level for the multigrid.
*
*     intger function mg_find_levels(sz,mg,ndim,proc)
*
* Inputs: sz   The array which contains the descriptor of the decompostition
*
*         proc The array which contains the processor information
*
*         mg   The returned array with the relevant information
*              (see meshf.h for a description of the entries
* 
*         ndim the number of dimensions.
*
* On output, mg_find_lev returns the number of levels.
*
*F*/
      integer function mg_find_levels(sz,mg,ndim,proc)

      include 'meshf.h'

*.... This may change in the future .....
      parameter( low_size_def = 2 )

      integer sz(sz_0:sz_1,ndim,max_lev)
      integer proc(p_0:p_1)
      integer mg(mg_0:mg_1,ndim,max_lev)

*.......................................................................
      integer ldim(3), gdim(3), glevdim(3), lowdim(3)
      integer nlev,nlowx,nlowy,npx,npy,myid,nproc
      integer s,e,n
      integer lsize, gsize
      integer lproc(p_0:p_1)
      character*2 dir(2:20)

*.... Get global array dimensions .....
      Do i = 1, ndim
	 gdim(i) = sz(sz_mdim,i,1)
      End Do

*.... Set this to fill in for the 2D case.
      ldim(3) = 1000000

      call AL_get_local_dim(ldim,sz,ndim)

      nmin=min0(ldim(1),ldim(2),ldim(3))

      nproc = proc(p_np)

      nprocx = proc(p_npx)
      nprocy = proc(p_npy)
      nprocz = proc(p_npz)

*..... Determine the number of parallel levels ......
      if(mod(nmin,3).eq.0)then
         nlev = nint(alog(float(nmin)/3.0)/alog(2.0))
      else if(mod(nmin,5).eq.0) then
         nlev = nint(alog(float(nmin)/5.0)/alog(2.0))
      else if(mod(nmin,7).eq.0) then
         nlev = nint(alog(float(nmin)/7.0)/alog(2.0))
      else
         isc = low_size_def/2
         nlev = nint(alog(float(nmin/isc))/alog(2.0))
      endif

*.... Now determine the levels for the global LOW array
      Do j = 1, ndim
        lowdim(j) = gdim(1)/2**(nlev-1)
      End Do

      nmin=min(lowdim(1),lowdim(2),lowdim(3))

      if(mod(nmin,3).eq.0)then
         nlowlev = nint(alog(float(nmin)/3.0)/alog(2.0))
      else if(mod(nmin,5).eq.0) then
         nlowlev = nint(alog(float(nmin)/5.0)/alog(2.0))
      else if(mod(nmin,7).eq.0) then
         nlowlev = nint(alog(float(nmin)/7.0)/alog(2.0))
      else
         isc = low_size_def/2
         nlowlev = nint(alog(float(nmin/isc))/alog(2.0))
      endif

*... This is tricky: the last parallel level is replicated
*... twice, because we have to account for the collect
*... operation. the mg_mlev index will contain the correct
*... information about what level we are doing.
      ntotlev = nlev + nlowlev - 1

*.... Now set the mg structure for the parallel levels ......
      Do i = 1, nlev
      Do j = 1, ndim
	 glevdim(j) = gdim(j)/2**(i-1)
	 mg(mg_nlev ,j,i) = ntotlev
         mg(mg_plev ,j,i) = nlev
	 mg(mg_mdim ,j,i) = glevdim(j)
	 mg(mg_ldim ,j,i) = ldim(j)/2**(i-1)
	 mg(mg_dir  ,j,i) = 1
	 mg(mg_mlev ,j,i) = i
	 if( gdim(j) .eq. ldim(j) ) then
	   mg(mg_isparallel,j,i) = 0
	 else
	   mg(mg_isparallel,j,i) = 1
	 endif
      End Do
	 if( i .ne. 1) then
           call AL_set_global_dim(glevdim,sz(sz_0,1,i),ndim)
	   call AL_decomp_array(sz(sz_0,1,i),ndim,proc,mgrid_stencil,2)
	 endif
      End Do

*.... Now set the mg structure for the NOPARALLEL levels ......

*.... Here is how it works: the  indexes  nlev  and nlev+1
*.... really contain the same level ilev = nlev. The nlev
*.... index has the decomposition for the distributed (parallel)
*.... array, while the nlev+1 index has the decomposition for the
*.... fully local array. 
*
*.... Basically, when the multigrid iterates down to ilev = nlev
*.... it skips one cycle and does a global collection operation
*.... instead. The nlev  level is then iterated in the nlev+1
*.... loop, and it is a fully local process.

*.... If this process is parallel then ..........
      if( nproc .gt. 1 ) then

      lproc(p_id)  = proc(p_id)
      lproc(p_np)  = 1
      lproc(p_npx) = 1
      lproc(p_npy) = 1
      lproc(p_npz) = 1

      Do i = nlev+1, ntotlev+1
      Do j = 1, ndim
	 glevdim(j) = lowdim(j)/2**(i-nlev-1)
	 mg(mg_nlev ,j,i) = ntotlev
         mg(mg_plev ,j,i) = nlev
	 mg(mg_mdim ,j,i) = glevdim(j)
	 mg(mg_ldim ,j,i) = glevdim(j)
	 mg(mg_dir  ,j,i) = 1
	 mg(mg_mlev ,j,i) = i-1
	 mg(mg_isparallel,j,i) = 0
      End Do
	 if( i .ne. 1) then
           call AL_set_global_dim(glevdim,sz(sz_0,1,i),ndim)
	   call AL_decomp_array(sz(sz_0,1,i),ndim,lproc,mgrid_stencil,2)
	 endif
      End Do

*.... Find sizes of local and global buffers (used in collect) ....
      lsize = 1
      gsize = 1
      Do i = 1, ndim
	s = sz(sz_start,i,nlev)
	e = sz(sz_end,i,nlev)
	n = sz(sz_mdim,i,nlev)
	lsize = lsize*(e-s+1)
        gsize = gsize*n
      End Do

*.... Else this is a single processor business ..........*
      else
        lsize = 0
        gsize = 0
      endif

*.... Finally, assign the same decomposition to all levels ....
      Do i = 1, ntotlev+1
      Do j = 1, ndim
         mg(mg_lbuf,j,i) = lsize
         mg(mg_gbuf,j,i) = gsize
      End Do
      End Do

      mg_find_levels = ntotlev

      return
      end

*.....................................................
*/*F
*
* MG_FIND_BUFFERS
*
* Find the size of the local and global buffers.
*
* character*10  type   Either 'linear' or 'nonlinear'
*
*F*/
	subroutine mg_find_buffers(sz,mg,ndim,proc,igbuf,ilbuf)

	include 'meshf.h'

	integer mg(mg_0:mg_1,ndim,max_lev)
	integer sz(sz_0:sz_1,ndim,max_lev)
	integer proc(p_0:p_1)
	integer lsize, gsize
	integer s,e,n

	integer type

	nlev = mg(mg_nlev,1,1)
	nplev = mg(mg_plev,1,1)
	type = mg(mg_type,1,1)
	nproc = proc(p_np)

*.... Do the following only if NPROC = 1 .........................
	if( nproc .eq. 1 ) then 
	   mlbuf = 0
	   mgbuf = 0
	
*.... Else NPROC != 1 ..............................................
        else

*.... Find sizes of local and global buffers (used in collect) ....
        lsize = 1
        gsize = 1
        Do i = 1, ndim
	 s = sz(sz_start,i,nplev)
	 e = sz(sz_end,i,nplev)
	 n = sz(sz_mdim,i,nplev)
	 lsize = lsize*(e-s+1)
         gsize = gsize*n
        End Do


*..... Modify the buffer size depending on the type of multigrid ...
	mlbuf = (lsize + 2*ndim )
	mgbuf = (gsize + 2*ndim*nproc )

	if( type .eq. MG_LINEAR ) then
	    mgbuf = mgbuf*2
	    mlbuf = mlbuf*2
	else
	    mgbuf = mgbuf*3
	    mlbuf = mlbuf*3
	endif

*.... End Else NPROC != 1 ..............................................
       endif

*..... Fill in all levels ..............
	Do i = 1, nlev
	Do j = 1, ndim
	  mg(mg_gbuf,j,i) = mgbuf
	  mg(mg_lbuf,j,i) = mlbuf
	End Do
	End Do

	igbuf = mgbuf
	ilbuf = mlbuf

	return
	end

*.....................................................
*/*F
*
* subroutine MG_SET_TYPE
*
* Set the type of multigrid: "linear" "nonlinear"
*
*F*/
	subroutine mg_set_type(mg,ndim,type)

	include 'meshf.h'
	integer mg(mg_0:mg_1,ndim,1)
	integer nlev, ndim
	integer type

        nlev = mg(mg_nlev,1,1)

	Do j = 1, nlev
	Do i = 1, ndim
	    mg(mg_type,i,j) = type
	End Do
	End Do

	return
	end

*.....................................................
*/*F
*
* subroutine MG_GET_WRK_OFFS
*
* Set the offsets for the various levels of the multigrid
*
*F*/
	subroutine mg_get_wrk_offs(noff,sz,mg,ndim,type)

	include 'meshf.h'
	integer noff(max_lev+1)
	integer mg(mg_0:mg_1,ndim,1)
	integer sz(sz_0:sz_1,ndim,1)
	integer nlev, ndim
	integer type, isize

	nlev = mg(mg_nlev,1,1)
	nplev = mg(mg_plev,1,1)

	noff(1) = 1
        noff(2) = 1

*.... Check if there are non parallel levels ......*
c	if( nlev .eq. nplev ) nend = nlev+1
c	if( nlev .lt. nplev ) nend = nlev+2
        nend = nplev+2

	Do il = 3, nlev+2
	   call AL_get_array_tsize(isize,sz(sz_0,1,il-1),ndim)
           noff(il) = noff(il-1) + isize
	End Do

        Return
	End 
