*/*F
*
*   GRID utility routines
*
*   These routines include all sorts of goodies to
*   set up the geometry and the boundary conditins
*   on a regular mesh.
*
*F*/

*....................................................................*
*/*F
*  function GET_BC_CODE
*
*  Given the name of a boundary condition
*  return the associated numerical code.
*
*F*/
      function GR_get_bc_code(bc_name)
      character*8 bc_name

      GR_get_bc_code = -1
      if( bc_name .eq. 'flowin' )  GR_get_bc_code = 0
      if( bc_name .eq. 'flowout' ) GR_get_bc_code = 1
      if( bc_name .eq. 'noflow' )  GR_get_bc_code = 2
      if( bc_name .eq. 'reflect' ) GR_get_bc_code = 3
      if( bc_name .eq. 'fixed' )   GR_get_bc_code = 4
      if( bc_name .eq. 'period' )  GR_get_bc_code = 5
      if( bc_name .eq. 'comm' )    GR_get_bc_code = 6

      if( GR_get_bc_code .eq. -1)
     & print *,
     & 'Warning in GET_BC_CODE: name does not match known bc s'

      return
      end

*....................................................................*
*/*F
*  subroutine GET_BC_NAME
*
*  Given the numerical code of a boundary condition
*  return the associated name.
*
*  character*8  bc_name
*  real code
*
*F*/
      subroutine GR_get_bc_name(bc_name,code)
      character*8 bc_name

      if( code .eq. 0 ) bc_name = 'flowin' 
      if( code .eq. 1 ) bc_name = 'flowout' 
      if( code .eq. 2 ) bc_name = 'noflow' 
      if( code .eq. 3 ) bc_name = 'reflect'
      if( code .eq. 4 ) bc_name = 'fixed' 
      if( code .eq. 5 ) bc_name = 'period'
      if( code .eq. 6 ) bc_name = 'comm'

      return
      end
*....................................................................*
*....................................................................*
*/*F
*  function GET_GEOM_CODE
*
*  Given the name of a geometry condition
*  return the associated numerical code.
*
*F*/
      function GR_get_geom_code(geom_name)
      character*8 geom_name

      GR_get_geom_code = -1
      if( geom_name .eq. 'cart' )     GR_get_geom_code = 0
      if( geom_name .eq. 'cylr' )     GR_get_geom_code = 1
      if( geom_name .eq. 'cylphi' )   GR_get_geom_code = 2
      if( geom_name .eq. 'spherr' )   GR_get_geom_code = 3
      if( geom_name .eq. 'spherphi' ) GR_get_geom_code = 4
      if( geom_name .eq. 'sphert' )   GR_get_geom_code = 5

      if( GR_get_geom_code .eq. -1)
     & print *,
     & 'Warning in GET_GEOM_CODE: name does not match known geometries'

      return
      end

*....................................................................*
*....................................................................*
*/*F
*  subroutine GET_GEOM_NAME
*
*  Given the numerical code of a geometry condition
*  return the associated name.
*
*  character*8  geom_name
*  real code
*
*F*/
      subroutine GR_get_geom_name(geom_name,code)
      character*8 geom_name

      if( code .eq. 0 ) geom_name = 'cart' 
      if( code .eq. 1 ) geom_name = 'cylr' 
      if( code .eq. 2 ) geom_name = 'cylphi' 
      if( code .eq. 3 ) geom_name = 'spherr'
      if( code .eq. 4 ) geom_name = 'spherphi' 
      if( code .eq. 5 ) geom_name = 'sphert'

      return
      end
*....................................................................*

      subroutine baderr()
      return
      end


      subroutine geom(s,e,sgp,egp,
     $     zn,znl,znr,vdv,area,areal,arear,dvol,
     $     igeom)
***********************************************************************
*  Define arrays needed to calculate geometric source terms
*     cart    => planar	     geometry		  *
*     cylr    => cylindrical geometry (radial)	  *
*     spherr  => spherical   geometry (radial)	  *
*     cyla    => cylindrical geometry (angular)	  *
*     sphera  => spherical   geometry (angular)	  *

********   G L O B A L  V A R I A B L E S   ********

*********  A R G U M E N T S ***************************************
      include 'meshf.h'

      integer s,e,sgp,egp

      character*8 igeom
      dimension znl(s-sgp:e+egp),znr(s-sgp:e+egp),zn(s-sgp:e+egp),
     $     vdv(s-sgp:e+egp),area(s-sgp:e+egp),areal(s-sgp:e+egp),
     $     arear(s-sgp:e+egp),dvol(s-sgp:e+egp)


********   L O C A L  V A R I A B L E S   ********
      integer i, j,beg,fin
***********************************************************************


      beg = s - sgp
      fin = e + egp
*  ..... Planar geometry
      if( igeom.eq.'cart' )	then

         Do  i = beg, fin
	    areal(i)	= 1.
	    arear(i)	= 1.
	    area (i)	= 1.
	    dvol (i)	= vdv(i)
         End do

*  ..... Cylindrical geometry (radial)
      else if( igeom.eq.'cylr' )then

         Do i = beg, fin
            areal(i)	= abs ( znl(i) )
            arear(i)	= abs ( znr(i) )
            area (i)	= 0.5 * ( arear(i) + areal(i) )
            dvol (i)	= area(i) * vdv(i)
         End do

*  ..... Spherical geometry (radial)
      else if( igeom.eq.'spherr' )	then

         Do  i = beg, fin
	    areal(i) = znl(i) * znl(i)
	    arear(i) = znr(i) * znr(i)
	    dvol (i) = (znr(i) * arear(i) - znl(i) * areal(i))/3.0
	    area (i) = dvol(i) / vdv(i)
         End do

*  ..... Cylindrical geometry (angular)
      else if( igeom.eq.'cyla' )then

         Do  i = beg, fin
	    areal(i)	= 1.
	    arear(i)	= 1.
	    area (i)	= 1.
	    dvol (i)	= area(i) * vdv(i) * zn(j)
         End do

*  ..... Spherical geometry (angular)
      else if( igeom .eq. "sphera" ) then

         Do  i = beg, fin
            areal(i)	= sin ( znl(i) )
            arear(i)	= sin ( znr(i) )
            area (i)	= sin ( 0.5 * ( znl(i) + znr(i) ) )
            dvol (i)	= area(i) * vdv(i) * zn(j)
         End do
         
      end if
      
      return
      end

****************************************************************
