* INCLUDE HEADER HERE

*****************************************************************
*
*  SUBROUTINE WORKER
*
*  The main subroutine for the 3D code 
*
*****************************************************************
      subroutine worker()

      include 'meshf.h'

      integer ndim,lev

      parameter( ndim = 3 )

      include 'extern.h'

*..............................................................

      integer siz(sz_0:sz_1,ndim,max_lev)
      integer mg_lin(mg_0:mg_1,ndim,max_lev)
      integer mg_nonlin(mg_0:mg_1,ndim,max_lev)
      integer proc(p_0:p_1)
      integer pgm(max_lev), dim(ndim)
      integer ldim(ndim), gdim(ndim)

      integer myid, nproc, ierr
      integer nlev, nmin
      integer i,stencil
      
      double precision texec, tcol, tcomm, tcpu 

*.... Some rudimentray timing here .....
c     texec = SYGetElapsedTime()
c     tcpu  = SYGetCPUTime()
      texec = MPI_WTIME()
      tcpu  = MPI_WTIME()

*.... Start setting the proc structure .......
      call  AL_set_id(proc)
      call  AL_set_nproc(proc)

      myid  = proc(p_id)
      nproc = proc(p_np)

c     print *,'program beginning (myid,nproc)',myid,nproc

*........ Read the problem dimenstions ...........................
*........ from the input data file ...............................
      if( myid .eq. 0 ) then
        open(10,file='size.in')
        read(10,*) dim(1), dim(2), dim(3)
        close(10)
c       call PIbcast(dim, 12, 1, 0, MSG_INT)
        call MPI_BCAST(dim,3,MPI_INTEGER,0,MPI_COMM_WORLD,ierr)
      else
c       call PIbcast(dim, 12, 0, 0, MSG_INT)        
        call MPI_BCAST(dim,3,MPI_INTEGER,0,MPI_COMM_WORLD,ierr)
      endif
c     print *,'dimensions read in =',dim(1), dim(2), dim(3)
*.................................................................

*.... Set global array dimensions at level 1 .......

      call AL_set_global_dim(dim,siz,ndim)

*..........................................................
*.... Choose or find the decomposition 
*
* If last entry is:
*     0 = define my own decomposition
*     1 = use the PETSc routine
*     2 = force a decomposition (must uncomment the lines below) 
*
c      proc(p_npx) = 8
c      proc(p_npy) = 8
c      proc(p_npz) = 8

      call AL_decomp_array(siz,ndim,proc,fluid_stencil,0)

*..........................................................

C....NOTE: this now can be done with *BCArrayProcsets
C      call define_procsets(pset1,myid,nproc,nprocx,nprocy,nprocz)

*...........................................................
*.... Print some stuff .......

      call AL_get_local_dim(ldim,siz(sz_0,1,1),ndim)

      npx = ldim(1)
      npy = ldim(2)
      npz = ldim(3)

      if( myid .eq. 0 ) then
	print *,' '
	print *,'----------------------------------------------'
	print *,' '
	print 109,nproc
	print *,' '
	print 110,dim(1), dim(2), dim(3)
	print *,' '
	print 111,npx,npy,npz,proc(p_npx),proc(p_npy),proc(p_npz)
	print *,' '
	print *,'----------------------------------------------'
      endif

109   format(' Total number of nodes: ',3i4)
110   format(' Global size is   ',3i5,'  points')
111   format(' Decomposition is ',3i5,'  points',/,/,
     &       '                  ',3i5,'  nodes')

*...........................................................

*.... Find the levels for the multigrid and set the ........
*.... appropriate entries in the siz structure .............
*.... This now includes setting the decomposition ..........

      nlev = mg_find_levels(siz,mg_lin,ndim,proc)
      nlev = mg_find_levels(siz,mg_nonlin,ndim,proc)

      call mg_set_type(mg_lin,ndim,MG_LINEAR)
      call mg_set_type(mg_nonlin,ndim,MG_NONLINEAR)
      call mg_find_buffers(siz,mg_lin,ndim,proc,igbuf,ilbuf)
      call mg_find_buffers(siz,mg_nonlin,ndim,proc,igbuf,ilbuf)

      Do i = 1, nlev+1
	 call AL_get_pgm(pgm(i),siz(sz_0,1,i),ndim,proc,NBYTES)
      end do

*.................................... 
*.... Run the main program ..........
c     print *,'running main driver',myid
      call c_driver(siz,mg_lin,mg_nonlin,ndim,proc,pgm)
*.................................... 

*.... Deallocate the programs .......
      Do i = 1, nlev
        call AL_free_pgm(pgm(i))
      End Do

*.... Do some primitive timing .....
c     texec = SYGetElapsedTime() - texec
c     tcpu  = SYGetCPUTime()     - tcpu
      texec = MPI_WTIME() - texec
      tcpu  = MPI_WTIME()     - tcpu

      if( myid .eq. 0 ) then
	  print *,' '
	  print *,'----------------------------------------------'
          print *,'Total elapsed time ',texec
c         print *,'Total CPU     time ',tcpu
	  print *,'----------------------------------------------'
	  print *,' '
      endif

      return
      end

