
* INSERT HEADER HERE

*/*F
**************************************************
*                                                *
*  subroutine SETUP                              *
*                                                *
*  Setup the simulation parameters and initial   *
*  configuration                                 *
*                                                *
**************************************************
*F*/
       subroutine setup(sz,ndim,proc,pgm,
     &                   ux, uy, uz, rho, press, temp, scalar,
     &                   x, y, z,
     &                   gravx, gravy, gravz, phi, wrk,
     &                   fluid_par, grid_par, out_par, step_par,
     &                   do_par, filenames )

      include 'meshf.h'
      include 'param.h'

      integer sz(sz_0:sz_1,ndim,1)
      integer proc(p_0:p_1), pgm(*)

      dimension ux(*), uy(*), uz(*), rho(*), press(*)
      dimension temp(*), wrk(*)
      dimension x(*), y(*), z(*)
      dimension gravx(*), gravy(*), gravz(*), phi(*)

      character*7 filenames(2)

*....................................................*
*.... Local Variables ...............................*
      integer gdim(3)

      character*8 xbcl, xbcr, ybcl, ybcr, zbcl, zbcr
      character*8 xgeom, ygeom, zgeom
      character*20 title
      character*24 today
      character*4 base
      character*3 case_no
      logical do_heat, do_fluid, do_grav, do_src, do_scalar
      logical printinfo, check_conv
*....................................................*

      myid = proc(p_id)

*.... Get the various array sizes ......*
      call AL_get_global_dim(gdim,sz,3)
      nx = gdim(1)
      ny = gdim(2)
      nz = gdim(3)
      call AL_get_array_bounds(bx, ex, bxgp, exgp, 'x', sz)
      call AL_get_array_bounds(by, ey, bygp, eygp, 'y', sz)
      call AL_get_array_bounds(bz, ez, bzgp, ezgp, 'z', sz)

*..... Set up some control parameters ...........*

**********************************************
*
*     I/O parameters.
*
*     Eventually, these can be read in from a file
*
**********************************************

c.... Case number for this calculation ...............
      ncase   = 000

c.... Base name for this calculation: 4 characters ...
      title     = "KH INSTABILITY OF A JET"
      base      = "jeta"

c.... How many time steps ............................
      nend	= 10

c.... How often should we check for the time step ....
      ntcheck = 2

c.....Number of dumps on the restart file...
      nrestart = 2

c.....Number of dumps on the float file(s).
      nout10  = 2

c.....Number of dumps on the vol renderer file(s).
      nout11  = 2 

c.... This is used for the averages ..........
      nout12  = nend+1

c.... This is used for the movies ............
      nout13 = nend+1
      nout14  = nend+1

c****** Courant number ***********************
      crntnm  = 0.8

c****** Artificial and Physical Viscosity ****
c      artvisc  = 0.1d0
      artvisc  = 0.0d0
      visc     = 0.d0

**********************************************
*
*    CHOOSE THE SOLVER 
*    (fluid+heat, fluid only, heat only, self gravity)
*
**********************************************

      do_fluid = .true.
      do_heat  = .false.
      do_grav  = .false.
      do_src   = .false.
      do_scalar= .true.

*... print various information ....*
      printinfo  = .true.

*... check for convergence in poisson's equation ...*
      check_conv = .true.


*********************************************
*
*    SET TOLERANCES FOR THE SOLVERS
*
*  (WHEREVER AN ITERATIVE SOLVER IS USED)
*

*.... The Linear Multigrid used in self-gravity
       tol_mg_li  = 1.e-3

*.... The Nonlinear Multigrid used in heat
       tol_mg_nli = 1.e-3

**********************************************
*
*    SET UP BOUNDARY CONDITIONS
*
* Possible b.c.'s are:
*
*       'flowin'     Flow-in
*       'flowout'    Flow-out
*       'noflow'     Impenetrable boundary
*       'reflect'    Reflecting
*       'fixed'      Fixed, i.e. with a pre-assigned value
*       'period'     Periodic
*
**********************************************

      xbcl     = "period"
      xbcr     = "period"

      ybcl     = "flowout"
      ybcr     = "flowout"
      zbcl     = "flowout"
      zbcr     = "flowout"

c      ybcl     = "period"
c      ybcr     = "period"
c      zbcl     = "period"
c      zbcr     = "period"

**********************************************
*
*    SET UP GEOMETRY CONDITIONS
*
* Possible geometries are:
*
*       'cart'     
*       'cylr'       Cylindrical (radial) 
*       'cyla'       Cylindrical (angular)
*       'spherr'     Spherical   (radial)
*       'sphera'     Spherical   (angular)
*
**********************************************

      xgeom  = "cart"
      ygeom  = "cart"
      zgeom  = "cart"

*********definition of the physical mesh*************

      y0 =  0.d0
      y1 =  1.d0 

      x0 = 0.d0
      x1 = 1.d0*y1 / float(ny) * float(nx)

      z0 = 0.d0
      z1 = 1.d0*y1 / float(ny) * float(nz)


c.......Stretching factor.....................
      xscale   = 1.0
      yscale   = 1.0
      zscale   = 1.0


************************************************************
************ DO NOT MODIFY BELOW THIS LINE *****************
*.... Modufy boundary conditions if we have a boundary
*.... between processors
      if( bx .ne. 1 ) xbcl = "comm"
      if( ex .ne.nx ) xbcr = "comm"
      if( by .ne. 1 ) ybcl = "comm"
      if( ey .ne.ny ) ybcr = "comm"
      if( bz .ne. 1 ) zbcl = "comm"
      if( ez .ne.nz ) zbcr = "comm"

      call grid(bx, ex, bxgp, exgp, nx,
     &          x0, x1, xscale,
     &          xgeom, xbcl, xbcr,
     &          x , 'x' )
      call grid(by, ey, bygp, eygp, ny,
     &          y0, y1, yscale,
     &          ygeom, ybcl, ybcr,
     &          y, 'y')

      call grid(bz, ez, bzgp, ezgp, nz,
     &          z0, z1, zscale,
     &          zgeom, zbcl, zbcr,
     &          z, 'z' )

*.....................................................*
      step_par( 1) = 0
      step_par( 2) = 0.d0
      step_par( 3) = 1
      step_par( 4) = nend
      step_par( 5) = ntcheck
      step_par( 6) = tmax
      step_par( 7) = crntnm

      step_par(20) = tol_mg_li
      step_par(21) = tol_mg_nli

      fluid_par(20) = artvisc
      fluid_par(21) = visc


      do_par( 1) = do_fluid
      do_par( 2) = do_grav
      do_par( 3) = do_heat
      do_par( 4) = printinfo .and. (myid.eq.0)
      do_par( 5) = do_src
      do_par( 6) = check_conv
      do_par( 7) = do_scalar

      grid_par( 1) = x0
      grid_par( 2) = x1
      grid_par( 3) = xscale
      grid_par( 4) = GR_get_geom_code(xgeom)
      grid_par( 5) = GR_get_bc_code(xbcl)
      grid_par( 6) = GR_get_bc_code(xbcr)
      
      grid_par( 7) = y0
      grid_par( 8) = y1
      grid_par( 9) = yscale
      grid_par(10) = GR_get_geom_code(ygeom)
      grid_par(11) = GR_get_bc_code(ybcl)
      grid_par(12) = GR_get_bc_code(ybcr)

      grid_par(13) = z0
      grid_par(14) = z1
      grid_par(15) = zscale
      grid_par(16) = GR_get_geom_code(zgeom)
      grid_par(17) = GR_get_bc_code(zbcl)
      grid_par(18) = GR_get_bc_code(zbcr)

      out_par( 1) = 0
      out_par( 2) = 0.d0

      out_par( 4) = nrestart
      out_par( 5) = nout10
      out_par( 6) = nout11
      out_par( 7) = nout12
      out_par( 8) = nout13
      out_par( 9) = nout14
      out_par(10) = nout15

**********************************************
*     Do not modify below this line          *
**********************************************
c.......0: start from a new configuration.....
c.......1: restart from the restart file......
      if( ncase .eq. 0 ) irst = 0
      if( ncase .ne. 0 ) irst = 1
      out_par( 3) = irst

c.......Form the base filename................
c     print *,'in setup, write 0.. ',myid,ncase
      write(case_no,1111) ncase
1111  format(i3)
      if( ncase .lt. 10 ) case_no(1:2) = "00"
      if( ncase .lt. 100) case_no(1:1) = "0"
      filenames(1) = base(1:4) // case_no(1:3)
      if( irst .ne. 0 ) then
	  nc1 = ncase -1 
	  write(case_no,1111) nc1
          if( nc1 .lt. 10 ) case_no(1:2) = "00"
          if( nc1 .lt. 100) case_no(1:1) = "0"
          filenames(2) = base(1:4) // case_no(1:3)
      endif
c.............................................
c.... Print some useful information here .....
      if( myid .eq. 0 ) then
c      call fdate(today)
      today = "NOT AVAILABLE"
      open(20,file=filenames(1) // '.out',form='formatted')
      write(20,1000) today,title,filenames(1),
     &  nx,ny,nz,nend,nout10,nout12,nout13
      endif

1000  format('#################################################',
     &  /,' ',/,'Date: ',a24,/,
     &  /,a20,'    Case:    ',a7,/,' ',
     &  /,'Grid size: ',i5,i5,i5,/,' ',/,'Total steps: ',i6,/,' ',
     &  /,'Dumps on unit 10 (floating arrays)    ',i4,
     &  /,'Dumps on unit 12 (horizontal averages)',i4,
     &  /,'Dumps on unit 13 (movie)              ',i4,/,/,
     &  '#################################################')

c      close(20)

*..... Finally, set up the initial condition .........
c     print *,'in setup, calling INIT cond.. ',myid

          call init_cond(sz,nx,ny,nz,
     &       bx,ex,bxgp,exgp, by,ey,bygp,eygp, bz,ez,bzgp,ezgp,
     &               ux,uy,uz,press,temp,rho,scalar,wrk,x,y,z,
     &               gravx,gravy,gravz,phi,
     &               fluid_par, step_par, out_par, grid_par,
     &               do_par, filenames )

c     print *,'in setup, calling OUTPUT.. ',myid
         call output(sz,proc,pgm,filenames,
     &              ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &              gravx, gravy, gravz, phi, r, wrk,  
     &              step_par, grid_par, fluid_par, out_par, do_par )

c.............................................
c     print *,'in setup, DONE WITH OUTPUT STUFF.. ',myid
      return
      end
*----------------------------------------------------*
