
*  See setup.f for the definition of the parameters * 
      parameter( max_par = 32 )
      dimension fluid_par(max_par), step_par(max_par)
      dimension out_par(max_par), grid_par(max_par)
      logical do_par(max_par)


**************************************************
* 
*    PARAMETERS DEFINITIONS
*
**************************************************
*
*  step_par( 1) = nstep   ; current time step
*  step_par( 2) = time    ; current time
*  step_par( 3) = nbegin  ; beginning number of time steps (usually = 1)
*  step_par( 4) = nend    ; final number of time steps
*  step_par( 5) = ntcheck ; frequency of time step controls
*  step_par( 6) = tmax    ; maximum time advance
*  step_par( 7) = CFL     ; safety factor for time step controls
*  step_par( 8) =         ; further safety factors for time step controls
*  step_par( 9) =         ; further safety factors for time step controls
*  step_par(10) = dt      ; current time step
*
*  step_par(20) = mg_li_tol    ; The tolerance for the convergence
*  step_par(21) = mg_li_tol    ; The tolerance for the convergence
*                              ; of the linear multigrid.
*
**************************************************
*
*  out_par( 1) = nstep      ; current time step
*  out_par( 2) = time       ; current time
*  out_par( 3) = restart    ; 0 = start new; 1 = read restart file
*  out_par( 4) = nrestart   ; frequency of restart dumps
*  out_par( 5) = nout10     ; frequency of dumps on unit 10
*  out_par( 6) = nout11     ; frequency of dumps on unit 11
*  out_par( 7) = nout12     ; frequency of dumps on unit 12
*  out_par( 8) = nout13     ; frequency of dumps on unit 13
*  out_par( 9) = nout14     ; frequency of dumps on unit 14
*  out_par(10) = nout15     ; frequency of dumps on unit 15
*
**************************************************
*
*  grid_par( 1) = x0       ; range of X coordinate
*  grid_par( 2) = x1       ; x => [x0,x1]
*  grid_par( 3) = xscale   ; 0 = uniform mesh; 1 = user defined mesh
*  grid_par( 4) = xgeom    ; geometry descriptor: See codes below.
*  grid_par( 5) = xbc_x0   ; boundary condition at x0: See codes below.
*  grid_par( 6) = xbc_x1   ; boundary condition at x1: See codes below.
*
*  grid_par( 7) = y0       ; range of Y coordinate
*  grid_par( 8) = y1       ; y => [y0,y1]
*  grid_par( 9) = yscale   ; 0 = uniform mesh; 1 = user defined mesh
*  grid_par(10) = ygeom    ; geometry descriptor: See codes below.
*  grid_par(11) = ybc_y0   ; boundary condition at y0: See codes below.
*  grid_par(12) = ybc_y1   ; boundary condition at y1: See codes below.
*
*  grid_par(13) = z0       ; range of Z coordinate
*  grid_par(14) = z1       ; z => [z0,z1]
*  grid_par(15) = zscale   ; 0 = uniform mesh; 1 = user defined mesh
*  grid_par(16) = zgeom    ; geometry descriptor: See codes below.
*  grid_par(17) = zbc_z0   ; boundary condition at z0: See codes below.
*  grid_par(18) = zbc_z1   ; boundary condition at z1: See codes below.
*
**********************
*..... BC's codes:
*
*  0    'flowin' 
*  1    'flowout'
*  2    'noflow'
*  3    'reflect'
*  4    'fixed' 
*  5    'period'
*  6    'comm' 
*
**********************
*..... Geometry codes:
*
*  0    'cart'
*  1    'cylr'
*  2    'cylphi'
*  3    'spherr'
*  4    'spherphi'
*  5    'sphert'
*
**********************
*
**************************************************
*  These parameters take the logical values:
*
*            .true.  .false.
*
*  do_par( 1) = T,F    ; Do the fluid dynamic physics
*  do_par( 2) = T,F    ; Do self gravity
*  do_par( 3) = T,F    ; Do thermal conduction
*  do_par( 4) = T,F    ; Print debuggin info
*  do_par( 5) = F  Neglect source terms;  T Compute source terms
*
*  do_par( 6) = T,F    ; Check convergence in poisson's equation
*
*  do_par( 7) = T,F    ; Do passive scalar
*
**************************************************
*
*  fluid_par( 1) = rho_floor   ; safety minimum density
*  fluid_par( 2) = press_floor ; safety minimum pressure
*  fluid_par( 3) = temp_floor  ; safety minimum temperature
*  fluid_par( 4) = gamma       ; polytropic gas constant
*  fluid_par( 5) = ck0         ; thermal conductivity (top)
*  fluid_par( 6) = ck1         ; thermal conductivity (bottom)
*  fluid_par( 7) = tsigma
*  fluid_par( 8) = ttrans
*  fluid_par( 9) =
*  fluid_par(10) =
*  fluid_par(11) =
*  fluid_par(12) =
*  fluid_par(13) =
*  fluid_par(14) =
*  fluid_par(15) =
*  fluid_par(16) =
*
*  fluid_par(20) = nu      ; Artificail viscosity
*  fluid_par(21) = vis     ; Real viscosity (NOT IMPLEMENTED YET)
*
**************************************************
***************************************************

