
* INSERT HEADER HERE

**************************************************
*                                                *
*  subroutine OUTPUT                             *
*                                                *
*  Setup the simulation parameters and initial   *
*  configuration                                 *
*                                                *
**************************************************
      subroutine output(sz,proc,pgm,filenames,
     &              ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &              gravx, gravy, gravz, phi, r, wrk,  
     &              step_par, grid_par, fluid_par, out_par, do_par )


      include 'meshf.h'
      include 'param.h'
      
      integer sz(sz_0:sz_1,3),proc(p_0:p_1),pgm(*)
      dimension ux(*),uy(*),uz(*),press(*),temp(*),scalar(*)
      dimension rho(*),wrk(*)
      dimension phi(*), gravx(*), gravy(*), gravz(*)
      dimension x(*),y(*),z(*), r(*)
      character*7 filenames(2)

*......................................................*
*.... Local Variables .........*
      data  mdu10, mdu11, mdu12, mdu13  /0,0,0,0/
      save  mdu10, mdu11, mdu12, mdu13
      data  mdu14, mdu15, mdu16, mdu17  /0,0,0,0/
      save  mdu14, mdu15, mdu16, mdu17

      character*13 f10, f11, f12, f13, f14, f15, f16, f17
      character*80 aux_filename
*.......................................................*

 
      nstep      = out_par(1)
      is_restart = out_par(3)
      nout10 = int(out_par(5))
      nout11 = int(out_par(6))

      time       = step_par(2)

*.......................................................*
*.... Special condition: IS_RESTART = 1  and NSTEP = 0 .......*
      if( is_restart .eq. 1 .and. nstep .eq. 0 ) return

*.... Dumps on unit 10 ......................................
      nout10 = int(out_par(5))
      if(mod(nstep,nout10) .eq. 0) then

         aux_filename = filenames(1)
c         print *, "calling dump_float"
        call dump_float(sz,aux_filename,step_par,out_par,
     &                   ux,uy,uz,press,temp,rho,scalar,wrk)

         mdu10 = mdu10 + 1
*............................................................
      endif

*.... Dumps on unit 11 ......................................
      nout11 = int(out_par(6))
      if(mod(nstep,nout11) .eq. 0) then

         aux_filename = filenames(1)

c         print *, "calling vol_render"
       call vol_render(sz,proc,pgm,filenames,
     &              ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &              gravx, gravy, gravz, phi, r, wrk,  
     &              step_par, grid_par, fluid_par, do_par )

         mdu11 = mdu11 + 1
*............................................................
      endif

*.... Dumps on restart file .................................
      nrestart = int(out_par(4))
      nstep    = int(out_par(1))
      if(mod(nstep,nrestart) .eq. 0 .and. nstep .gt. 1) then

         aux_filename = filenames(1) // ".rest"

c         print *, "calling restart_io"
        call restart_io(sz,aux_filename,step_par,out_par,
     &                   ux,uy,uz,press,temp,rho,scalar,wrk,
     &                   "w")

       if( proc(p_id) .eq. 0 .and. do_par(4) )
     &     print*,'Dumping restart file at time =',time
    
      endif
*............................................................      
      return
      end

*/*F
**************************************************************
*
*   SUBROUTINE RESTART
*
*   Read or Write the restart file
*
*F*/
      subroutine restart(sz,proc,filenames,
     &                ux,uy,uz,press,temp,rho,scalar,wrk,
     &                step_par,out_par, do_par)
      include 'meshf.h'
      include 'param.h'
      
      parameter(ndim = 3)
      integer sz(sz_0:sz_1,3), proc(p_0:p_1)
      dimension ux(*),uy(*),uz(*),press(*),temp(*),rho(*)
      dimension scalar(*),wrk(*)
      character*7 filenames(2)

*......................................................*
*.... Local Variables .........*
      character*13 f10, f11, f12, f13, f14, f15, f16, f17
      character*80 aux_filename
*.......................................................*

*.... Read the restart file .................................
      nrestart = int(out_par(4))
      nstep    = int(out_par(1))
      
      aux_filename = filenames(2) // ".rest"

         call restart_io(sz,aux_filename,step_par,out_par,
     &                   ux,uy,uz,press,temp,rho,scalar,wrk,
     &                   "r")

*............................................................ 
      if( proc(p_id) .eq. 0 .and. do_par(4) )
     &     print*,'Restarting from file ',filenames(1) // ".rest",
     &            '    Time = ', step_par(2)

    
      return
      end
******************************************************************
