*---------------------------------------------------------------
*     include MPI header
      include 'mpif.h'

*---------------------------------------------------------------
*    Stencil definitions

      implicit real*8 (a-h,o-z)

      integer word
      data word /8/

      integer MESH_PRECISION
      parameter (MESH_PRECISION=MPI_DOUBLE_PRECISION)

      parameter(NBYTES = 8)

      integer mgrid_stencil, fluid_stencil
      parameter (mgrid_stencil = 11)
      parameter (fluid_stencil = 4 )

      integer max_lev
      parameter(max_lev = 10)



*... These are the local dimensions of the array .........
*...
*... bx, by, bz          Beginning point of the physical array
*... bxgp, bygp, bzgp    Ghost points at the beginning of the array

*... ex, ey, ez          Ending point of the physical array
*... exgp, eygp, ezgp    Ghost points at the end of the array

*... dimension a(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)

      integer bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp

*... These are the global dimensions of the array ........
      integer nx, ny, nz


**********************************************************************
*
*    Include file for BlockComm for Fortran

*    Definitions for the sz array ...........
*
*     int sz(sz_0:sz_1,ndim)   where ndim = number of dimensions

       integer sz_mdim, sz_isparallel, sz_start, sz_end
       integer sz_loc, sz_ndim 
       integer sz_sg, sz_eg, sz_nsg, sz_neg
       integer sz_0, sz_1

       parameter( sz_0 = 0, sz_1 = 9 )
       parameter(sz_mdim = 0, sz_isparallel = 1, sz_start = 2) 
       parameter(sz_end = 3, sz_loc = 4, sz_ndim = 5, sz_sg = 6) 
       parameter(sz_eg = 7, sz_nsg = 8, sz_neg = 9)

*   0   sz_mdim         - size of array in this dimension 
*   1   sz_isparallel   - true if the array is parallelized in this
*                         dimension 
*   2   sz_start        - starting index for local piece  
*   3   sz_end          - ending index for local piece 
*
*   4   sz_loc          - location in this dimension of the processor
*   5   sz_ndim         - umber of processors in this dimension;
*                         -1 if unspecified
*   6   sz_sg           - start ghost limit
*   7   sz_eg           - end   ghost limit
*   8   sz_nsg          - neighbor start ghost limit
*   9   sz_neg          - neighbor end   ghost limit

       integer boxstencil
       parameter( boxstencil = 4 )

*..... Routines
       integer BCBuildArrayPGM
 
*...  End of include file for BlockComm for Fortran
*
**********************************************************************
*
*... MY OWN STRUCTURES .......
*
**********************************************************************
*
*   Processor decomposition information 
*
*    int p_3d(p_0,p_1)
*
      integer p_id, p_np, p_npx, p_npy, p_npz, p_0, p_1
      integer p_xloc,p_yloc,p_zloc

      parameter(p_0 = 0, p_1 = 7)
      parameter( p_id = 0, p_np = 1 ) 
      parameter( p_npx = 2, p_npy = 3, p_npz = 4 )
      parameter( p_xloc = 5, p_yloc = 6, p_zloc = 7 )
*
*   0   p_id   processor id
*   1   p_np   total number of processors
*
*   2   p_npx  number of processors along X
*   3   p_npy  number of processors along Y
*   4   p_npz  number of processors along Z
*
*   5   p_xloc  location  of processors along X
*   6   p_yloc  location of processors along Y
*   7   p_zloc  location of processors along Z
*
**********************************************************************
*
*  Information for the multigrid
*
*    int mg(mg_0,mg_1)

      integer mg_nlev, mg_mdim, mg_ldim, mg_gldim  
      integer mg_lbuf, mg_gbuf, mg_mlev, mg_dir
      integer MG_NONLINEAR, MG_LINEAR
      parameter( mg_0 = 0, mg_1 = 11 )
      parameter( mg_nlev = 0, mg_mdim = 1, mg_ldim = 2 ) 
      parameter( mg_lbuf = 3, mg_gbuf = 4 )
      parameter( mg_mlev = 5, mg_dir = 6 , mg_isparallel = 7 )
      parameter( mg_type = 8, mg_stencil = 9 , mg_iter = 10 )
      parameter( mg_plev = 11 )
      parameter( MG_NONLINEAR = 0, MG_LINEAR = 1 )

*
*   0   mg_nlev   Number of levels
*  11   mg_plev   Number of Parallel levels
*
*   1   mg_mdim   Size of the global array at this level in this dimension
*   2   mg_ldim   Size of the local array at this level in this dimension
*   3   mg_lbuf   Size of the local buffers
*   4   mg_gbuf   Size of the global buffers
*
*   5   mg_mlev   Which level this is
*   6   mg_dir    1 do a cycle; 0 do not do a cycle in this direction
*                    (Note: this is telling wether or not this direction 
*                     was injected from the above level or not. This
*                     is useful for very thin domains).
*   7   mg_isparallel  1 if this is parallel; 0 if this is sequential
*
*   8   mg_type   = 0 if the MG is nonlinear
*                 = 1 if the MG is linear
*
*   9   mg_stencil    Type of MG stencil. It is set to 11 for now....
*
*  10   mg_iter   = Number of iterations at this level.
*
**********************************************************************
*
*    Grid geometry definitions 

      integer gr_0, gr_1
      integer gr_x, gr_xl, gr_xr, gr_dx, gr_area
      integer gr_areal, gr_arear, gr_dvol 
      parameter(gr_0 = 0, gr_1 = 7 )
      parameter( gr_x = 0, gr_xl = 1, gr_xr = 2, gr_dx = 3 )
      parameter(  gr_area = 4, gr_areal = 5, gr_arear = 6, gr_dvol = 7 )

*  0   gr_x     Coordinate at the cell center
*  1   gr_xl    Coordinate at the cell left
*  2   gr_xr    Coordinate at the cell right
*
*  3   gr_dx    Delta x of the cell
*
*  4   gr_area  Area element at the cell center
*  5   gr_areal Area element at the cell left
*  6   gr_arear Area element at the cell right
*
*  7   gr_dvol  Delta volume of the cell
*
*    Example: real*4 x( 1:nx , gr_0:gr_1 )
*
**********************************************************************
*
*   Boundary condition codes

      integer  FLOWIN, FLOWOUT, NOFLOW, REFLECT
      integer  FIXED, PERIOD, COMM, SPECIAL

      parameter( FLOWIN = 0, FLOWOUT = 1, NOFLOW = 2, REFLECT = 3 )
      parameter( FIXED  = 4, PERIOD  = 5, COMM   = 6, SPECIAL = 7 )
*
**********************************************************************
**********************************************************************
*
*   Geometry codes
      integer CART, CYLR, CYLPHI, SPHERR, SPHERPHI, SPHERT
      parameter( CART = 0, CYLR = 1, CYLPHI = 2 )
      parameter( SPHERR = 3, SPHERPHI = 4, SPHERT = 5 )
*
**********************************************************************
