/* Additions by Andrea Malagoli, for the 3D code */

#ifndef __MESHC
#define __MESHC

#ifdef SINGLE
#define array float
#else
#define array double
#endif

#ifdef IRIX
#define FORTRANUNDERSCORE
extern int printf(const char *,...);
#endif

#ifdef cray
#define HAS_CAP
#endif

#include "mpio.h"
#ifndef FILEPATH
#define FILEPATH "/quicksand1/thakur/"
#endif 

/*..................................................................*/
/* The ARRAY LIBRARY, to complement the */
/* Array Descriptor, same as BCArrayPart */
typedef struct {
    int mdim,               /* size of array in this dimension */
        is_parallel,        /* true if the array is parallelized in this
			       dimension */
        start,              /* starting index for local piece */
        end,                /* ending index for local piece */
        loc;                /* location in this dimension of the processor */
    int ndim;               /* number of processors in this dimension; -1
			       if unspecified */
    int sg, eg;             /* start and end ghost limits */
    int nsg, neg;           /* neighbor start and end ghost limits */
    } ALArrayPart;
/*.................................................................*/


/* This assumes a 0 origin for the relative values of start,end */
typedef struct {
    int mdim,               /* size of global array in this dimension */
        ndim,               /* size of local array in this dimension */
        start,              /* starting index for local piece */
        end;                /* ending index for local piece */
    int gstart, gend;       /* GLOBAL indices for start and end */
    } PIArrayPart;

/*-----------------------------------------------------------------*/
/* Arrays not supported by BlockComm */

/* Processor decomposition information  */
typedef struct {
 	int   p_id,   /* processor id */
              p_np,   /* total number of processors */
              p_npx,  /* number of processors along X */
              p_npy,  /* number of processors along Y */
              p_npz,  /* number of processors along Z */
              p_xloc,  /* location of processors along X */
              p_yloc,  /* location of processors along Y */
              p_zloc;  /* location of processors along Z */
         } ALPdesc;

/*-----------------------------------------------------------------*/
/*....................................*/
/* Level descriptor for the multigrid */
typedef struct {
      	int mg_nlev,    /* Number of levels */
            mg_mdim;    /* Size of the local array at this 
                           level in this dimension */
        int mg_ldim;    /* Size of the global array at this
                           level in this dimension */
        int mg_lbuf,    /* Size of the local buffers */
            mg_gbuf,    /* Size of the global buffers */
            mg_mlev,    /* Which level this is */
            mg_dir;     /* 1 do a cycle; 0 do not do a cycle 
                           in this direction
                           (Note: this is telling wether or not
                           this direction was injected from the 
                           above level or not. This is useful for 
                           very thin domains). */
        int  mg_isparallel; /* 1 if this is parallel; 
                               0 if this is sequential */
	int  mg_type;       /* 0 is the MG is nonlinear 
			       1 if the MG is linear    */
	int  mg_stencil;    /* stencil of the MG -- NOT USED YET */
	int  mg_iter;      /* Number of iterations at this level */
	int  mg_plev;      /* Number of Parallel levels */
        } MGdesc;
/*-----------------------------------------------------------------*/
/* Grid geometry definitions */

typedef struct {
	array *gr_x;      /* Coordinate at the cell center */
        array *gr_xl;     /* Coordinate at the cell left */
        array *gr_xr;     /* Coordinate at the cell right */
        array *gr_dx;     /* Delta x of the cell */
        array *gr_area;   /* Area element at the cell center */
        array *gr_areal;  /* Area element at the cell left */
        array *gr_arear;  /* Area element at the cell right */
        array *gr_dvol;   /* Delta volume of the cell */
        } GRdesc;

#define GR_ELEMENTS  8 

/*-----------------------------------------------------------------*/
/*..................................................................*/
/* Functions decalarations */

void AL_set_id(), AL_get_pgm(), AL_free_pgm(), AL_set_global_dim();
void AL_get_global_dim();
void AL_get_array_bounds(),AL_get_local_dim(), AL_get_array_tsize();
void AL_get_array_isize();
void AL_decomp_array();
int MG_find_levels();
void MG_find_buffers();


#ifdef FORTRANUNDERSCORE
#define AL_set_id al_set_id_
#define AL_get_pgm al_get_pgm_
#define AL_free_pgm al_free_pgm_
#define AL_set_global_dim al_set_global_dim_
#define AL_get_global_dim al_get_global_dim_
#define AL_get_array_bounds al_get_array_bounds_
#define AL_get_local_dim al_get_local_dim_
#define AL_get_array_tsize al_get_array_tsize_
#define AL_get_array_isize al_get_array_isize_
#define AL_decomp_array al_decomp_array_

#define AL_get_maxmin al_get_maxmin_
#define AL_from_array_to_rast3d al_from_array_to_rast3d_

#define MG_find_levels mg_find_levels_ 
#define MG_find_buffers mg_find_buffers_
#elif !defined FORTRANUNDERSCORE && !defined HAS_DHASH
#define AL_set_id al_set_id
#define AL_get_pgm al_get_pgm
#define AL_free_pgm al_free_pgm
#define AL_set_global_dim al_set_global_dim
#define AL_get_global_dim al_get_global_dim
#define AL_get_array_bounds al_get_array_bounds
#define AL_get_local_dim al_get_local_dim
#define AL_get_array_tsize al_get_array_tsize
#define AL_get_array_isize al_get_array_isize
#define AL_decomp_array al_decomp_array

#define AL_get_maxmin al_get_maxmin
#define AL_from_array_to_rast3d al_from_array_to_rast3d

#define MG_find_levels mg_find_levels
#define MG_find_buffers mg_find_buffers
#endif

#ifdef FORTRANCAPS
#define AL_set_id AL_SET_ID
#define AL_get_pgm AL_GET_PGM
#define AL_free_pgm AL_FREE_PGM
#define AL_set_global_dim AL_SET_GLOBAL_DIM
#define AL_get_global_dim AL_GET_GLOBAL_DIM
#define AL_get_array_bounds AL_GET_ARRAY_BOUNDS
#define AL_get_local_dim AL_GET_LOCAL_DIM
#define AL_get_array_tsize AL_GET_ARRAY_TSIZE
#define AL_get_array_isize AL_GET_ARRAY_ISIZE
#define AL_decomp_array AL_DECOMP_ARRAY

#define AL_get_maxmin AL_GET_MAXMIN
#define AL_from_array_to_rast3d AL_FROM_ARRAY_TO_RAST3D

#define MG_find_levels MG_FIND_LEVELS
#define MG_find_buffers MG_FIND_BUFFERS
#endif

/*............................................................*/
#endif

