
* INSERT HEADER HERE

*/*F
**************************************************
*                                                *
*  subroutine INIT_COND                          *
*                                                *
*  Setup the initial condition                   *
*                                                *
**************************************************
*F*/
       subroutine init_cond(sz,nx,ny,nz,
     &     bx,ex,bxgp,exgp, by,ey,bygp,eygp, bz,ez,bzgp,ezgp,
     &                      ux,uy,uz,press,temp,rho,scalar,wrk,x,y,z,
     &                      gravx,gravy,gravz,phi,
     &                      fluid_par, step_par,out_par, grid_par,
     &                      do_par, filenames )

      include 'meshf.h'
      include '3d.h'
      include 'grid.h'
      include 'grav.h'
      include 'param.h'

      dimension wrk(1)
      integer sz(sz_0:sz_1,ndim), proc(p_0:p_1)
      character*7 filenames(2)
********L O C A L  V A R I A B L E S      ********
      parameter (npert = 20)
      dimension xc(npert),yc(npert),zc(npert),ampl(npert)
      double precision rand
      real*8 one
      data one /1.d0/
*................................................................*

      gamma    = 5.d0 / 3.d0

      pi  = 4.d0*atan(one)
      pi2 = 2.d0*pi
      pi8 = 8.d0*pi

      x0 = grid_par( 1)
      x1 = grid_par( 2)
      y0 = grid_par( 7)
      y1 = grid_par( 8)
      z0 = grid_par(13)
      z1 = grid_par(14)

************************************************************
      is_restart = out_par( 3) 
*>>>>>>>>>>>>>>>> Begin initialization of arrays >>>>>>>>>>>>>>>>*

*>>>>>>>>>>> If this is new, set the initial condition >>>>>>>*
      if( is_restart .eq. 0 ) then

*... Do not change these ....*
      nbeg  = 1
      nstep = 0

*..... Parameters for a temperature perturbation ..........

      sig = (2.0d0)**2
      ampl0= 0.1d0

      xmin = 0.1d0*x1
      xmax = 1.d0*x1

      ymin = 0.2d0*y1
      ymax = 0.9d0*y1

      zmin = 0.2d0*z1
      zmax = 0.9d0*z1

      Do np = 1, npert
         yc  (np) = (ymax-ymin)*rand() + ymin
         xc  (np) = (xmax-xmin)*rand() + xmin
         zc  (np) = (zmax-zmin)*rand() + zmin
         ampl(np) = ampl0*2.*(0.5-rand())
      End Do
*.............................................................*

      amach  = 5.0
      rho_in = 1.d0
      P_in   = 1.d0
      T_in   = P_in/rho_in
      V_in   = amach*sqrt(gamma*T_in)
		V_out  = 0.

*.... Radius and Width of the jet .....*		
		radius = (x1-x0)*0.2
		width  = radius/10.
		
*.... Ratio rho_out/rho_in between inner and outer density ..... *
*.... rho_out = rho_ratio * rho_in
      rho_ratio = 1.
      rho_out = rho_ratio*rho_in
		
      time  = 0.0
      nstep = 0.0

      fmult = 1.d0 / ( gamma - 1.d0 )

      xcent = (x1-x0)/2.d0
      ycent = (y1-y0)/2.d0
      zcent = (z1-z0)/2.d0

      Do iz = bz, ez 
      Do iy = by, ey
      Do ix = bx, ex

         xzn = x(ix,gr_x)
         yzn = y(iy,gr_x)
         zzn = z(iz,gr_x)

         xnorm = xzn/x1
         ynorm = yzn/y1
         znorm = zzn/z1

         rpert = ampl0/5.*(0.5-rand())

*.... add random noise .....*
         rad = sqrt((yzn-ycent)**2+(zzn-zcent)**2)
			
         profile = 0.5*(tanh(-(rad-radius)/width)+1)

         rho(ix,iy,iz) = rho_out + (rho_in-rho_out)*profile

         scalar(ix,iy,iz) = 1.*profile

         press(ix,iy,iz) = P_in

         temp(ix,iy,iz)  = press(ix,iy,iz)/rho(ix,iy,iz)

         ux(ix,iy,iz) = V_out + (V_in - V_out)*profile
c     &   *(1.+0.1*sin(xzn*pi2*2.))

         uy(ix,iy,iz) = 0.
     &   +v_in*(0.1*sin(xzn*pi2*2.))*profile

         uz(ix,iy,iz) = 0.
     &   +v_in*(0.1*cos(xzn*pi2*2.))*profile

      End Do
      End Do
      End Do

*.... We do this is if we use the gravitational potential ....*
      if( do_par(2) ) then
         Do iz = bz, ez 
         Do iy = by, ey
         Do ix = bx, ex
*...... Gravitational potential
            phi(ix,iy,iz) = 0.d0
        End Do
        End Do
        End Do
	   endif

*>>>>>>>>>>> Else read the restart file >>>>>>>*
      else
         call restart(sz,proc,filenames,
     &                ux,uy,uz,press,temp,rho,scalar,wrk,
     &                step_par,out_par, do_par)

*.... Restore time, and step numbers ....*
*.... (Do no change these values) .......*
         time  = step_par( 2)
         nstep = step_par(1)
         nbeg  = nstep + 1

      endif

*>>>>>>>>>>>>>>>> End initialization of arrays >>>>>>>>>>>>>>>>*
*.... If do not use self gravitiy, we have to define these ....*
      Do ix = bx-bxgp, ex+exgp
	  gravx(ix,1) =  0.d0
          gravx(ix,2) = -0.d0*x(ix,gr_x)
      End Do
      Do iy = by-bygp, ey+eygp
          gravy(iy,1) =  0.d0
          gravy(iy,2) = -0.d0*y(iy,gr_x)
      End Do
      Do iz = bz-bzgp, ez+ezgp
          gravz(iz,1) =  0.d0
          gravz(iz,2) = -0.d0*z(iz,gr_x)
      End Do
*..............................................................*

*..... Set the floor values for P and rho and T ....*
c      call floors(bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp,
c     &            rho, press, temp,
c     &            rhofloor, pfloor, tempfloor)

      rhofloor  = 1.e-10
      pfloor    = 1.e-10
      tempfloor = 1.e-10

*.... Set the parameters ........*
      fluid_par( 1) = rhofloor
      fluid_par( 2) = pfloor 
      fluid_par( 3) = tempfloor
      fluid_par( 4) = gamma
      fluid_par( 5) = g
      fluid_par( 6) = 0.d0

      step_par( 1) = nstep
      step_par( 2) = time
      step_par( 3) = nbeg
      step_par( 4) = step_par(4) + nstep

      return
      end

*********************************************************************
*
*    SUBROUTINE GET_PRESS_FROM_TEMP
*
*    Recompute the pressure after the restart file is called
*    This in case we do not dump the pressure.
*
       subroutine get_press_from_temp(sz,proc,
     &       bx,ex,bxgp,exgp, by,ey,bygp,eygp, bz,ez,bzgp,ezgp,
     &               press,rho,temp,
     &               fluid_par, step_par, grid_par)
   
      include 'meshf.h'
      include 'param.h'
      parameter( ndim = 3 )
      integer sz(sz_0:sz_1,ndim), proc(p_0:p_1)
      dimension rho  (bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension press(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
      dimension temp (bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)

      Do iz = bz, ez 
      Do iy = by, ey
      Do ix = bx, ex
          press(ix,iy,iz) = temp(ix,iy,iz)*rho(ix,iy,iz)
      End Do
      End Do
      End Do

      return
      end

*********************************************************************
