***********************************************************************
      subroutine grid(s,e,sgp,egp,ng,
     $     offset0,offset1,scale,
     $     igeom,bcl,bcr,z,dir)
***********************************************************************
*  Define the physical grid parameters for the given coordinate
*  system.  Including the boundary conditions
*
****************************************************************
*     COMPUTE GRID COORDINATES				       *
*							       *
*    The coordinates are defined at the Left side, at the      *
*    Center and at the Right side of the grid cell.	       *
*	       |------------|				       *
*	       L      C	    R				       *
*    Given the coordinates at the Left side, the other	       *
*    coordinates are then defined autoamtically by the	       *
*    code.						       *
*							       *
*    The grid spacing can be chosen to be nonuniform.	       *
*    However, the relative change in the size of adjacent      *
*    grid-cells should not exceed 2% or 3%:		       *
*		  d(i+1) ~ d(i) * 1.03		               *
*							       *
*     znl == left side	 of the	 grid cell                     *
*							       *
*     znr == right side of the	 grid cell                     *
*							       *
*     zn  == center of the grid cell                           *
*							       *
****************************************************************

*******     A R G U M E N T S **************************************
      include 'meshf.h'

      integer s,e,sgp,egp,ng,nmax
c      real offset1,offset0,scale

      dimension z(s-sgp:e+egp, gr_0:gr_1)
      character*8 bcl,bcr,igeom
      character*1 dim
*******	    L O C A L  V A R I A B L E S *******
      integer i, j, beg, fin
      real*8    ssum,del
      logical edgel, edger
      integer PImytid
***********************************************************************

      nx = ng
*  ..... Determine the total scaling factor
      scale = 1.
      if( scale.eq.1. )then
         ssum	= nx
      else
         ssum	= ( 1. - scale**(nmax) ) / ( 1. - scale )
      end if

*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
*\\
*\\		Set up the grid
*\\
*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
*  Set up the entire grid except for the left and right hand side.
*  Those values will be chosen to correspond with the boundary
*  conditions.

      edgel = s.le.1
      edger = e.ge.nx

      del = ( offset1 - offset0 ) / ssum

      if (edgel) then 
         beg = s
         z(beg,gr_xl) = offset0  
      else
         beg = s - sgp
         z(beg,gr_xl) = offset0  + (beg-1)*del 
      end if

      if (edger) then
         fin = e
      else
         fin = e + egp
      end if

      z(beg,gr_dx)	= del

      Do i = beg,fin-1
         z(i+1,gr_dx) = scale * z(i,gr_dx)
         z(i+1,gr_xl) = z(i,gr_xl) + z(i,gr_dx)
      End Do

       
      if (edgel) then
*......................................................................
*  ..... Apply boundary conditions to extend the physical grid.
*		Do the LHS first!
*......................................................................
         if( bcl.eq.'reflect' )then
            Do i = 1,sgp
               j = s-i
               z(j,gr_dx) = z( s+i-1,gr_dx)
               z(j,gr_xl) = z(j-1,gr_xl) - z(j,gr_dx) 
            End Do 

         else 
            if((bcl.eq.'period ') .or. (bcl.eq.'flowin') .or.
     $         (bcl.eq.'flowout') .or. (bcl.eq.'fixed ') .or.
     &         (bcl.eq.'noflow' ) ) then
               Do i = 1, sgp
                  j = s-i
                  z(j,gr_dx) = z(s,gr_dx)
                  z(j,gr_xl) = z(j+1,gr_xl) - z(j+1,gr_dx) 
               End Do
            else
               call baderr('grid','Wrong left boundary condition !')
            end if
         endif
      end if


*  ..... Now do the RHS 
      if (edger) then
         if( bcr.eq.'reflect' )then
            Do i = 1,egp
               j = e+i
               z(j,gr_dx)= z(e-i+1,gr_dx)
               z(j,gr_xl) = z(j+1,gr_xl) + z(j,gr_dx) 
            End Do
         else 
            if((bcr.eq.'period' ) .or. (bcr.eq.'flowin') .or.
     $         (bcr.eq.'flowout') .or. (bcr.eq.'fixed ') .or.
     &         (bcr.eq.'noflow' ) ) then
               Do i = 1,sgp
                  z(e+i,gr_dx) = z(e,gr_dx)
                  z(e+i,gr_xl) = z(e,gr_xl) + z(e,gr_dx) * i
               End Do
            else 
               call baderr('grid','Wrong right boundary condition !')
            end if
         end if
      endif
 
*  ..... Now compute ZN znd ZNR
      beg = s-sgp
      fin = e+egp-1
      Do i = beg,fin
         z(i,gr_xr) = z(i+1,gr_xl)
         z(i,gr_x) = 0.5 * ( z(i,gr_xr) + z(i,gr_xl) )
      End Do

      j = fin
      fin = j+1
      z(fin,gr_xr) = z(j,gr_xr) + z(fin,gr_dx)
      z(fin,gr_x) = 0.5 * ( z(fin,gr_xr) + z(fin,gr_xl) )

*  ..... Set up the geometrical terms: areas and volumes
      call geom (s,e,sgp,egp,
     &     z(beg,gr_x),z(beg,gr_xl),z(beg,gr_xr),z(beg,gr_dx),
     &     z(beg,gr_area),z(beg,gr_areal),z(beg,gr_arear),
     &     z(beg,gr_dvol),
     &     igeom)
      
      return
      end
