*/*F
*******************************************************
*                                                     *
* SUBROUTINE FLUID_SOLVER                             *
*                                                     *
* Solve the 1D compressible fluid equations           *
*                                                     *
* This particular version implements PPM,             *
* the Piecewise Parabolic Method of Woodward          *
* and Colella (1984).                                 *
* This code is based on an original version by        *
* Bruce Fryxell.                                      *
*                                                     *
*  Version with a SIMPLIFIED RIEMANN SOLVER           *
*                                                     *
*    Author: Andrea Malagoli                          *
*    Date: 16 July 1995                               *
*                                                     *
*******************************************************
      subroutine Fluid_Solver(beg, end, bgp, egp, g, csi,
     &                        wold,uold,wsrc,usrc,wnew,unew,             
     &                        step_par, grid1_par, fluid_par, do_par, 
     &                        iy, iz, sweepdir)
      include 'ppm.h'
      include 'param.h'
      integer beg,end,bgp,egp
      dimension g(beg-bgp:end+egp,2), csi(beg-bgp:end+egp,0:7)

      parameter ( nvar = 7 , nsrc = 5 )
      dimension wold(nvar,beg-bgp:end+egp),uold(nvar,beg-bgp:end+egp)
      dimension wnew(nvar,beg-bgp:end+egp),unew(nvar,beg-bgp:end+egp)
      dimension wsrc(nsrc,beg-bgp:end+egp),usrc(nsrc,beg-bgp:end+egp)

      character*1 sweepdir


*.............. Local Variables .......................*
      integer ndim, stencil, in
      parameter (nmax    = q)
      parameter( stencil = 4 )
      parameter(in = 1-stencil, en = nmax+stencil)
      integer bc_left, bc_right, geom 
      dimension grid1_par(3)
*.......................................................*

*..... Do a little preparation here ........
        bc_left  = grid1_par(2)
        bc_right = grid1_par(3)
        geom     = grid1_par(1)

        smlrho = fluid_par( 1)
	smallp = fluid_par( 2)
	small  = 1.d-7
	smallu = small
	smalle = smallp

        ioff = beg-bgp-1

        nzn  = end-beg+1
	nzn1 = nzn+1
	nzn2 = nzn+2
	nzn3 = nzn+3
	nzn4 = nzn+4
	nzn5 = nzn+5
	nzn6 = nzn+6
	nzn7 = nzn+7
	nzn8 = nzn+8

	nriem = 3

	dt    = step_par(10)
	cfl   = step_par( 7)
	gamma = fluid_par( 4)
        fmult = 1.d0/(gamma - 1.d0)
        ggm1  = gamma*fmult
        cvisc = fluid_par(20)

*>>>>>>>>>>>>>>>> This is really redundant >>>>>>>>>>>>>>>*
*>>>>>>>>>>>>>>>>  and should change soon  >>>>>>>>>>>>>>>*
	Do i = 1, nzn8
                ii       = i+ioff
		x(i)     = csi(ii,0)
		xl(i)    = csi(ii,1)
		xr(i)    = csi(ii,2)
		dx(i)    = csi(ii,3)
		rho(i)   = wold(1,ii)
		u  (i)   = wold(2,ii)
		ut (i)   = wold(3,ii)
		utt(i)   = wold(4,ii)
		p(i)     = wold(5,ii)
		artvisc(i) = wold(7,ii)
		grav(i)  = g(ii,1)
		epot(i)  = g(ii,2)
c		areal(i) = csi(ii,5)
c		dvol(i)  = csi(ii,7)
	End Do
                

***********************************************************************

c.....Define the internal energy and the pressure......................

      do 10 i = 1,nzn8
      	v(i)    =  1. / rho(i)
      	ek      =  0.5 * ( u(i)**2 + ut(i)**2 + utt(i)**2)
      	ei(i)   =   fmult*p(i)/rho(i)
	c  (i)  = sqrt ( gamma*p(i)*rho(i) )
	ce (i)  = c(i)/rho(i)
	e  (i)  = ei(i) + ek + epot(i)
      	dtdx(i) =   dt/dx(i)
10    continue

********************************************
*     COMPUTE THE LEFT AND RIGHT STATES    *
********************************************

      call intrfc
      call states(j,k)

********************************************
*     CALL THE RIEMANN SOLVER              *
********************************************

      call riemann

c....Compiute the new fluxes.
 
*.... This is a special arrangements for a no-flow condition ....    
      if(bc_left  .eq. NOFLOW ) uav(5)  = 0.
      if(bc_right .eq. NOFLOW ) uav(nzn5) = 0.

      do 20 i = 5,nzn5

	 dens      = rhoav(i)
	 unorm     = uav  (i)
	 utrans1   = utav (i)
	 utrans2   = uttav(i)
	 press     = pav  (i)
	 rhou      = dens*unorm

      	 rhoflx (i)= rhou
      	 uflx   (i)= rhou*unorm
      	 utflx  (i)= rhou*utrans1
      	 uttflx (i)= rhou*utrans2

	 fke       = 0.5*(unorm**2+utrans1**2+utrans2**2)
	 egrav     = 0.5*(epot(i-1)+epot(i))

       	 eflx  (i) = rhou*(fke + egrav) + unorm*press*ggm1

20    continue


c * * * * * * * * * * THIS HAS TO BE REDONE IN THREED * * * * * * * *
c*******************************
c*                             *
c*     ARTIFICIAL VISCOSITY    *
c*                             *
c*******************************
c
      if( cvisc .gt. 1.d-5 ) then
c.......Define scrch2 as Delta(u)....

c       Do i = 5,nzn5
c            scrch2(i) = u(i-1) - u(i)
c       End Do
cc
cc.....Apply Artificial Viscosity to the Fluxes...................
        Do i = 5, nzn5
      	 rhoflx(i) = rhoflx(i) 
     &          + artvisc(i)* ( rho(i-1) - rho(i) )

    	 uflx  (i) = uflx  (i) 
     &          + artvisc(i)* ( rho(i-1)*u(i-1) - rho(i)*u(i) )

      	 utflx (i) = utflx (i) 
     &          + artvisc(i)*( rho(i-1)*ut(i-1) - rho(i)*ut(i) )

      	 uttflx(i) = uttflx(i) 
     &          + artvisc(i)*( rho(i-1)*utt(i-1) - rho(i)*utt(i) )

      	 eflx  (i) = eflx(i) 
     &          + artvisc(i)*( rho(i-1)*e(i-1) - rho(i)*e(i) )

       End Do
c
       endif
c * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

*********** THIS IS NOT NEEDED IN CARTESIAN GEOMETRY *********
c      do 251 i = 5, nzn5
c      	 rhoflx(i) = rhoflx(i) * areal(i)
c        uflx  (i) = uflx  (i) * areal(i)
c      	 utflx (i) = utflx (i) * areal(i)
c      	 uttflx(i) = uttflx(i) * areal(i)
c      	 eflx  (i) = eflx  (i) * areal(i)
c251   continue
**************************************************************


***************************************************
*     FINAL DIFFERENCING STEP                     *
***************************************************
c.....Differencing step for the density............
      ugmax = 0.

      do 30 i = 5 , nzn4

c * * * * * * * THIS IS NOT NEEDED IN CARTESIAN GEOMETRY * * * * * 
c         dtdx  (i) = dt       / dvol(i) 
c * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
         rhonu (i) = rho(i)   
     &            - dtdx(i)  * ( rhoflx(i+1) - rhoflx(i) )
         rhonu (i) = max ( smlrho , rhonu(i) )
30    continue

c.....Differencing step for the velocity............
c...........and the internal energy.................

      dth = dt*0.5

      do 40 i = 5 , nzn4
	 
	 dtdx0   = dtdx(i)

	 gradp   =          ( pav(i+1) - pav(i) )  
c	 gradp   = area(i)* ( pav(i+1) - pav(i) )  

         unu (i) = rho(i)*u(i) 
     &           - dtdx0*(  uflx(i+1) - uflx(i) + gradp )
     &           + dth*(rhonu(i)+rho(i))*grav(i) 

c * * * * * * * * WE USE CARTESIAN GEOMETRY * * * * * * * * * 
c     &                      * ( grav(i) + fict(i) )
         unu (i) = unu(i) / rhonu(i)

         utnu(i) = rho(i)*ut(i) 
     &           - dtdx0*( utflx(i+1) - utflx(i) )
         utnu(i) = utnu(i) / rhonu(i)

         uttnu(i)= rho(i)*utt(i)
     &           - dtdx0*( uttflx(i+1) - uttflx(i) )
         uttnu(i) = uttnu(i) / rhonu(i)

***********************************************************************
*    Total energy equation to include                              *
*
          enu (i) = rho(i) * e(i) 
     &            + dtdx0 * ( eflx(i)-eflx(i+1) )

c.....Compute the total energy density..............
c          enu(i) = enu(i) / rhonu(i)
*                                                                     *
***********************************************************************

40    continue

      gmm = (gamma-1.d0)

      ioff = beg-5

      Do  i = 5, nzn4
	  i4 = i+ioff
	  wnew(1,i4)	= max(rhonu(i),smlrho)
	  wnew(2,i4)	= unu  (i)
	  wnew(3,i4)	= utnu (i)
	  wnew(4,i4)	= uttnu(i)
	  fke           = 0.5*(unu(i)**2+utnu(i)**2+uttnu(i)**2)
	  flpr     	= gmm*(enu(i)-rhonu(i)*(fke+epot(i)))
	  wnew(5,i4)    = max(flpr,smallp)
      End do

      return
      end

***********************************************************************
***********************************************************************

      subroutine intrfc

******************************************************
*     CALCULATE INTERFACE VALUES OF ALL VARIABLES    *
******************************************************

c.....Define the global variables.....................

	include   'ppm.h'

******************************************************

c.....Compute the coefficients of the.................
c.........parabolic interpolation.....................
      call coeff

c.....Construct the intepolating parabolas............
c............for the density..........................
      call interp ( rhol , rho , rhor , 1.0 )

c.....Detect contact discontinuities..................
*.... WE DO NOT REALLY USE THIS ANY MORE   ...........
c      call detect ( rhol , rho ,rhor )
*.....................................................

c.....Construct the intepolating parabolas............
c............for the velocity.........................

      call interp ( ul  , u  , ur  ,-1.0 )
      call interp ( utl , ut , utr , 1.0 )
      call interp ( uttl, utt, uttr, 1.0 )

c............and for the pressure......................

      call interp ( pl , p , pr , 1.0 )

c.....Call the flattening routine......................

      call flaten

c.....Compute the interface variables..................

      do 10 i = 4,nzn5
         rhol(i) = flatn(i) * rho(i) + flatn1(i) * rhol(i)
         rhor(i) = flatn(i) * rho(i) + flatn1(i) * rhor(i)
         ul  (i) = flatn(i) * u  (i) + flatn1(i) * ul  (i)
         ur  (i) = flatn(i) * u  (i) + flatn1(i) * ur  (i)
         utl (i) = flatn(i) * ut (i) + flatn1(i) * utl (i)
         utr (i) = flatn(i) * ut (i) + flatn1(i) * utr (i)
         uttl(i) = flatn(i) * utt(i) + flatn1(i) * uttl(i)
         uttr(i) = flatn(i) * utt(i) + flatn1(i) * uttr(i)
         pl  (i) = flatn(i) * p  (i) + flatn1(i) * pl  (i)
         pr  (i) = flatn(i) * p  (i) + flatn1(i) * pr  (i)
10    continue

c.....Apply monotonocoty constraints....................

      call monot ( rhol , rho , rhor , drho , rho6 )
      call monot ( ul   , u   , ur   , du   , u6   )
      call monot ( utl  , ut  , utr  , dut  , ut6  )
      call monot ( uttl , utt , uttr , dutt , utt6 )
      call monot ( pl   , p   , pr   , dp   , p6   )

      do 20 i = 4,nzn5
         vl(i) = 1.0 / rhol(i)
         v (i) = 1.0 / rho (i)
         vr(i) = 1.0 / rhor(i)
20    continue

      return
      end

*********************************************************************
*********************************************************************
*                                                                   *
      subroutine coeff
*                                                                   *
*     CALCULATE COEFFICIENTS OF CUBIC INTERPOLATION POLYNOMIAL      *
*                                                                   *
*                                                                   *
*********************************************************************
c.....Define Global Variables............

	include   'ppm.h'

c.........................................
c.....Compute auxiliary quantities........ 

      do 10 i = 2 , nzn8
         scrch1(i) = dx(i)     + dx(i-1)
         scrch2(i) = scrch1(i) + dx(i)
         scrch3(i) = scrch1(i) + dx(i-1)
10    continue

      do 20 i = 2 , nzn7
         scrch4(i) = dx(i)     / ( scrch1(i) + dx(i+1) )
         coeff1(i) = scrch4(i) *   scrch3(i) / scrch1(i+1)
         coeff2(i) = scrch4(i) *   scrch2(i+1) / scrch1(i)
20    continue

c.....Compute the coefficients of the cubic interpolation..............

      do 30 i = 2,nzn6
         scrch4(i) =   1.0 / ( scrch1(i) + scrch1(i+2) )
         coeff3(i) = - scrch4(i) * dx(i)   * scrch1(i)   / scrch3(i+1)
         coeff4(i) =   scrch4(i) * dx(i+1) * scrch1(i+2) / scrch2(i+1)
         coeff5(i) =   dx(i) -
     &                 2. * ( dx(i+1) * coeff3(i) + dx(i) * coeff4(i) )
         coeff5(i) =   coeff5(i) / scrch1(i+1)
30    continue
c
      return
      end
c
***********************************************************************
***********************************************************************
*							              *
      subroutine interp( al , a , ar , sgn )
*							              *
*     INTERPOLATE INTERFACE VALUES AND MONOTONIZE     	    	      *
*								      *
***********************************************************************
c.....Define Global Variables............
	include   'ppm.h'

c.....Dimension Local arrays.............

      dimension  al(q) , a(q) , ar(q)

c.....Define auxiliary quantities........

      do 10 i = 2,nzn8
         scrch1(i) = a(i) - a(i-1)

         scrch2(i) = abs ( scrch1(i) + scrch1(i) )
10    continue

c.....Apply monotonicity constraints.....

      Do i = 2,nzn6
         dela(i)   = coeff1(i) * scrch1(i+1) 
     &             + coeff2(i) * scrch1(i)

c         scrch3(i) = cvmgm ( -1.0 , 1.0 , dela(i) )

         if( dela(i) .lt. 0. ) then
            dela(i) = - min(abs(dela(i)),scrch2(i),scrch2(i+1))
         else
            dela(i) =   min(abs(dela(i)),scrch2(i),scrch2(i+1))
	 endif

	 test1 = -scrch1(i) * scrch1(i+1)
	 if( test1 .ge. 0. ) dela(i) = 0.0

      End Do

c.....Modify the interface variables.....

      do 30 i = 2,nzn5
         ar(i)   = a (i) + coeff5(i) * scrch1(i+1) 
     &                   + coeff3(i) * dela(i+1)
         ar(i)   = ar(i) + coeff4(i) * dela(i)
         al(i+1) = ar(i)
30    continue

      return
      end

***********************************************************************
***********************************************************************
*								      *
      subroutine detect ( al , a , ar )
*                                                                     *
*     SEARCH FOR CONTACT DISCONTINUITIES IN VARIIABLE A AND           *
*            STEEPEN THE ZONE STRUCTURE IF NECESSARY  		      *
*                                                                     *
***********************************************************************
c.....Define the Global Variables........

	include   'ppm.h'

c.....Dimension the Local Arrays.........

      DIMENSION al(q) , a(q) , ar(q)

c.....Define auxiliary parameters

      DATA    eta1 , eta2 , epsln , ak0 
     &      / 20.0 , 0.05 , 0.01  , 0.1 /

c.....
c     eta1  = 20.
c     eta2  = 0.05
c     epsln = 0.01
c     ak0   = 0.1
c.....
c.....Compiute auxiliary quantities......

      do 10 i = 2 , nzn7
         temp1     = dx(i) + dx(i-1)
         temp3     = a(i)  - a (i-1)
         scrch2(i) = temp1 + dx(i+1)
         scrch3(i) = temp3 / temp1    
10    continue

      do 20 i = 2 , nzn6
         temp1     = x(i) - x(i-1)
         scrch1(i) = temp1 * temp1 * temp1    
         scrch2(i) = ( scrch3(i+1) - scrch3(i) ) / scrch2(i)
         scrch4(i) = abs( a(i) )
20    continue

      do 40 i = 3 , nzn5

	  temp2     = a(i+1)-a(i-1)

	  if( scrch2(i-1)*scrch2(i+1) .lt. 0.0 ) then
               temp3     = ( scrch2(i-1) - scrch2(i+1) ) * 
     &                     ( scrch1(i)   + scrch1(i+1) )
	       if( temp2 .eq. 0. ) temp2 = small*smlrho
	       temp3     = temp3 / ( ( x(i+1) - x(i-1) ) * temp2 )
	   else
	       temp3     = 0.0
	   endif

********************************************************************
*     temp2 and temp3 now contain finite difference apporximations *
*     to the second and third derivativess of a.                   *
********************************************************************

         temp4 = epsln * min ( scrch4(i+1), scrch4(i-1) )-abs(temp2)

	 if( temp4 .ge. 0. ) temp3 = 0.

         temp3 = max ( 0.0 , min ( eta1 * ( temp3-eta2 ) , 1.0 ) )

         temp1 = abs  ( p(i+1) - p(i-1) ) 
     &          / min ( p(i+1) , p(i-1) )
         temp2 = abs  ( rho(i+1) - rho(i-1) )
     &          / min ( rho(i+1) , rho(i-1) )

	 test1 = gamma*ak0*temp2 - temp1
	 if( test1 .lt. 0. ) temp3 = 0.

**********************************************************************
*     temp3 now contains the contact steepening coefficient         *
**********************************************************************

         temp1 = a(i-1) + 0.5 * dela(i-1)
         temp2 = a(i+1) - 0.5 * dela(i+1)

c.....Modify the left and right interface variables...................

         temp4 = (1.0 - temp3)
         al(i) = al(i) * temp4 + temp1 * temp3    
         ar(i) = ar(i) * temp4 + temp2 * temp3    
40    continue

      return
      end

***********************************************************************
***********************************************************************
*								      *
      subroutine flaten
*								      *
*     flaten zone structure in regions where shocks are too thin      *
*								      *
***********************************************************************
c.....Define the Global Variables.....................................

	include   'ppm.h'

c.....Define the local constants......................................

c..flattening coefficients for the simplified method..................

      DATA  epsiln , omg1 , omg2 
     &    /  0.33  , 0.75 , 10.0 /

******************************************************
 
c.....Compiute some auxiliary variables...............

      do 10 i = 1 , nzn8
         ce(i) = sqrt ( gamma * p(i) / rho(i) )
         v(i) =  1.0 / rho(i)
10    continue

c.....Compiute the variations of the variables........

*********************
* simplified method *
*********************

      do 20 i = 3 , nzn6
c.....Compiute the variations of the variables........
         dp(i) = p(i+1) - p(i-1)
         duf   = u(i+1) - u(i-1)
         dp2   = p(i+2) - p(i-2)

         temp1 = epsiln * min ( p(i+1) , p(i-1) ) - abs ( dp(i) ) 

         if( dp2.ne.0.0 .and. temp1.lt.0.0 .and. duf.lt.-smallu ) then
	          temp2     = (dp(i)/dp2 - omg1) * omg2
                  scrch3(i) =  max ( 0.0 , temp2 )
	 else
		  scrch3(i) = 0.0
	 endif

20    continue

c.....Compiute the flattening coefficients............
      do 21 i = 4,nzn5

	 if( dp(i) .lt. 0. ) then
		  temp2 = scrch3(i+1)
	 else
		  temp2 = scrch3(i-1)
	 endif

         flatn(i) = max (0.0,min(1.0,max(scrch3(i),temp2)))
         flatn1(i)= 1.0 - flatn(i)

c         ugrid(i)  = 0.0
c         scrch2(i) = 0.0

21    continue
      return
      end

***********************************************************************
***********************************************************************
*								      *
      subroutine monot( al , a , ar , da , a6 )
*								      *
*     APPLY MONOTONICITY CONSTRAINT TO INERPOLATION PARABOLA          *
*								      *
***********************************************************************
c.....Define Global Variables...................

	include   'ppm.h'

c.....Dimension Local Arrays....................

      dimension al(q) , a(q) , ar(q) , da(q) , a6(q)

      do 10 i = 4 , nzn5
         da(i)     =   ar(i) - al(i)
         scr1 = ( ar(i) - a(i) ) * ( al(i) - a(i) )

	 if( scr1 .ge. 0. ) then
		al(i) = a(i)
		ar(i) = a(i)
	 endif

         scr2 = 3.0 * a(i) - 2.0 * ar(i)
         scr3 = 3.0 * a(i) - 2.0 * al(i)

         test1 = da(i) * ( al(i) - scr2 )
	 if( test1 .lt. 0. ) al(i) = scr2

         test1 = da(i) * ( scr3 - ar(i) )
	 if( test1 .lt. 0. ) ar(i) = scr3

         da(i)     = ar(i) - al(i)
         a6(i)     = 6.0 * a(i) - 3.0 * ( al(i) + ar(i) )

10    continue

      return
      end

***********************************************************************
***********************************************************************
*								      *
      subroutine states(j,k)
*								      *
*     COMPUTE LEFT AND RIGHT STATES FOR INPUT TO RIEMANN PROBLEM      *
*								      *
***********************************************************************
c.....Define Global Variables............
	include   'ppm.h'

*......... forthd = 4.0 / 3.0
      data forthd /1.33333333333333333333333/

c.....Dimension Local Arrays..............
c      dimension dloga(q)


*************************************
*      			            *
*     Calculate the left states     *
*      			            *
*************************************

c.....Correct the velocity for the grid-motion.............

c      do 5 i = 1,nzn8
c         urel(i) = u(i) - ugrid(i)
c          urel(i) = u(i)
c5     continue

*************************************
*     CONSTRUCT THE LEFT STATES     *
*************************************

      Do i = 5 , nzn6

         scr1 = dtdx(i-1) * ( u(i-1) + ce(i-1) )
         cflno(i)  =       max ( 0.0 , scr1 )
         scr1 = 0.5 * min ( 1.0 , cflno(i)  )
         scr2 = 1.0 - forthd * scr1

         ppl  (i)  = pr  (i-1) - scr1*(dp  (i-1) - scr2 * p6  (i-1) )
         upl  (i)  = ur  (i-1) - scr1*(du  (i-1) - scr2 * u6  (i-1) )
         rhopl(i)  = rhor(i-1) - scr1*(drho(i-1) - scr2 * rho6(i-1) )
         ppl  (i)  = max (smallp , ppl(i) )

         scr3 = dtdx(i-1) * ( u(i-1) - ce(i-1) )
	 scrch3(i) = scr3

         scr1 = 0.5 * min ( 1.0 , max(0.0, scr3 ) )
         scr2 = 1.0 - forthd * scr1

         pml  (i)  = pr  (i-1) - scr1*(dp  (i-1) - scr2 * p6  (i-1) )
         uml  (i)  = ur  (i-1) - scr1*(du  (i-1) - scr2 * u6  (i-1) )
         rhoml(i)  = rhor(i-1) - scr1*(drho(i-1) - scr2 * rho6(i-1) )

         pml  (i)    = max ( smallp , pml(i) )

      End Do

      Do i = 5 , nzn6
         scr4 = dtdx(i-1) * u(i-1)
	 scrch4(i) = scr4

         scr1 = 0.5 * min ( 1.0 , max(0.0, scr4) )
         scr2 = 1.0 - forthd * scr1

         p0l  (i)  = pr  (i-1) - scr1*(dp  (i-1) - scr2 * p6  (i-1) )
         u0l  (i)  = ur  (i-1) - scr1*(du  (i-1) - scr2 * u6  (i-1) )
         rho0l(i)  = rhor(i-1) - scr1*(drho(i-1) - scr2 * rho6(i-1) )
         utlft(i)  = utr (i-1) - scr1*(dut (i-1) - scr2 * ut6 (i-1) )
         uttlft(i) = uttr(i-1) - scr1*(dutt(i-1) - scr2 * utt6(i-1) )

         p0l  (i)  = max ( p0l(i) , smallp )

         clft(i)   = sqrt ( gamma * ppl(i) * rhopl(i) )

         scr1 = 0.5*(upl(i)-uml(i)-(ppl(i)-pml(i))/clft(i))
         scr2 = (ppl(i)-p0l(i))/(clft(i)*clft(i))+1./rhopl(i)
         scr2 = scr2 - 1. / rho0l(i)

	 if( scrch3(i) .le. 0 ) scr1 = 0.0
	 if( scrch4(i) .le. 0 ) scr3 = 0.0

         plft(i) = ppl(i) + clft(i) * scr1
         plft(i) = max ( plft(i) , smallp )
         ulft(i) = upl(i) - scr1
         vlft(i) = 1. / rhopl(i) - scr2 - scr1 / clft(i)
         ulft(i) = ulft(i) + 0.5 * dt *  grav(i-1) 

       End Do

cc.....Add the source terms for the geometry................
c
c      if ( igeom .lt. 3 .and. igeom .ge. 1) then
c                          do 41 i = 1,nzn8
c                             dloga(i) = igeom / x(i)
c41                        continue
c      else
cc
c                          do 412 i = 1,nzn8
c                             dloga(i) = 0.
c412                       continue
c      endif

c      if ( igeom .eq. 1 .or. igeom .eq. 2 ) then
c
c                          do 42 i = 1,nzn8
c                             scrch1(i) = ( abs ( u(i) - ugrid(i) ) 
c     &                                    + ce(i) ) * dtdx(i)
c                             eta       = ( 1.0   - scrch1(i) ) / 
c     &                                   ( ce(i) * dt * dloga(i) )
c                             eta       = min ( eta , 1.0 )
c                             dloga(i)  = eta * dloga(i)
c42                        continue
c      endif

c.....Finally compute the Left States......................

* *NOT NEEDED * CARTESIAN GEOMETRY * * * * * * * * * * * * * ** 
c      do 45 i = 5 , nzn6
c         scrch1(i) = 0.5 * rho(i-1) * u(i-1) * dt * dloga(i-1)
c         vlft(i) = 1.0 / vlft(i) - scrch1(i)
c         vlft(i) = 1.0 / vlft(i)
c         plft(i) = plft(i) - scrch1(i) * ce(i-1) * ce(i-1) 
c         plft(i) = max ( plft(i) , smallp )
c * * * * * * CARTESIAN GEOMETRY * * * * * * * * * * * * * * * * 
c         ulft(i) = ulft(i) + 0.5 * dt *  grav(i-1) 
c         ulft(i) = ulft(i) + 0.5 * dt * ( grav(i-1) + fict(i-1) )
c
c45    continue


**************************************
*     CONSTRUCT THE RIGHT STATES     *
**************************************

      Do i = 4,nzn5

         scr3 = - dtdx(i) * ( u(i) + ce(i) )
         scr1 =  0.5 * min ( 1.0 , max ( 0.0 , scr3 ) )
         scr2 =  1.0 - forthd * scr1
	 scrch3(i) = scr3

         ppl  (i)  =  pl  (i) + scr1*(dp  (i) + scr2 * p6  (i))
         ppl  (i)  =  max ( ppl(i) , smallp )
         upl  (i)  =  ul  (i) + scr1*(du  (i) + scr2 * u6  (i))
         rhopl(i)  =  rhol(i) + scr1*(drho(i) + scr2 * rho6(i))

         scr1 = - dtdx(i) * ( u(i) - ce(i) )
         scr1 =  max ( 0.0  , scr1 )
         cflno (i) =  max ( cflno(i) , scr1 )

         scr1 = 0.5 * min ( 1.0 , scr1 )
         scr2 = 1.0 - forthd * scr1

         pml(i)    = pl(i) + scr1*(dp  (i) + scr2 * p6(i) )
         pml(i)    = max ( pml(i) , smallp )
         uml(i)    = ul  (i)  + scr1*(du  (i) + scr2 * u6  (i) )
         rhoml(i)  = rhol(i)  + scr1*(drho(i) + scr2 * rho6(i) )

      End Do

      Do i = 4 , nzn5

         scr4 = -dtdx(i) * u(i)
         scr1 = 0.5 * min ( 1.0 , max ( 0.0 , scr4 ) )
         scr2 = 1.0  - forthd * scr1
	 scrch4(i) = scr4

         p0l   (i) = pl  (i) + scr1*(dp  (i) + scr2 * p6  (i) )
         p0l   (i) =       max ( p0l(i) , smallp )
         u0l   (i) = ul  (i) + scr1*(du  (i) + scr2 * u6  (i) )
         rho0l (i) = rhol(i) + scr1*(drho(i) + scr2 * rho6(i) )
         utrght(i) = utl (i) + scr1*(dut (i) + scr2 * ut6 (i) )
         uttrght(i)= uttl(i) + scr1*(dutt(i) + scr2 * utt6(i) )

         crght(i)  = sqrt ( gamma * pml(i) * rhoml(i) )
         scr1 = -0.5*(uml(i)-upl(i)+(pml(i)-ppl(i))/crght(i))
         scr2 = ( pml(i) - p0l(i) ) 
     &          / ( crght(i) * crght(i) ) + 1.0 / rhoml(i)
         scr2 = scr2 - 1.0 / rho0l(i)

	 if( scrch3(i) .le. 0. ) scr1 = 0.
	 if( scrch4(i) .le. 0. ) scr2 = 0.

         prght(i) = pml(i) + crght(i) * scr1
         prght(i) = max ( prght(i) , smallp )
         urght(i) = uml(i) + scr1
         vrght(i) = 1.0 / rhoml(i) - scr2 - scr1 / crght(i)

         urght(i) = urght(i) + 0.5 * dt *  grav(i)
      End Do

c.....Finally comput the Right States...................................

* *NOT NEEDED * CARTESIAN GEOMETRY * * * * * * * * * * * * * ** 
c      do 90 i = 4 , nzn5
c
c         scrch1(i) = 0.5 * rho(i) * u(i) * dt * dloga(i)
c         vrght(i) = 1.0 / vrght(i) - scrch1(i)
c         vrght(i) = 1.0 / vrght(i)
c         prght(i) = prght(i) - scrch1(i) * ce(i) * ce(i)
c         prght(i) = max ( prght(i) , smallp )

c         urght(i) = urght(i) + 0.5 * dt *  grav(i)
c         urght(i) = urght(i) + 0.5 * dt * ( grav(i) + fict(i) )
c
c90    continue
c
c      if ( xl(5) .ne. 0.) return
c      if ( igeom .eq. 1 .or. igeom .eq. 2) then
c           urght(5) = 2. * u(5) * cflno(5)
c           ulft(5) = -urght(5)
c      endif
c * NOT NEEDED CARTESIAN GEOMETRY * * * * * * * * * * * * * * * * 

      return
      end

***********************************************************************
***********************************************************************
*								      *
      subroutine riemann
*								      *
*     SOLVE RIEMANN SHOCK TUBE PROBLEM				      *
*								      *
*								      *
***********************************************************************
c.....Define Global Variables............
      include   'ppm.h'

      gammap1 = gamma + 1.0

      Do i = 5,nzn5

         pstar(i) = prght(i)-plft(i)-crght(i)*(urght(i)-ulft(i))
         pstar(i) = plft(i) + pstar(i) * clft(i) 
     &            / ( clft(i) + crght(i) )
         pstar(i) = max ( smallp , pstar(i) )

      End Do

c.....Begin main iteration loop of the Riemann Solver..................
      grat = 0.5 * gammap1 / gamma

      Do n = 1 , nriem
c.......................
      Do i = 5 , nzn5

         wlf   = 1.0 + grat*( pstar(i) - plft (i) ) / plft(i)
         wrgh  = 1.0 + grat*( pstar(i) - prght(i) ) / prght(i)

         wlft (i)  = clft(i)  * sqrt ( wlf  )
         wrght(i)  = crght(i) * sqrt ( wrgh )

         scr1      = 4.0*vlft(i)*wlft(i)*wlft(i)
         scrch1(i) = -scr1*wlft(i)/(scr1-gammap1*(pstar(i)-plft(i)))

         scr2      = 4.0*vrght(i)*wrght(i)*wrght(i)
         scrch2(i) = scr2*wrght(i)/(scr2-gammap1*(pstar(i)-prght(i)))

         scr3 = ulft (i) - ( pstar(i) - plft (i) ) / wlft (i)
         scr4 = urght(i) + ( pstar(i) - prght(i) ) / wrght(i)

         pstar(i)  = pstar(i) + ( scr4 - scr3 ) 
     &                        * ( scrch1(i) * scrch2(i) )
     &                        / ( scrch2(i) - scrch1(i) )
         pstar(i) = max ( smallp , pstar(i) )

      End Do

c.....End of the main loop of the Riemann Solver.......................

      End Do

c.....................
      gamma1 = gamma-1.

      Do i = 5 , nzn5

         scr3 = ulft(i)  - ( pstar(i) - plft(i)  ) / wlft(i)
         scr4 = urght(i) + ( pstar(i) - prght(i) ) / wrght(i)
         ustar(i)  = 0.5 * ( scr3 + scr4 )

	 if( ustar(i) .ge. 0.0 ) then
            ps(i)     = plft(i) 
            us(i)     = ulft(i) 
            uts(i)    = utlft(i)
            utts(i)   = uttlft(i)
            vs(i)     = vlft(i)
            ws(i)     = wlft(i) 
	 else
            ps(i)     = prght(i) 
            us(i)     = urght(i) 
            uts(i)    = utrght(i)
            utts(i)   = uttrght(i)
            vs(i)     = vrght(i)
            ws(i)     = wrght(i) 
	 endif

         rhos(i)   = 1.0 / vs(i)
         rhos(i)   = max ( smlrho , rhos(i) )
         vs  (i)   = 1.0 / rhos(i)

      End Do

      gamma1p1 = gamma1/gammap1

      Do i = 5 , nzn5
         signu = sign ( 1.0 , ustar(i) )
         ces   (i) = sqrt ( gamma * ps(i) * vs(i) )
         vstar (i) = vs(i) - ( pstar(i) - ps(i) ) / ( ws(i) * ws(i) )
         vstar (i) = max ( vstar(i) , gamma1p1 * vs(i))
         rhostr(i) = 1.0 / vstar(i)
         cestar(i) = sqrt ( gamma * pstar(i) * vstar(i) )
         wes   (i) = ces   (i) - signu * us   (i)
         westar(i) = cestar(i) - signu * ustar(i)

         scr4 = ws(i) * vstar(i) - signu * ustar(i)
         delp = pstar(i) - ps(i) - smallp

	 if( delp .ge. 0. ) then 
		   wes   (i) = scr4
		   westar(i) = scr4
	 endif

c         wes(i)    = wes(i) + scrch1(i) * ugrid(i)
c         westar(i) = westar(i) + scrch1(i) * ugrid(i)

      End Do

c.....Compute correct state for the Rarefaction Fan....................
      Do i = 5 , nzn5

         wem       = abs  ( wes(i) - westar(i) )
         wep       = abs  ( wes(i) + westar(i) )

         scr1 = max  ( wem , wep , smallu )
         scr1 = wep / scr1

         scr1 = 0.5 * ( 1.0 + scr1 )
         scr2 = 1.0 - scr1

         rhoav(i) = scr1 * rhostr(i) + scr2 * rhos(i)
         uav  (i) = scr1 * ustar (i) + scr2 * us  (i)
         pav  (i) = scr1 * pstar (i) + scr2 * ps  (i)

         utav (i) = uts (i)
         uttav(i) = utts(i)

         if( westar(i) .ge. 0.0 ) then
             rhoav(i) = rhostr(i)
             uav(i)   = ustar(i)
             pav(i)   = pstar(i) 
         endif

         if( wes(i) .lt. 0.0 ) then
             rhoav(i) =  rhos(i)
             uav(i)   =  us(i)
             pav(i)   =  ps(i)
         endif 

      End Do

      return
      end

c***********************************************************************
c*								      *
c      subroutine force(l)
c*								      *
c*     COMPUTE CENTRIFUGAL AND CORIOLIS FORCES DUE TO CIRCULAR GRID    *
c*								      *
c*								      *
c***********************************************************************
cc.....Define Global Variables...........
c	include   'ppm.h'
c
cc.....Dimension Local Arrays............
cc      dimension dens(q),dmass(q),tmass(q)
c
c*************************************************************
c*     COMPUTE FICTITIOUS FORCES (CENTRIFUGAL AND CORIOLIS)  *
c*     FOR SPHERICAL OR CYLINDRICAL COORDIATES               *
c*************************************************************
c
c      do 10 i = 1 , nzn8
c         fict(i) = 0.0
c10    continue
c
c      if ( igeomx .lt. 3 ) return
c
c
cc.....Case of cylindrical and radial coordinates.............
c      if(igeom .eq. 1 .or. igeom .eq. 2) then
c
c         do 20 i = 1,nzn8
cc            fict(i) = ut(i) * ut(i) / x(i)
c20       continue
c
cc.....Case of cylindrical and angular coordinates............
c      else
c
c         do 30 i = 1,nzn8
c            fict(i) = -u(i) * ut(i) / xzn(l)
c30       continue
c
c      endif
c
c      return
c      end
c
c***********************************************************************

