
* INSERT HEADER HERE

*/*F
**************************************************
*                                                *
*  subroutine F_DRIVER                           *
*                                                *
*  The Fortran driver for the hydro code.        *
*                                                *                                                     *
*    Author: Andrea Malagoli                     *
*    Date: 16 June 1995                          *
*                                                *
**************************************************
*F*/
	subroutine f_driver(sz,mg_li,mg_nli,ndim,proc,pgm,
     &             ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &                 gravx, gravy, gravz, phi,
     &                 r, wrk, wppm)

         include 'meshf.h'
         include 'param.h'

         integer sz(sz_0:sz_1,ndim,1)
         integer mg_li(mg_0:mg_1,ndim,1)
         integer mg_nli(mg_0:mg_1,ndim,1)
         integer proc(p_0:p_1), pgm(*)

         dimension ux(*), uy(*), uz(*), rho(*), press(*),scalar(*)
         dimension temp(*), phi(*), r(*)
         dimension gravx(*), gravy(*), gravz(*)
         dimension x(*), y(*), z(*)
         dimension wrk(*), wppm(*)

*........ Local variables ..........................*
         logical do_grav, do_heat, do_fluid
         character*7 filenames(2)

*........ Call the initialization routine .........*
         call first(sz,ndim,proc,pgm,
     &              ux, uy, uz, rho, press, temp, scalar,
     &              x, y, z,
     &              gravx, gravy, gravz, phi, wrk, 
     &              fluid_par, grid_par, out_par, step_par,
     &              do_par, filenames )

*...................................................*
*       BEGIN THE MAIN LOOP                         *
*...................................................*

         nbeg      = step_par(3)
         nend      = step_par(4)
         ncflcheck = step_par(5)
         do_fluid  = do_par(1)
         do_heat   = do_par(3)
         do_grav   = do_par(2)
         time      = step_par(2)
         
         Do nstep = nbeg, nend
         out_par (1) = nstep-nbeg+1
         step_par(1) = nstep 
c ------ The real code goes in here -------- *

*>>>>>>>>> The SELF-GRAVITY STEP>>>>>*
         if( do_grav ) then
               call self_gravity_3d(sz,mg_li,proc,pgm,
     &               rho, phi, r, x, y, z, wrk,  
     &               step_par, grid_par, fluid_par, do_par )

         endif

*>>>>>>>>> The HYDRO STEP >>>>>>>>>>*
         if( do_fluid ) then
              call fluid_3d(sz,proc,pgm,
     &              ux, uy, uz, rho, press, temp, scalar, x,y,z,
     &              gravx, gravy, gravz, phi, r, wrk,  
     &              step_par, grid_par, fluid_par, do_par )
         endif

*>>>>>>>> The TIME STEP CONTROL STEP >>>*
         if( mod(nstep,ncflcheck) .eq. 0 ) then
             call check_cfl(sz,proc,pgm,
     &               ux, uy, uz, rho, press, temp,  x,y,z, 
     &               step_par, grid_par, fluid_par, do_par )
         endif

*>>>>>>> Update the paramteres >>>>>>*
         dt = step_par(10)
         time = time+dt
         step_par(2) = time
         out_par(2)  = time

*>>>>>>>>> The OUTPUT STEP >>>>>>>>>>*
	       call output(sz,proc,pgm,filenames,
     &              ux, uy, uz, rho, press, temp, scalar, x,y,z,
     &              gravx, gravy, gravz, phi, r, wrk,  
     &              step_par, grid_par, fluid_par, out_par, do_par )

         End Do

         return
         end

*---------------------------------------------------------------*
**************************************************
*                                                *
* subroutine FIRST                               *
*                                                *
* Setup the initial configuration and the        *
* parameters for the run.                        *
*                                                *
**************************************************
	subroutine first(sz,ndim,proc,pgm,
     &                   ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &                   gravx, gravy, gravz, phi, wrk,
     &                   fluid_par, grid_par, out_par, step_par,
     &                   do_par, filenames )

         include 'meshf.h'
         include 'param.h'

         integer sz(sz_0:sz_1,ndim,1)
         integer proc(p_0:p_1), pgm(*)

         dimension ux(*), uy(*), uz(*), rho(*), press(*), scalar(*)
         dimension temp(*), wrk(*)
         dimension x(*), y(*), z(*)
         dimension gravx(*), gravy(*), gravz(*), phi(*)

*........ Local variables ..........................*
         character*7 filenames(2)
*...................................................*
c	 print *, "calling setup"
         call setup(sz,ndim,proc,pgm,
     &                 ux, uy, uz, rho, press, temp, scalar,
     &                 x, y, z,
     &                 gravx, gravy, gravz, phi, wrk,
     &                 fluid_par, grid_par, out_par, step_par,
     &                 do_par, filenames )

c	 print *, "calling check_cfl"
         call check_cfl(sz,proc,pgm,
     &                  ux, uy, uz, rho, press, temp, x, y, z, 
     &                  step_par, grid_par, fluid_par, do_par)

         return
         end
*---------------------------------------------------------------*
