
* INSERT HEADER HERE

**************************************************
*                                                *
*  subroutine CHECK_CFL                          *
*                                                *
*  Check the time step constraint                *
*  for the hydro code.                           *
*                                                *
**************************************************
      subroutine check_cfl(sz,proc,pgm,
     &            ux, uy, uz, rho, press, temp,  x, y, z, 
     &            step_par, grid_par, fluid_par, do_par)

      include 'meshf.h'
      include 'param.h'

      dimension ux(*), uy(*), uz(*), rho(*), press(*), temp(*)
      dimension x(*), y(*), z(*) 

*.... We pass a dummy argument to the local routine for simplicity
*.... reasons (scalar is defined in the "3d.h" include).....
      dimension scalar(1)

      parameter( ndim = 3)
      integer sz(sz_0:sz_1,ndim), proc(p_0:p_1), pgm(1), ierr

* ................ Local Variables..............*
      real*8 cfl_glob(1), work(1)
      logical printinfo

      call AL_get_array_bounds(bx,ex,bxgp,exgp,"x",sz)
      call AL_get_array_bounds(by,ey,bygp,eygp,"y",sz)
      call AL_get_array_bounds(bz,ez,bzgp,ezgp,"z",sz)

      printinfo = do_par(4)

      dt = step_par(10)

*.... This checks only for the CFL condition ......*
*.... Other conditions can be easily insrted here .*
      cfl_loc = get_local_cfl(bx,ex,bxgp,exgp,by,ey,bygp,eygp,
     &                     bz,ez,bzgp,ezgp,
     &                     ux, uy, uz, rho, press, temp, scalar,x,y,z,
     &                     step_par, fluid_par, grid_par) 
       
      cfl_glob(1) =  cfl_loc
c     call PIgdmax(cfl_glob,1,work,0)
      call MPI_ALLREDUCE(cfl_glob(1),work(1),1,MESH_PRECISION,
     &     MPI_MAX,MPI_COMM_WORLD,ierr)
      cfl_max = work(1)
    
      courno = step_par(7)

      dt = courno/cfl_max

      step_par(10) = dt

      if( printinfo ) print *,'dt is ',dt

      return
      end

*................................................................*
      function get_local_cfl(bx,ex,bxgp,exgp,by,ey,bygp,eygp,
     &                    bz,ez,bzgp,ezgp,
     &                    ux, uy, uz, rho, press, temp, scalar, x,y,z,
     &                    step_par, fluid_par, grid_par)
      include 'meshf.h'
      include '3d.h'
      include 'param.h'
      include 'grid.h'

      static iopen
      data iopen /0/

      gamma = fluid_par(4)
      cflno = 0.d0

********** DEBUG ********************************
c      if( iopen .eq. 0 ) then
c      open(10,file='temp.dat',form='unformatted')
c      iopen = 1
c      endif
c      write(10)rho,ux,uy,uz,temp 
*************************************************

      Do k = bz, ez
        dz = z(k,gr_dx)
        Do j = by, ey
          dy = y(k,gr_dx)
          Do i = bx, ex
            dx = x(k,gr_dx)
            cs2 = gamma*temp(i,j,k)
            cs  = sqrt(cs2)
            vax = (abs(ux(i,j,k))+cs)/dx
            vay = (abs(uy(i,j,k))+cs)/dy
            vaz = (abs(uz(i,j,k))+cs)/dz
            cflno = max(cflno,vax,vay,vaz)
          End Do
        End Do
      End Do

      get_local_cfl = cflno

      return
      end  
*................................................................*
