*/*F
**************************************************
*                                                *
*  subroutine BC_FLUID                           *
*                                                *
*  Specifiy boundary conditions for the fluid    *
*  solver.                                       *
*                                                *
*    Author: Andrea Malagoli                     *
*    Date: 16 June 1995                          *
*                                                *
**************************************************
*F*/
      subroutine BC_Fluid(sz,proc,pgm,
     &             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp,
     &             ux, uy, uz, rho, press, temp, scalar, x, y, z,
     &             gravx, gravy, gravz, phi, src,
     &             step_par, grid_par, fluid_par , do_par, sweepdir)
      include 'meshf.h'
      include '3d.h'
      include 'grav.h'
      include 'grid.h'
      include 'param.h'
      integer b,e,bgp,egp
      character*1 sweepdir

      integer sz(sz_0:sz_1,ndim),proc(p_0:p_1)      
      integer pgm(1)

*..... Local Arrays .....................................*
      integer bx0, bx1, by0, by1, bz0,bz1
      logical do_scalar
*........................................................*

      myid  = proc(p_id)
      nproc = proc(p_np)
  
      do_scalar = do_par(7)

*..... Default boundary values are COMM .................*

      bx0 = COMM
      bx1 = COMM
      by0 = COMM
      by1 = COMM
      bz0 = COMM
      bz1 = COMM

*..... Begin by verifying that we have some real boundaries .....

*.... this is the global size .....
      nx = sz(sz_mdim,1) 
      ny = sz(sz_mdim,2) 
      nz = sz(sz_mdim,3) 

      if( bx .eq.  1 ) bx0 = grid_par( 5)
      if( ex .eq. nx ) bx1 = grid_par( 6)
      if( by .eq.  1 ) by0 = grid_par(11)
      if( ey .eq. ny ) by1 = grid_par(12)
      if( bz .eq.  1 ) bz0 = grid_par(17)
      if( ez .eq. nz ) bz1 = grid_par(18)

*..... Now we are ready to do the data exchange ..............       
*..... before we apply the real boundary conditions ..........

      if( nproc .ne. 1 ) then
           call BCexec(pgm,rho,rho)
           call BCexec(pgm,ux,ux)
           call BCexec(pgm,uy,uy)
           call BCexec(pgm,uz,uz)
           call BCexec(pgm,press,press)
           call BCexec(pgm,temp,temp)
           if(do_scalar) call BCexec(pgm,scalar,scalar)
      endif

*>>>>>>>>>>>>>> X  bc's >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*

************* X0 *****************
      if( bx0 .eq. FLOWIN ) then
cccc.................
      endif
      if( bx0 .eq. FLOWOUT ) then
cccc.................
      endif
      if( bx0 .eq. NOFLOW ) then
cccc.................
      endif
      if( bx0 .eq. REFLECT ) then
cccc.................
      endif
      if( bx0 .eq. FIXED ) then
cccc.................
      endif
      if( bx0 .eq. SPECIAL ) then
cccc.................
      endif

************* X1 *****************
      if( bx1 .eq. FLOWIN ) then
cccc.................
      endif
      if( bx1 .eq. FLOWOUT ) then
cccc.................
      endif
      if( bx1 .eq. NOFLOW ) then
cccc.................
      endif
      if( bx1 .eq. REFLECT ) then
cccc.................
      endif
      if( bx1 .eq. FIXED ) then
cccc.................
      endif
      if( bx1 .eq. SPECIAL ) then
cccc.................
      endif

*>>>>>>>>>>>>>> Y  bc's >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*

************* Y0 *****************
      if( by0 .eq. FLOWIN ) then
cccc.................
      endif

      if( by0 .eq. FLOWOUT ) then
           Do iz = bz-bzgp, ez+ezgp
           Do iy = 1, bygp
           Do ix = bx-bxgp, ex+exgp
                 iy1 = by-iy
                 iy2 = by+iy-1
                 rho  (ix,iy1,iz) = rho  (ix,iy2,iz)
                 ux   (ix,iy1,iz) = ux   (ix,iy2,iz)
                 uy   (ix,iy1,iz) = uy   (ix,iy2,iz)
                 uz   (ix,iy1,iz) = uz   (ix,iy2,iz)
                 press(ix,iy1,iz) = press(ix,iy2,iz)
                 temp (ix,iy1,iz) = temp (ix,iy2,iz)
           End Do
           End Do
           End Do
           if( do_scalar ) then
              Do iz = bz-bzgp, ez+ezgp
              Do iy = 1, bygp
              Do ix = bx-bxgp, ex+exgp
                    iy1 = by-iy
                    iy2 = by+iy-1
                    scalar(ix,iy1,iz) = scalar(ix,iy2,iz)
              End Do
              End Do
              End Do           
           endif
      endif

      if( by0 .eq. NOFLOW ) then
cccc.................
      endif
      if( by0 .eq. REFLECT ) then
cccc.................
      endif
      if( by0 .eq. FIXED ) then
cccc.................
      endif
      if( by0 .eq. SPECIAL ) then
cccc.................
      endif

************* Y1 *****************
      if( by1 .eq. FLOWIN ) then
cccc.................
      endif

      if( by1 .eq. FLOWOUT ) then
           Do iz = bz-bzgp, ez+ezgp
           Do iy = 1, eygp
           Do ix = bx-bxgp, ex+exgp
                 iy1 = ey+iy
                 iy2 = ey-iy+1
                 rho  (ix,iy1,iz) = rho  (ix,iy2,iz)
                 ux   (ix,iy1,iz) = ux   (ix,iy2,iz)
                 uy   (ix,iy1,iz) = uy   (ix,iy2,iz)
                 uz   (ix,iy1,iz) = uz   (ix,iy2,iz)
                 press(ix,iy1,iz) = press(ix,iy2,iz)
                 temp (ix,iy1,iz) = temp (ix,iy2,iz)
           End Do
           End Do
           End Do
           if( do_scalar ) then
              Do iz = bz-bzgp, ez+ezgp
              Do iy = 1, eygp
              Do ix = bx-bxgp, ex+exgp
                    iy1 = ey+iy
                    iy2 = ey-iy+1
                    scalar(ix,iy1,iz) = scalar(ix,iy2,iz)
              End Do
              End Do
              End Do           
           endif
      endif

      if( by1 .eq. NOFLOW ) then
cccc.................
      endif
      if( by1 .eq. REFLECT ) then
cccc.................
      endif
      if( by1 .eq. FIXED ) then
cccc.................
      endif
      if( by1 .eq. SPECIAL ) then
cccc.................
      endif


*>>>>>>>>>>>>>> Z  bc's >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*

************* Z0 *****************
      if( bz0 .eq. FLOWIN ) then
cccc.................
      endif

      if( bz0 .eq. FLOWOUT ) then
           Do iz = 1, bzgp
           Do iy = by-bygp, ey+eygp
           Do ix = bx-bxgp, ex+exgp
                 iz1 = bz-iz
                 iz2 = bz+iz-1
                 rho  (ix,iy,iz1) = rho  (ix,iy,iz2)
                 ux   (ix,iy,iz1) = ux   (ix,iy,iz2)
                 uy   (ix,iy,iz1) = uy   (ix,iy,iz2)
                 uz   (ix,iy,iz1) = uz   (ix,iy,iz2)
                 press(ix,iy,iz1) = press(ix,iy,iz2)
                 temp (ix,iy,iz1) = temp (ix,iy,iz2)
           End Do
           End Do
           End Do
           if( do_scalar ) then
              Do iz = 1, bzgp
              Do iy = by-bygp, ey+eygp
              Do ix = bx-bxgp, ex+exgp
                    iz1 = bz-iz
                    iz2 = bz+iz-1
                    scalar(ix,iy,iz1) = scalar(ix,iy,iz2)
              End Do
              End Do
              End Do           
           endif
      endif

      if( bz0 .eq. NOFLOW ) then
cccc.................
      endif
      if( bz0 .eq. REFLECT ) then
cccc.................
      endif
      if( bz0 .eq. FIXED ) then
cccc.................
      endif
      if( bz0 .eq. SPECIAL ) then
cccc.................
      endif

************* Z1 *****************
      if( bz1 .eq. FLOWIN ) then
cccc.................
      endif

      if( bz1 .eq. FLOWOUT ) then
           Do iz = 1, ezgp
           Do iy = by-bygp, ey+eygp
           Do ix = bx-bxgp, ex+exgp
                 iz1 = ez+iz
                 iz2 = ez-iz+1
                 rho  (ix,iy,iz1) = rho  (ix,iy,iz2)
                 ux   (ix,iy,iz1) = ux   (ix,iy,iz2)
                 uy   (ix,iy,iz1) = uy   (ix,iy,iz2)
                 uz   (ix,iy,iz1) = uz   (ix,iy,iz2)
                 press(ix,iy,iz1) = press(ix,iy,iz2)
                 temp (ix,iy,iz1) = temp (ix,iy,iz2)
           End Do
           End Do
           End Do
           if( do_scalar ) then
              Do iz = 1, ezgp
              Do iy = by-bygp, ey+eygp
              Do ix = bx-bxgp, ex+exgp
                    iz1 = ez+iz
                    iz2 = ez-iz+1
                    scalar(ix,iy,iz1) = scalar(ix,iy,iz2)
              End Do
              End Do
              End Do           
           endif
      endif

      if( bz1 .eq. NOFLOW ) then
cccc.................
      endif
      if( bz1 .eq. REFLECT ) then
cccc.................
      endif
      if( bz1 .eq. FIXED ) then
cccc.................
      endif
      if( bz1 .eq. SPECIAL ) then
cccc.................
      endif

*>>>>>>>>>>>>>>> SPECIAL CASES: PRIODIC bc's and NPROC = 1 >>>>>>>>

***** X - PERIODIC bc's with NPROC = 1 ****
      if( bx0 .eq. PERIOD .and. nproc .eq. 1 ) then

           Do iz = bz-bzgp, ez+ezgp
           Do iy = by-bygp, ey+eygp
           Do ix = 1, bxgp

                 ix1 = bx-ix
                 ix2 = ex-ix+1
                 ix3 = ex+ix
                 ix4 = bx+ix-1

                 rho  (ix1,iy,iz) = rho  (ix2,iy,iz)
                 ux   (ix1,iy,iz) = ux   (ix2,iy,iz)
                 uy   (ix1,iy,iz) = uy   (ix2,iy,iz)
                 uz   (ix1,iy,iz) = uz   (ix2,iy,iz)
                 press(ix1,iy,iz) = press(ix2,iy,iz)
                 temp (ix1,iy,iz) = temp (ix2,iy,iz)

                 rho  (ix3,iy,iz) = rho  (ix4,iy,iz)
                 ux   (ix3,iy,iz) = ux   (ix4,iy,iz)
                 uy   (ix3,iy,iz) = uy   (ix4,iy,iz)
                 uz   (ix3,iy,iz) = uz   (ix4,iy,iz)
                 press(ix3,iy,iz) = press(ix4,iy,iz)
                 temp (ix3,iy,iz) = temp (ix4,iy,iz)

           End Do
           End Do
           End Do 
           if( do_scalar ) then
              Do iz = bz-bzgp, ez+ezgp
              Do iy = by-bygp, ey+eygp
              Do ix = 1, bxgp
                    ix1 = bx-ix
                    ix2 = ex-ix+1
                    ix3 = ex+ix
                    ix4 = bx+ix-1
                    scalar(ix1,iy,iz) = scalar(ix2,iy,iz)
                    scalar(ix3,iy,iz) = scalar(ix4,iy,iz) 
              End Do
              End Do
              End Do           
           endif 
      endif

***** Y - PERIODIC bc's with NPROC = 1 ****
      if( by0 .eq. PERIOD .and. nproc .eq. 1 ) then

           Do iz = bz-bzgp, ez+ezgp
           Do iy = 1, bygp
           Do ix = bx-bxgp, ex+exgp
              
                 iy1 = by-iy
                 iy2 = ey-iy+1
                 iy3 = ey+iy
                 iy4 = by+iy-1

                 rho  (ix,iy1,iz) = rho  (ix,iy2,iz)
                 ux   (ix,iy1,iz) = ux   (ix,iy2,iz)
                 uy   (ix,iy1,iz) = uy   (ix,iy2,iz)
                 uz   (ix,iy1,iz) = uz   (ix,iy2,iz)
                 press(ix,iy1,iz) = press(ix,iy2,iz)
                 temp (ix,iy1,iz) = temp (ix,iy2,iz)

                 rho  (ix,iy3,iz) = rho  (ix,iy4,iz)
                 ux   (ix,iy3,iz) = ux   (ix,iy4,iz)
                 uy   (ix,iy3,iz) = uy   (ix,iy4,iz)
                 uz   (ix,iy3,iz) = uz   (ix,iy4,iz)
                 press(ix,iy3,iz) = press(ix,iy4,iz)
                 temp (ix,iy3,iz) = temp (ix,iy4,iz)

           End Do
           End Do
           End Do

           if( do_scalar ) then
              Do iz = bz-bzgp, ez+ezgp
              Do iy = 1, bygp
              Do ix = bx-bxgp, ex+exgp
                    iy1 = by-iy
                    iy2 = ey-iy+1
                    iy3 = ey+iy
                    iy4 = by+iy-1
                    scalar(ix,iy1,iz) = scalar(ix,iy2,iz)
                    scalar(ix,iy3,iz) = scalar(ix,iy4,iz)
              End Do
              End Do
              End Do           
           endif 
    
      endif

***** Z - PERIODIC bc's with NPROC = 1 ****
      if( bz0 .eq. PERIOD .and. nproc .eq. 1 ) then

           Do iz = 1, bzgp
           Do iy = by-bygp, ey+eygp
           Do ix = bx-bxgp, ex+exgp
              
                 iz1 = bz-iz
                 iz2 = ez-iz+1
                 iz3 = ez+iz
                 iz4 = bz+iz-1

                 rho  (ix,iy,iz1) = rho  (ix,iy,iz2)
                 ux   (ix,iy,iz1) = ux   (ix,iy,iz2)
                 uy   (ix,iy,iz1) = uy   (ix,iy,iz2)
                 uz   (ix,iy,iz1) = uz   (ix,iy,iz2)
                 press(ix,iy,iz1) = press(ix,iy,iz2)
                 temp (ix,iy,iz1) = temp (ix,iy,iz2)

                 rho  (ix,iy,iz3) = rho  (ix,iy,iz4)
                 ux   (ix,iy,iz3) = ux   (ix,iy,iz4)
                 uy   (ix,iy,iz3) = uy   (ix,iy,iz4)
                 uz   (ix,iy,iz3) = uz   (ix,iy,iz4)
                 press(ix,iy,iz3) = press(ix,iy,iz4)
                 temp (ix,iy,iz3) = temp (ix,iy,iz4)

           End Do
           End Do
           End Do  

           if( do_scalar ) then
              Do iz = 1, bzgp
              Do iy = by-bygp, ey+eygp
              Do ix = bx-bxgp, ex+exgp
                    iz1 = bz-iz
                    iz2 = ez-iz+1
                    iz3 = ez+iz
                    iz4 = bz+iz-1
                    scalar(ix,iy,iz1) = scalar(ix,iy,iz2)
                    scalar(ix,iy,iz3) = scalar(ix,iy,iz4)
              End Do
              End Do
              End Do           
           endif 
  
      endif

      return
      end

**************************************************************
*/*F
**************************************************
*                                                *
*  subroutine BC_POISSON_3D                      *
*                                                *
*  Specifiy boundary conditions for the poisson  *
*  solver for gravity.                           *
*                                                *
*    Author: Andrea Malagoli                     *
*    Date: 16 June 1995                          *
*                                                *
**************************************************
*F*/
       subroutine bc_self_grav(sz,mg,proc,pgm,  phi, dx,dy,dz,
     &   bx,ex,bxgp,exgp, by,ey,bygp,eygp, bz,ez,bzgp,ezgp,
     &                   grid_par )
      include 'meshf.h'
c      include 'grid.h'
      include 'param.h'
      parameter(ndim = 3)
      integer sz(sz_0:sz_1,ndim)
      integer mg(mg_0:mg_1,ndim)
      integer proc(p_0:p_1), pgm(1)

      dimension phi(bx-bxgp:ex+exgp,by-bygp:ey+eygp,bz-bzgp:ez+ezgp)
*............. Local Variables ...............*
      data one /1.d0/
      integer bx0, bx1, by0, by1, bz0,bz1
*.............................................*

      nproc = proc(p_np)

      nlev = mg(mg_nlev,1)
      ilev = mg(mg_mlev,1)
      iplev = mg(mg_plev,1)

c      print*,proc(p_id),' BC ',nlev,ilev,ex,ey,ez

*..... Default boundary values are COMM .................*

      bx0 = COMM
      bx1 = COMM
      by0 = COMM
      by1 = COMM
      bz0 = COMM
      bz1 = COMM

*..... Begin by verifying that we have some real boundaries .....

*.... this is the global size .....
      nx = sz(sz_mdim,1) 
      ny = sz(sz_mdim,2) 
      nz = sz(sz_mdim,3) 

      if( bx .eq.  1 ) bx0 = grid_par( 5)
      if( ex .eq. nx ) bx1 = grid_par( 6)
      if( by .eq.  1 ) by0 = grid_par(11)
      if( ey .eq. ny ) by1 = grid_par(12)
      if( bz .eq.  1 ) bz0 = grid_par(17)
      if( ez .eq. nz ) bz1 = grid_par(18)

*..... Now we are ready to do the data exchange ..............       
*..... before we apply the real boundary conditions ..........

      if( nproc .ne. 1 .and. ilev.le.iplev ) then
           call BCexec(pgm,phi,phi)
      endif

*>>>>>>>>>>>>>>> SPECIAL CASES: PRIODIC bc's and NPROC = 1 >>>>>>>>

***** X - PERIODIC bc's with NPROC = 1 ****
      if( bx0 .eq. PERIOD .and. nproc .eq. 1 .or. ilev.gt.iplev) then

           Do iz = bz-bzgp, ez+ezgp
           Do iy = by-bygp, ey+eygp
           Do ix = 1, bxgp
                 ix1 = bx-ix
                 ix2 = ex-ix+1
                 ix3 = ex+ix
                 ix4 = bx+ix-1
                   phi(ix1,iy,iz) = phi(ix2,iy,iz)
                   phi(ix3,iy,iz) = phi(ix4,iy,iz)
           End Do
           End Do
           End Do 
 
      endif

***** Y - PERIODIC bc's with NPROC = 1 ****
      if( by0 .eq. PERIOD .and. nproc .eq. 1 .or. ilev.gt.iplev) then
           Do iz = bz-bzgp, ez+ezgp
           Do iy = 1, bygp
           Do ix = bx-bxgp, ex+exgp              
                 iy1 = by-iy
                 iy2 = ey-iy+1
                 iy3 = ey+iy
                 iy4 = by+iy-1
                 phi(ix,iy1,iz) = phi(ix,iy2,iz)
                 phi(ix,iy3,iz) = phi(ix,iy4,iz)
           End Do
           End Do
           End Do
    
      endif

***** Z - PERIODIC bc's with NPROC = 1 ****
      if( bz0 .eq. PERIOD .and. nproc .eq. 1 .or. ilev.gt.iplev) then

           Do iz = 1, bzgp
           Do iy = by-bygp, ey+eygp
           Do ix = bx-bxgp, ex+exgp              
                 iz1 = bz-iz
                 iz2 = ez-iz+1
                 iz3 = ez+iz
                 iz4 = bz+iz-1
                 phi(ix,iy,iz1) = phi(ix,iy,iz2)
                 phi(ix,iy,iz3) = phi(ix,iy,iz4)
           End Do
           End Do
           End Do  
  
      endif

      Return
      End

**************************************************************
