
#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "meshc.h"


#ifdef HAS_HASH
#define restart_io restart_io_
#endif

#ifdef HAS_CAP
#define restart_io RESTART_IO
#endif
 
/*..................................................................*/
/*.... This is the restart file ....................................*/
/*..................................................................*/
void restart_io(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,aux,mode)
ALArrayPart *sz;
char *filename, *mode;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *aux;
{	
        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

	register int i, j, k, ind, ind2, ind3; 
        int size, siz, sizx, sizy, sizz, sxy;
	int buflen, hd, count,nstep,ndim = 3;
	char prefix[80];
	char out[100];
        int (*io)(), read_buffer(), write_buffer();
        char rd = 'r', wr = 'w'; int op;
	float par[6]; int gdim[3];
	int fp;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        AL_get_array_lsize(&size,sz,&ndim);

        AL_get_global_dim(gdim,sz,&ndim);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        buflen = (ex-bx+1)*(ey-by+1)*sizeof(array);
	hd = 6*sizeof(float);

        nstep = out_par[0];

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/
/*         sprintf(out, "%s.%04d", prefix, nstep); /**/
        sprintf(out, "%s", prefix); /**/

	fp = open_file(out, O_RDWR|O_CREAT);
/*............................................................*/
/* This is a fancy use of C pointers to functions
 * We use a read or write depending on the mode
 */
	if( strncasecmp(mode,&wr,1) == 0 ) {io = write_buffer; op=0;}
	if( strncasecmp(mode,&rd,1) == 0 ) {io = read_buffer ; op=1;}

/*............................................................*/

/*......................................................................*/
        if( !op ) {                     /* Write the parameters */
             par[0] = sz->mdim;           /* nx */
             par[1] = (sz+1)->mdim;       /* ny */
             par[2] = (sz+2)->mdim;       /* nz */
             par[3] = step_par[0];        /* nstep */
             par[4] = step_par[1];        /* time */
             par[5] = step_par[9];        /* dt */
             write_arr( fp, 0, par, hd, 0);
        } else {
             read_arr( fp, 0, par,hd, 0);
             if( sz->mdim != par[0] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NX in input: %d",sz->mdim,par[0]);
             }
             if( (sz+1)->mdim != par[1] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NY in input: %d",sz->mdim,par[0]);
             }
             if( (sz+2)->mdim != par[2] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NZ in input: %d",sz->mdim,par[0]);
             }
             step_par[0] = par[3];        /* nstep */
             step_par[1] = par[4];        /* time */
             step_par[9] = par[5];        /* dt */
             out_par[0] = par[3];        /* nstep */
             out_par[1] = par[4];        /* time */
         }
/*......................................................................*/
    
/*.....    Density  ................. */
        count = 0;
        count = (*io)(rho,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....    X-velocity............... */
      
        count = (*io)(ux,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Y-velocity............... */
        
        count = (*io)(uy,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Z-velocity............... */
        
        count = (*io)(uz,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Temperature ............... */
       
        count = (*io)(temp,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Pressure ............... */
       
        count = (*io)(press,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*....................................*/
        close(fp);
}



