/* The parallel IO version */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>

#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"
#include "meshc.h"

#include <unistd.h>
#include "uni_def.h"


#ifdef HAS_HASH
#define restart_io restart_io_
#endif
#ifdef HAS_CAP
#define restart_io RESTART_IO
#endif

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/
/*.... This is the restart file ....................................*/
/*..................................................................*/
void restart_io(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,aux,mode)
ALArrayPart *sz;
char *filename, *mode;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho;
#ifdef FORCE_SINGLE_OUTPUT
float *aux;
#else
array *aux;
#endif
#ifdef PARALLEL_RESTART
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy;
	int buflen, hd, count,nstep,ndim = 3;
	char prefix[80];
	char out[100];
        char rd = 'r', wr = 'w';
	PIFILE *fp; 
        PIArrayPart zz[3];
        float par[6];
        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;

/*	printf("In PIO %d %d %d %d %d %d\n",bx,ex,by,ey,bz,ez); /**/

/*.....................................................................*/
        /* Create the file name and open the file
         * Here we do it only at the beginning, and
         * then we hope that the file will accumulate
         * sequentially onto the first file
         */
#ifdef HAS_UNITREE
        has_unitree = PIOAddUnitree();
#endif

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/

#ifdef HAS_UNITREE
        /*--Form the Unitree extension--*/
        sprintf(out, "%s%s", UNITREE_DIR, prefix);
#else        
        sprintf(out, "%s%s", PIOFS_DIR,prefix); /**/
#endif

        set_zz_restart(zz,sz);        

        PIgsync(PIAllProcs);
        PIFSetWritersBlock(); /**/

/*--------------- WRITE THE RESTART FILE ------------------*/
     if( strncasecmp(mode,&wr,1) == 0 ){

        fp = PIFopen(out,PIAllProcs,O_RDWR|O_CREAT,PIO_AS_SEQUENTIAL,-1);
        PIFCacheEnable( fp, wsize, rsize ); /**/

/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[0];   /* nstep */
        par[4] = step_par[1];   /* time */
        par[5] = step_par[9];   /* dt */

        PIWriteCommon( fp, NULL, sizeof(float), par, 6, MSG_FLT );
/*......................................................................*/
#ifdef FORCE_SINGLE_OUTPUT
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(rho+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(ux+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uy+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uz+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(temp+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(press+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
#else
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, rho, MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, ux , MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, uy , MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, uz , MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, temp, MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, press, MSG_DBL);
#endif
/*......................................................................*/
    }

/*--------------- READ THE RESTART FILE ------------------*/
    if( strncasecmp(mode,&rd,1) == 0 ){

        fp = PIFopen(out,PIAllProcs,O_RDWR,PIO_AS_SEQUENTIAL,-1);
        PIFCacheEnable( fp, wsize, rsize ); /**/

/*......................................................................*/
        PIReadCommon( fp, NULL, sizeof(float), par, 6, MSG_FLT );

/*
             if( sz->mdim != par[0] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NX in input: %d",sz->mdim,par[0]);
             }
             if( (sz+1)->mdim != par[1] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NY in input: %d",sz->mdim,par[0]);
             }
             if( (sz+2)->mdim != par[2] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NZ in input: %d",sz->mdim,par[0]);
             }
*/
             step_par[0] = par[3];        /* nstep */
             step_par[1] = par[4];        /* time */
             step_par[9] = par[5];        /* dt */
             out_par[0] = par[3];        /* nstep */
             out_par[1] = par[4];        /* time */
      printf("Time %f \n",par[4]);
/*......................................................................*/
/*......................................................................*/
#ifdef FORCE_SINGLE_OUTPUT
      printf("Reading rho %d  %d\n",rsize, wsize);
    PIReadDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      printf("Read rho %d \n",siz);
      for(i=0;i<siz-1;i++) *(rho+i) = (float)( *(aux+i) );
      printf("Reading ux\n");
    PIReadDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(ux+i) = (float)( *(aux+i) );
    PIReadDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(uy+i) = (float)( *(aux+i) );
    PIReadDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(uz+i) = (float)( *(aux+i) );
    PIReadDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
       for(i=0;i<siz-1;i++) *(temp+i) = (float)( *(aux+i) );
    PIReadDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
       for(i=0;i<siz-1;i++) *(press+i) = (float)( *(aux+i) );
#else
    PIReadDistributedArray(fp,NULL,sizeof(array), zz, 3, rho, MSG_DBL);
    PIReadDistributedArray(fp,NULL,sizeof(array), zz, 3, ux , MSG_DBL);
    PIReadDistributedArray(fp,NULL,sizeof(array), zz, 3, uy , MSG_DBL);
    PIReadDistributedArray(fp,NULL,sizeof(array), zz, 3, uz , MSG_DBL);
    PIReadDistributedArray(fp,NULL,sizeof(array), zz, 3, temp, MSG_DBL);
    PIReadDistributedArray(fp,NULL,sizeof(array), zz, 3, press, MSG_DBL);
#endif
/*......................................................................*/

    }
/*--------------------------------------------------------*/

    PIFflush(fp);
    PIFclose(fp);
    PIgsync(PIAllProcs);

}

/*......................................................................*/

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/ 
/*.... ....................................................*/
/* Set up the array descriptor for the IO routines */
/* This is clumsy, but you do it only once... */
set_zz_restart(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;
        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end+sz[k].eg-sz[k].start+sz[k].sg+1;
           zz[k].start = sz[k].sg;
           zz[k].end   = sz[k].end+sz[k].eg-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
        }
}
/*..................................................................*/
/* If esle ifndef PARALLEL_RESTART we want sequential instead ...*/
#else
{	
        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

	register int i, j, k, ind, ind2, ind3;
        int myid; 
        int size, siz, sizx, sizy, sizz, sxy;
	int buflen, hd, count,nstep,ndim = 3;
	char prefix[80];
	char out[100];
        int (*io)(), read_buffer(), write_buffer();
        char rd = 'r', wr = 'w'; int op;
	float par[6]; int gdim[3];
	int fp;

        myid = PImytid;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        AL_get_array_tsize(&size,sz,&ndim);

        AL_get_global_dim(gdim,sz,&ndim);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        buflen = (ex-bx+1)*(ey-by+1)*sizeof(array);
	hd = 6*sizeof(float);

        nstep = out_par[0];

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/

/* Each restart file has its little PROC ID appended /**/
        sprintf(out, "%s%s.%03d", PIOFS_DIR,prefix,myid); /**/

	fp = open_file(out, O_RDWR|O_CREAT);
/*............................................................*/
/* This is a fancy use of C pointers to functions
 * We use a read or write depending on the mode
 */
	if( strncasecmp(mode,&wr,1) == 0 ) {io = write_buffer; op=0;}
	if( strncasecmp(mode,&rd,1) == 0 ) {io = read_buffer ; op=1;}

/*............................................................*/

/*......................................................................*/
        if( !op ) {                     /* Write the parameters */
             par[0] = sz->mdim;           /* nx */
             par[1] = (sz+1)->mdim;       /* ny */
             par[2] = (sz+2)->mdim;       /* nz */
             par[3] = step_par[0];        /* nstep */
             par[4] = step_par[1];        /* time */
             par[5] = step_par[9];        /* dt */
             write_arr( fp, 0, par, hd, 0);
        } else {
             read_arr( fp, 0, par,hd, 0);
             if( sz->mdim != par[0] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NX in input: %d",sz->mdim,par[0]);
             }
             if( (sz+1)->mdim != par[1] ){
                printf("Warning in RESTART.\n");
         printf("    NY declared: %d   NY in input: %d",(sz+1)->mdim,par[1]);
             }
             if( (sz+2)->mdim != par[2] ){
                printf("Warning in RESTART.\n");
         printf("    NZ declared: %d   NZ in input: %d",(sz+2)->mdim,par[2]);
             }
             step_par[0] = par[3];        /* nstep */
             step_par[1] = par[4];        /* time */
             step_par[9] = par[5];        /* dt */
             out_par[0] = par[3];        /* nstep */
             out_par[1] = par[4];        /* time */
         }
/*......................................................................*/
    
/*.....    Density  ................. */
        count = 0;
        count = (*io)(rho,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....    X-velocity............... */
      
        count = (*io)(ux,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Y-velocity............... */
        
        count = (*io)(uy,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Z-velocity............... */
        
        count = (*io)(uz,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Temperature ............... */
       
        count = (*io)(temp,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....   Pressure ............... */
       
        count = (*io)(press,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*....................................*/
        close(fp);
}
#endif
