/* The parallel IO version */

#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include "meshc.h"

#ifdef FORTRANUNDERSCORE
#define restart_io restart_io_
#endif
#ifdef HAS_CAP
#define restart_io RESTART_IO
#endif

#ifndef HAS_IO

void restart_io(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,scalar, aux,mode)
ALArrayPart *sz;
char *filename, *mode;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *scalar;
#ifdef FORCE_SINGLE_OUTPUT
float *aux;
#else
array *aux;
#endif
{	
  printf("Not doing restart_io right now...\n");
}

#else

#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"

#include <unistd.h>
#include "uni_def.h"

int Open(), Close(), WriteDistributedArray(), ReadDistributedArray();

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/
/*.... This is the restart file ....................................*/
/*..................................................................*/
void restart_io(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,scalar, aux,mode)
ALArrayPart *sz;
char *filename, *mode;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *scalar;
#ifdef FORCE_SINGLE_OUTPUT
float *aux;
#else
array *aux;
#endif
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy;
	int buflen, hd, count,nstep,ndim = 3;
	char prefix[80];
	char out[10][100];
        char rd = 'r', wr = 'w';
        char *vars[] = {"dens", "ux", "uy", "uz", "temp", "press", "scalar", "param"};
        int nvars = 7;
	int fp[10]; 
        PIFILE *fpc;
        PIArrayPart zz[3];
        float par[6];
        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;

/*	printf("In PIO %d %d %d %d %d %d\n",bx,ex,by,ey,bz,ez); */

/*.....................................................................*/
        /* Create the file name and open the file
         * Here we do it only at the beginning, and
         * then we hope that the file will accumulate
         * sequentially onto the first file
         */

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/


        /*--Form the Unitree extension--*/
        for(i=0; i<= nvars; i++){


           if( i < nvars ){
                    sprintf(out[i], "%sRestart/%s", UNITREE_DIR, vars[i]);
                    fp[i] = Open(out[i]);
/*                    printf("Opening %s   %d\n",out[i],fp[i]); */ /* DEBUG */
           } else {
                   sprintf(out[i], "unitree:%sRestart/%s", UNITREE_DIR, vars[i]);
                   has_unitree = PIOAddUnitree();
                   fpc = PIFopen(out[i],PIAllProcs,O_RDWR|O_CREAT,PIO_AS_SEQUENTIAL,-1);
           }
        }

        set_zz_restart(zz,sz);        

        PIgsync(PIAllProcs);

/*--------------- WRITE THE RESTART FILE ------------------*/
     if( strncasecmp(mode,&wr,1) == 0 ){

/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[0];   /* nstep */
        par[4] = step_par[1];   /* time */
        par[5] = step_par[9];   /* dt */

        PIWriteCommon( fpc, NULL, sizeof(float), par, 6, MSG_FLT );
/*......................................................................*/
#ifdef FORCE_SINGLE_OUTPUT
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(rho+i) );
    WriteDistributedArray(fp[0],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(ux+i) );
    WriteDistributedArray(fp[1],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uy+i) );
    WriteDistributedArray(fp[2],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uz+i) );
    WriteDistributedArray(fp[3],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(temp+i) );
    WriteDistributedArray(fp[4],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(press+i) );
    WriteDistributedArray(fp[5],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
#ifdef DO_PASSIVE_SCALAR
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(scalar+i) );
    WriteDistributedArray(fp[6],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
#endif
#else
    WriteDistributedArray(fp[0],NULL,sizeof(array), zz, 3, rho, MSG_DBL);
    WriteDistributedArray(fp[1],NULL,sizeof(array), zz, 3, ux , MSG_DBL);
    WriteDistributedArray(fp[2],NULL,sizeof(array), zz, 3, uy , MSG_DBL);
    WriteDistributedArray(fp[3],NULL,sizeof(array), zz, 3, uz , MSG_DBL);
    WriteDistributedArray(fp[4],NULL,sizeof(array), zz, 3, temp, MSG_DBL);
    WriteDistributedArray(fp[5],NULL,sizeof(array), zz, 3, press, MSG_DBL);
#ifdef DO_PASSIVE_SCALAR
    WriteDistributedArray(fp[6],NULL,sizeof(float), zz, 3, scalar, MSG_DBL);
#endif
#endif
/*......................................................................*/
    }

/*--------------- READ THE RESTART FILE ------------------*/
    if( strncasecmp(mode,&rd,1) == 0 ){

/*......................................................................*/
        PIReadCommon( fpc, NULL, sizeof(float), par, 6, MSG_FLT );

/*
             if( sz->mdim != par[0] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NX in input: %d",sz->mdim,par[0]);
             }
             if( (sz+1)->mdim != par[1] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NY in input: %d",sz->mdim,par[0]);
             }
             if( (sz+2)->mdim != par[2] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NZ in input: %d",sz->mdim,par[0]);
             }
*/
             step_par[0] = par[3];        /* nstep */
             step_par[1] = par[4];        /* time */
             step_par[9] = par[5];        /* dt */
             out_par[0] = par[3];        /* nstep */
             out_par[1] = par[4];        /* time */

/*......................................................................*/
/*......................................................................*/
#ifdef FORCE_SINGLE_OUTPUT
    ReadDistributedArray(fp[0],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(rho+i) = (float)( *(aux+i) );
    ReadDistributedArray(fp[1],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(ux+i) = (float)( *(aux+i) );
    ReadDistributedArray(fp[2],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(uy+i) = (float)( *(aux+i) );
    ReadDistributedArray(fp[3],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(uz+i) = (float)( *(aux+i) );
    ReadDistributedArray(fp[4],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
       for(i=0;i<siz-1;i++) *(temp+i) = (float)( *(aux+i) );
    ReadDistributedArray(fp[5],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
       for(i=0;i<siz-1;i++) *(press+i) = (float)( *(aux+i) );
#ifdef DO_PASSIVE_SCALAR   
       ReadDistributedArray(fp[6],NULL,sizeof(float), zz, 3, aux, MSG_FLT);
       for(i=0;i<siz-1;i++) *(scalar+i) = (float)( *(aux+i) );
#endif
#else
    ReadDistributedArray(fp[0],NULL,sizeof(array), zz, 3, rho, MSG_DBL);
    ReadDistributedArray(fp[1],NULL,sizeof(array), zz, 3, ux , MSG_DBL);
    ReadDistributedArray(fp[2],NULL,sizeof(array), zz, 3, uy , MSG_DBL);
    ReadDistributedArray(fp[3],NULL,sizeof(array), zz, 3, uz , MSG_DBL);
    ReadDistributedArray(fp[4],NULL,sizeof(array), zz, 3, temp, MSG_DBL);
    ReadDistributedArray(fp[5],NULL,sizeof(array), zz, 3, press, MSG_DBL);
#ifdef DO_PASSIVE_SCALAR
    ReadDistributedArray(fp[5],NULL,sizeof(array), zz, 3, scalar, MSG_DBL);
#endif
#endif
/*......................................................................*/

    }
/*--------------------------------------------------------*/

    for(i=0; i<nvars; i++) Close(fp[i]);
    PIFclose(fpc);
    PIgsync(PIAllProcs);

}

/*......................................................................*/

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/ 
/*.... ....................................................*/
/* Set up the array descriptor for the IO routines */
/* This is clumsy, but you do it only once... */
set_zz_restart(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;
        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end+sz[k].eg-sz[k].start+sz[k].sg+1;
           zz[k].start = sz[k].sg;
           zz[k].end   = sz[k].end+sz[k].eg-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
        }
}
/*..................................................................*/

#endif
