/* The parallel IO version */

#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include "meshc.h"

#ifdef FORTRANUNDERSCORE
#define dump_raster_3d dump_raster_3d_
#endif

#ifdef HAS_CAP
#define dump_raster_3d DUMP_RASTER_3D
#endif

#ifndef HAS_IO

void dump_raster_3d(sz,filename,step_par,out_par,arr,arrmax,arrmin)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *arr, *arrmax, *arrmin;
{	
  printf("Not doing dump_raster_3d right now...\n");
}

#else

#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"

#include <unistd.h>
#include "uni_def.h"

/*..................................................................*/
void dump_raster_3d(sz,filename,step_par,out_par,arr,arrmax,arrmin)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *arr, *arrmax, *arrmin;
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy,buflen;
	int nstep, ndim = 3, pset;
	char prefix[80];
	char out[100];
	PIFILE *fp;
        PIArrayPart zz[3];
        float par[6]; int gdim[3];
/*        unsigned char *rast; */
        unsigned char rast[128*128*128];
	static int alloc_rast = 0;
        int myid;

        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

        myid = PImytid;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;
        buflen = (ex-bx+1)*(ey-by+1)*(ez-bz+1)*sizeof(unsigned char);

        if( buflen > MAX_RAST_LEN ){
            printf("DUMP_RASTER_3D: buflen exceeds MAX_RAST_LEN\n");
        }

/* Here we allocate rast once at the beginning, then we keep it
   this way, to avoid possible failures in malloc later */
/*
        if( alloc_rast == 0 ){
           rast = (unsigned char *)malloc(buflen);
           if( !rast ) printf("%d Warning: rast allocation failed \n",myid);
           alloc_rast = 1;
        }
*/

/*	printf("In PIO %d %d %d %d %d %d\n",bx,ex,by,ey,bz,ez); */

        /* ..... get max and min of the array to dump .....*/
	pset = 0;
        if( *arrmax == 0.0 && *arrmin == 0.0 )
        AL_get_maxmin(arrmax,arrmin,arr,sz,&ndim,&pset);
        
/*..... Form the raster array ...........*/        
        AL_from_array_to_rast3d(rast,arr,arrmax,arrmin,
     &bx,&ex,&bxgp,&exgp, &by,&ey,&bygp,&eygp, &bz,&ez,&bzgp,&ezgp ); 
/*.....................................................................*/
        /* Create the file name and open the file
         * Here we do it only at the beginning, and
         * then we hope that the file will accumulate
         * sequentially onto the first file
         */
#ifdef HAS_UNITREE
        has_unitree = PIOAddUnitree();
#endif

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/

        nstep = step_par[0]; /*Step from the beginning of the simulation*/

#ifdef HAS_UNITREE
        /*--Form the Unitree extension--*/
        sprintf(out, "unitree:%s%s.%04d", UNITREE_DIR, prefix, nstep);
#else        
        sprintf(out, "%s.%04d", prefix, nstep); */
#endif

        set_zz_3d_raster(zz,sz);        

        PIgsync(PIAllProcs); /**/
        PIFSetWritersBlock(); /**/
        fp = PIFopen(out,PIAllProcs,O_RDWR|O_CREAT,PIO_AS_SEQUENTIAL,-1);
        PIFCacheEnable( fp, wsize, rsize ); /**/

/*.... Write parameters .............................................. */
/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[1];        /* time */
        par[4] = *arrmax;             /* max arr */
        par[5] = *arrmin;             /* min arr */

        PIWriteCommon( fp, NULL, sizeof(float), par, 6, MSG_FLT );
/*......................................................................*/


/*......................................................................*/
    PIWriteDistributedArray(fp,NULL,sizeof(char), zz, 3, rast, MSG_OTHER);
/*......................................................................*/

    PIFflush(fp);
    PIFclose(fp);
    PIgsync(PIAllProcs);

/* We allocate the rast vector at the beginning, then we do not do
   anthing any more */
/*    free(rast); */

}


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/ 
/*.... ....................................................*/
/* Set up the array descriptor for the 3D raster routines */
/* This is clumsy, but you do it only once... */
set_zz_3d_raster(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;
        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end-sz[k].start+1;
           zz[k].start = 0;
           zz[k].end   = sz[k].end-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
        }
}
/*..................................................................*/

#endif
